/* mbed LED Font Library, for TM1638 LED controller
 * Copyright (c) 2015, v01: WH, Initial version, Test in LEDKEY8
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
#include "Font_7Seg.h"

// Select one of the testboards for TM1638 LED controller
#if (LEDKEY8_TEST == 1) 

//Mask for blending out and restoring Icons
const char MASK_ICON_GRID[][2] = {
                                   {LO(S7_ICON_GR1), HI(S7_ICON_GR1)},
                                   {LO(S7_ICON_GR2), HI(S7_ICON_GR2)},
                                   {LO(S7_ICON_GR3), HI(S7_ICON_GR3)},
                                   {LO(S7_ICON_GR4), HI(S7_ICON_GR4)},
                                   {LO(S7_ICON_GR5), HI(S7_ICON_GR5)},
                                   {LO(S7_ICON_GR6), HI(S7_ICON_GR6)},
                                   {LO(S7_ICON_GR7), HI(S7_ICON_GR7)},
                                   {LO(S7_ICON_GR8), HI(S7_ICON_GR8)},
                                   {LO(S7_ICON_GR9), HI(S7_ICON_GR9)},
                                   {LO(S7_ICON_GR10), HI(S7_ICON_GR10)}                                   
                                 };


// ASCII Font definition table for transmission to TM1638
//
//#define FONT_7S_START     0x20
//#define FONT_7S_END       0x7F
//#define FONT_7S_NR_CHARS (FONT_7_END - FONT_7S_START + 1)
 
const char FONT_7S[] = { 
                         C7_0, //48 0x30
                         C7_1,
                         C7_2,
                         C7_3,
                         C7_4,                   
                         C7_5,
                         C7_6,
                         C7_7,
                         C7_8,
                         C7_9,
                         C7_A, //65 0x41, A
                         C7_B,
                         C7_C,
                         C7_D,
                         C7_E,
                         C7_F
                             };// 127                             
  
#endif 