
#include "SWO.h"


/*********************************************************************
*
* Defines for Cortex-M debug unit
*/
#define ITM_STIM_U32(n) (*(volatile unsigned int*)(0xE0000000+4*n))  // Stimulus Port n Register word access
//#define ITM_STIM_U32_0  (*(volatile unsigned int*)0xE0000000)        // Stimulus Port 0 Register word access
//#define ITM_STIM_U8_0   (*(volatile         char*)0xE0000000)        // Stimulus Port 0 Register byte access
#define ITM_ENA         (*(volatile unsigned int*)0xE0000E00)        // Trace Enable Ports Register
#define ITM_TCR         (*(volatile unsigned int*)0xE0000E80)        // Trace control register



/*********************************************************************
*
* SWO_PrintChar()
*
* @brief 
*   Checks if SWO is set up. If it is not, return,
*    to avoid program hangs if no debugger is connected.
*   If it is set up, print a character to the ITM_STIM register
*    in order to provide data for SWO.
* @param c The Character to be printed.
* @notes   Additional checks for device specific registers can be added.
*/
void SWO_PrintChar(char c) {
  //
  // Check if ITM_TCR.ITMENA is set
  //
  if ((ITM_TCR & 1) == 0) {
    return;
  }
  //
  // Check if stimulus port is enabled
  //
  if ((ITM_ENA & 1) == 0) {
    return;
  }
  //
  // Wait until STIMx is ready,
  // then send data
  //
//  while ((ITM_STIM_U8(0) & 1) == 0);
//  ITM_STIM_U8(0) = c;

  while ((ITM_STIM_U32(0) & 1) == 0);
  ITM_STIM_U32(0) = c;
}

/*********************************************************************
*
* SWO_PrintString()
*
* @brief Print a string via SWO.
* @param *s The string to be printed.
*
*/
void SWO_PrintString(const char *s) {
  //
  // Print out character per character
  //
  while (*s) {
    SWO_PrintChar(*s++);
  }
}