/* mbed LED Font Library, for STM STLED316S controller
 * Copyright (c) 2016, v01: WH, Initial version
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
#ifndef MBED_FONT_7SEG_H
#define MBED_FONT_7SEG_H

// Select one of the testboards for STLED316S controller
#include "STLED316S_Config.h"

#if ((STLED316S_TEST == 1) || (ST316BOARD_TEST == 1))
// Segment bit positions for 7 Segment display using the test display mapping for STLED316S
// Modify this table for different 'bit-to-segment' mappings. The ASCII character defines and the FONT_7S const table below 
// will be adapted automatically according to the bit-to-segment mapping. Obviously this will only work when the segment
// mapping is identical for every digit position. This will be the case unless the hardware designer really hates software developers.
//
//            A
//          -----
//         |     |     
//       F |     | B    
//         |  G  |     
//          -----
//         |     |     
//       E |     | C    
//         |     |     
//          -----   * DP
//            D  
//
#define S7_A    0x01 
#define S7_B    0x02
#define S7_C    0x04
#define S7_D    0x08 
#define S7_E    0x10
#define S7_F    0x20
#define S7_G    0x40
#define S7_DP   0x80

//Mask for blending out and setting 7 segments digits
#define MASK_7S_ALL = (S7_A | S7_B | S7_C | S7_D | S7_E | S7_F | S7_G}
#endif


// ASCII Font definitions for segments in each character
//
//32 0x20  Symbols
#define C7_SPC  (0x0000)
#define C7_EXC  (S7_B | S7_C) //!
#define C7_QTE  (S7_B | S7_F) //"
#define C7_HSH  (S7_C | S7_D | S7_E | S7_G) //#
#define C7_DLR  (S7_A | S7_C | S7_D | S7_F | S7_G) //$
#define C7_PCT  (S7_C | S7_F) //%
#define C7_AMP  (S7_A | S7_C | S7_D | S7_E | S7_F | S7_G) //&
#define C7_ACC  (S7_B) //'
#define C7_LBR  (S7_A | S7_D | S7_E | S7_F) //(
#define C7_RBR  (S7_A | S7_B | S7_C | S7_D) //)
#define C7_MLT  (S7_B | S7_C | S7_E | S7_F | S7_G)  //*
#define C7_PLS  (S7_B | S7_C | S7_G) //+
#define C7_CMA  (S7_DP)
#define C7_MIN  (S7_G)
#define C7_DPT  (S7_DP)
#define C7_RS   (S7_B | S7_E  | S7_G)  // /

//48 0x30  Digits
#define C7_0    (S7_A | S7_B | S7_C | S7_D | S7_E | S7_F)
#define C7_1    (S7_B | S7_C)
#define C7_2    (S7_A | S7_B | S7_D | S7_E | S7_G)
#define C7_3    (S7_A | S7_B | S7_C | S7_D | S7_G)
#define C7_4    (S7_B | S7_C | S7_F | S7_G)
#define C7_5    (S7_A | S7_C | S7_D | S7_F | S7_G)
#define C7_6    (S7_A | S7_C | S7_D | S7_E | S7_F | S7_G)
#define C7_7    (S7_A | S7_B | S7_C)
#define C7_8    (S7_A | S7_B | S7_C | S7_D | S7_E | S7_F | S7_G)
#define C7_9    (S7_A | S7_B | S7_C | S7_D | S7_F | S7_G)

//58 0x3A
#define C7_COL  (S7_D | S7_G) // :
#define C7_SCL  (S7_D | S7_G) // ;
#define C7_LT   (S7_D | S7_E | S7_G)             // <
#define C7_EQ   (S7_D | S7_G)                    // =
#define C7_GT   (S7_C | S7_D | S7_G)             // >   
#define C7_QM   (S7_A | S7_B | S7_E | S7_G)      // ?
#define C7_AT   (S7_A | S7_B | S7_C | S7_D | S7_E  | S7_G)  // @

//65 0x41  Upper case alphabet
#define C7_A    (S7_A | S7_B | S7_C | S7_E | S7_F | S7_G )
#define C7_B    (S7_C | S7_D | S7_E | S7_F | S7_G)
#define C7_C    (S7_A | S7_D | S7_E | S7_F)
#define C7_D    (S7_B | S7_C | S7_D | S7_E | S7_G)
#define C7_E    (S7_A | S7_D | S7_E | S7_F | S7_G)
#define C7_F    (S7_A | S7_E | S7_F | S7_G)

#define C7_G    (S7_A | S7_C | S7_D | S7_E | S7_F)
#define C7_H    (S7_B | S7_C | S7_E | S7_F | S7_G)
#define C7_I    (S7_B | S7_C)
#define C7_J    (S7_B | S7_C | S7_D | S7_E)
#define C7_K    (S7_B | S7_C | S7_E | S7_F | S7_G)
#define C7_L    (S7_D | S7_E | S7_F)
#define C7_M    (S7_A | S7_C | S7_E)
#define C7_N    (S7_A | S7_B | S7_C | S7_E | S7_F)
#define C7_O    (S7_A | S7_B | S7_C | S7_D | S7_E | S7_F)
#define C7_P    (S7_A | S7_B | S7_E | S7_F | S7_G)
#define C7_Q    (S7_A | S7_B | S7_C | S7_F | S7_G)
#define C7_R    (S7_E | S7_G )
#define C7_S    (S7_A | S7_C | S7_D | S7_F | S7_G)
#define C7_T    (S7_D | S7_E | S7_F | S7_G)
#define C7_U    (S7_B | S7_C | S7_D | S7_E | S7_F)
#define C7_V    (S7_B | S7_C | S7_D | S7_E | S7_F)
#define C7_W    (S7_B | S7_D | S7_F)
#define C7_X    (S7_B | S7_C | S7_E | S7_F | S7_G)
#define C7_Y    (S7_B | S7_C | S7_D | S7_F | S7_G)
#define C7_Z    (S7_A | S7_B | S7_D | S7_E | S7_G)

//91 0x5B
#define C7_SBL  (S7_A | S7_D | S7_E | S7_F) // [
#define C7_LS   (S7_C | S7_F | S7_G)        // left slash
#define C7_SBR  (S7_A | S7_B | S7_C | S7_D) // ]
#define C7_PWR  (S7_A | S7_B | S7_F)        // ^
#define C7_UDS  (S7_D)                      // _
#define C7_DSH  (S7_F)                      // `  

//97 0x61  Lower case alphabet
#define C7_a     C7_A
#define C7_b     C7_B
#define C7_c     C7_C
#define C7_d     C7_D
#define C7_e     C7_E
#define C7_f     C7_H

#define C7_g     C7_G
#define C7_h     C7_H
#define C7_i     C7_I
#define C7_j     C7_J
#define C7_k     C7_K
#define C7_l     C7_L
#define C7_m     C7_M
//#define C7_n     C7_N
#define C7_n    (S7_C | S7_E | S7_G)
//#define C7_o     C7_O
#define C7_o    (S7_C | S7_D | S7_E | S7_G)
#define C7_p     C7_P
#define C7_q     C7_Q
//#define C7_r     C7_R
#define C7_r    (S7_E | S7_G)
#define C7_s     C7_S
#define C7_t     C7_T
#define C7_u     C7_U
#define C7_v     C7_V
#define C7_w     C7_W
#define C7_x     C7_X
#define C7_y     C7_Y
#define C7_z     C7_Z

//123 0x7B
#define C7_CBL  (S7_A | S7_D | S7_E | S7_F)        // {
#define C7_OR   (S7_B | S7_C)                      // |
#define C7_CBR  (S7_A | S7_B | S7_C | S7_D)        // }
#define C7_TLD  (S7_B | S7_E | S7_G )              // ~
#define C7_DEL  (0x0000)


//User Defined Characters (some examples)
#define C7_DGR   (S7_A | S7_B | S7_F | S7_G)  //Degrees
                                                                         
// Font data selection for transmission to TM1637 memory
#define LO(x)  ( x & 0xFF)
#define HI(x)  ((x >> 8) & 0xFF)


// ASCII Font definition table
//
#define FONT_7S_START     0x20
#define FONT_7S_END       0x7F
//#define FONT_7S_NR_CHARS (FONT_7S_END - FONT_7S_START + 1)
extern const char FONT_7S[]; 

#endif 