/* mbed VFD Font Library, for Princeton PT6318 VFD controller
 * Copyright (c) 2016, v01: WH, Initial version
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
#include "Font_16Seg.h"

// Select one of the testboards for Princeton PT6318 VFD controller
#include "PT6318_Config.h"

#if (PT6318_TEST == 1)

//Mask for blending out and restoring Icons
const char MASK_ICON_GRID[][3] = {
                                   {LO(S16_ICON_GR1), MD(S16_ICON_GR1), HI(S16_ICON_GR1)},
                                   {LO(S16_ICON_GR2), MD(S16_ICON_GR2), HI(S16_ICON_GR2)},
                                   {LO(S16_ICON_GR3), MD(S16_ICON_GR3), HI(S16_ICON_GR3)},
                                   {LO(S16_ICON_GR4), MD(S16_ICON_GR4), HI(S16_ICON_GR4)},
                                   {LO(S16_ICON_GR5), MD(S16_ICON_GR5), HI(S16_ICON_GR5)},
                                   {LO(S16_ICON_GR6), MD(S16_ICON_GR6), HI(S16_ICON_GR6)},
                                   {LO(S16_ICON_GR7), MD(S16_ICON_GR7), HI(S16_ICON_GR7)},
                                   {LO(S16_ICON_GR8), MD(S16_ICON_GR8), HI(S16_ICON_GR8)},
                                   {LO(S16_ICON_GR9), MD(S16_ICON_GR9), HI(S16_ICON_GR9)},
                                   {LO(S16_ICON_GR10), MD(S16_ICON_GR10), HI(S16_ICON_GR10)},
                                   {LO(S16_ICON_GR11), MD(S16_ICON_GR11), HI(S16_ICON_GR11)}
                                 };


// ASCII Font definition table for transmission to PT6318
//
//#define FONT_16S_START     0x20
//#define FONT_16S_END       0x7F
//#define FONT_16S_NR_CHARS (FONT_16S_END - FONT_16S_START + 1)
 
const short FONT_16S[] = { 
                            C16_SPC, //32 0x20, Space
                            C16_EXC,
                            C16_QTE,
                            C16_HSH,
                            C16_DLR,
                            C16_PCT,
                            C16_AMP,
                            C16_ACC,
                            C16_LBR,
                            C16_RBR,                   
                            C16_MLT,                            
                            C16_PLS,
                            C16_CMA,
                            C16_MIN,
                            C16_DOT,                             
                            C16_RS,
                            C16_0, //48 0x30
                            C16_1,
                            C16_2,
                            C16_3,
                            C16_4,                   
                            C16_5,
                            C16_6,
                            C16_7,
                            C16_8,
                            C16_9,
                            C16_COL, //58 0x3A
                            C16_SCL,
                            C16_LT,
                            C16_EQ,
                            C16_GT,
                            C16_QM,                             
                            C16_AT, //64 0x40
                            C16_A, //65 0x41, A
                            C16_B,
                            C16_C,
                            C16_D,
                            C16_E,
                            C16_F,
                            C16_G,
                            C16_H,
                            C16_I,
                            C16_J,                   
                            C16_K,
                            C16_L,
                            C16_M,
                            C16_N,
                            C16_O,
                            C16_P,
                            C16_Q,
                            C16_R,
                            C16_S,
                            C16_T,
                            C16_U,
                            C16_V,
                            C16_W,
                            C16_X,
                            C16_Y,
                            C16_Z, //90 0x5A, Z
                            C16_SBL, //91 0x5B
                            C16_LS,
                            C16_SBR,
                            C16_PWR,
                            C16_UDS,  
                            C16_ACC,                             
                            C16_A, //97 0x61, A replacing a
                            C16_B,
                            C16_C,
                            C16_D,
                            C16_E,
                            C16_F,
                            C16_G,
                            C16_H,
                            C16_I,
                            C16_J,                   
                            C16_K,
                            C16_L,
                            C16_M,
                            C16_N,
                            C16_O,
                            C16_P,
                            C16_Q,
                            C16_R,
                            C16_S,
                            C16_T,
                            C16_U,
                            C16_V,
                            C16_W,
                            C16_X,
                            C16_Y,
                            C16_Z, // 122 0x7A, Z replacing z
                            C16_CBL, // 123 0x7B
                            C16_OR,
                            C16_CBR,
                            C16_TLD,
                            C16_DEL
                           }; 
  
 // Wheel definition table for transmission to PT6318
const int WHEEL_ANI[] = { UDC16_WHEEL0,
                          UDC16_WHEEL1,
                          UDC16_WHEEL2,
                          UDC16_WHEEL3,
                          UDC16_WHEEL4,
                          UDC16_WHEEL5,
                          UDC16_WHEEL6,
                          UDC16_WHEEL7 };

#endif  