/* mbed VFD Font Library, for Princeton PT6315 VFD controller as used in DVDR3510
 * Copyright (c) 2016, v01: WH, Initial version for DVDR3510
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
#ifndef MBED_FONT_16SEG_H
#define MBED_FONT_16SEG_H

// Select one of the testboards for Princeton PT6315 VFD controller
#include "PT6315_Config.h"

#if (DVDR3510_TEST == 1) 
//#if (1) 
// Segment bit positions for 14 or 16 Segment display using the DVDR3510 mapping for PT6315
// Modify this table for different 'bit-to-segment' mappings. The ASCII character defines and the FONT_16S const table below 
// will be adapted automatically according to the bit-to-segment mapping. Obviously this will only work when the segment
// mapping is identical for every digit position. This will be the case unless the hardware designer really hates software developers.
//
//           A1   A2
//          ---- ----
//         |H\ J|  /K|     
//       F |  \ | /  | B    
//         |G1 \|/ G2|     
//          --- + ---
//         |   /|\   |     
//       E |  / | \  | C    
//         |N/ M|  \L|     
//          ---- ----    * DP
//           D1   D2
//
#define S16_A1   0x0001  // Assuming 2 part A segment
#define S16_A2   0x0001
#define S16_J    0x0002  // J, M linked 
#define S16_M    0x0002
#define S16_H    0x0004
#define S16_K    0x0008
#define S16_B    0x0010
#define S16_F    0x0020
#define S16_G2   0x0040  // 2 part G segment
#define S16_G1   0x0080
#define S16_C    0x0100
#define S16_E    0x0200
#define S16_N    0x0400
#define S16_L    0x0800
#define S16_D1   0x1000  // Assuming 2 part D segment
#define S16_D2   0x1000
#define S16_S    0x2000  // NA

//Icons All Grids
//#define S16_DP   0x8000  // Assuming single DP segment

//Icons Grid 1
#define S16_RCV  0x010000
#define S16_ICON_GR1  (S16_RCV)

//Icons Grid 2
#define S16_ICON_GR2  (0x000000)

//Icons Grid 3
#define S16_ICON_GR3  (0x000000)

//Icons Grid 4
#define S16_ICON_GR4  (0x000000)

//Icons Grid 5
#define S16_ICON_GR5  (0x000000)

//Icons Grid 6
#define S16_ICON_GR6  (0x000000)

//Icons Grid 7
#define S16_ICON_GR7  (0x000000)

//Icons Grid 8
#define S16_SAT  0x010000
#define S16_ICON_GR8  (S16_SAT)

//Icons Grid 9
#define S16_DRT  0x004000
#define S16_TV   0x010000
#define S16_ICON_GR9  (S16_DRT | S16_TV)

//Icons Grid 10
#define S16_COL4 0x004000
#define S16_TMR  0x010000
#define S16_ICON_GR10  (S16_COL4 | S16_TMR)

//Icons Grid 11
#define S16_COL6 0x004000
#define S16_DP6  0x008000
#define S16_PRS  0x010000
#define S16_ICON_GR11 (S16_COL6 | S16_DP6 | S16_PRS)


//Mask for blending out and restoring Icons
extern const char MASK_ICON_GRID[][3]; 

//One mask pattern will be sufficient assuming that all digits use the same mapping.
//#define S16_ICON_MSK (S16_COL3)

#endif


// ASCII Font definitions for segments in each character
//
//32 0x20
#define C16_SPC  (0x0000)    //Space
#define C16_EXC  (S16_B | S16_C) //!
#define C16_QTE  (S16_B | S16_F) //"
#define C16_HSH  (S16_B | S16_C | S16_D1 | S16_D2 | S16_G1 | S16_G2 | S16_J | S16_M) //#
#define C16_DLR  (S16_A1 | S16_A2 | S16_C | S16_D1 | S16_D2 | S16_F | S16_G1 | S16_G2 | S16_J | S16_M | S16_S) //$
#define C16_PCT  (S16_C | S16_F | S16_K | S16_N | S16_S) //%
//#define C16_AMP    (S16_A1 | S16_C | S16_D1 | S16_D2 | S16_E | S16_G1 | S16_J | S16_H | S16_L) // Not correct when J and M are linked
#define C16_AMP  (S16_A1 | S16_A2 | S16_C | S16_D1 | S16_D2 | S16_H | S16_K | S16_L | S16_N | S16_S) //&
#define C16_ACC  (S16_B) //'
#define C16_LBR  (S16_K | S16_L) //(
#define C16_RBR  (S16_H | S16_N) //)
#define C16_MLT  (S16_G1 | S16_G2 | S16_J | S16_M | S16_K | S16_L | S16_H | S16_N | S16_S)  //*
#define C16_PLS  (S16_G1 | S16_G2 | S16_J | S16_M | S16_S) //+
#define C16_CMA  (S16_C) //,
#define C16_MIN  (S16_G1 | S16_G2 | S16_S) //-
#define C16_DOT  (S16_C) //.
#define C16_RS   (S16_K | S16_N  | S16_S)  // /
//48 0x30 digits
#define C16_0    (S16_A1 | S16_A2 | S16_B | S16_C  | S16_D1 | S16_D2 | S16_E  | S16_F)
#define C16_1    (S16_B  | S16_C)
#define C16_2    (S16_A1 | S16_A2 | S16_B | S16_D1 | S16_D2 | S16_E  | S16_G1 | S16_G2 | S16_S)
#define C16_3    (S16_A1 | S16_A2 | S16_B | S16_C  | S16_D1 | S16_D2 | S16_G2 | S16_S)
#define C16_4    (S16_B  | S16_C  | S16_F | S16_G1 | S16_G2 | S16_S)
#define C16_5    (S16_A1 | S16_A2 | S16_C | S16_D1 | S16_D2 | S16_F | S16_G1 | S16_G2 | S16_S)
#define C16_6    (S16_A1 | S16_A2 | S16_C | S16_D1 | S16_D2 | S16_E | S16_F  | S16_G1 | S16_G2 | S16_S)
#define C16_7    (S16_A1 | S16_A2 | S16_B | S16_C)
#define C16_8    (S16_A1 | S16_A2 | S16_B | S16_C  | S16_D1 | S16_D2 | S16_E | S16_F  | S16_G1 | S16_G2 | S16_S)
#define C16_9    (S16_A1 | S16_A2 | S16_B | S16_C  | S16_D1 | S16_D2 | S16_F | S16_G1 | S16_G2 | S16_S)
//58 0x3A
#define C16_COL  (S16_D1 | S16_D2 | S16_G1 | S16_G2 | S16_S) // :
#define C16_SCL  (S16_D1 | S16_D2 | S16_G1 | S16_G2 | S16_S) // ;
#define C16_LT   (S16_K  | S16_L  | S16_S)               // <
#define C16_EQ   (S16_D1 | S16_D2 | S16_G1 | S16_G2 | S16_S) // =
#define C16_GT   (S16_H  | S16_N  | S16_S)               // >   
//#define C16_QM   (S16_A1 | S16_A2 | S16_B | S16_G2 | S16_M) // Not correct when J and M are linked
#define C16_QM   (S16_A1 | S16_A2 | S16_B | S16_G2 | S16_N | S16_S)  // ?
//64 0x40
//#define C16_AT   (S16_A1 | S16_A2 | S16_B  | S16_C  | S16_D1 | S16_D2 | S16_E | S16_G1  | S16_M | S16_S) // Not correct when J and M are linked
#define C16_AT   (S16_A1 | S16_A2 | S16_B  | S16_C  | S16_D1 | S16_D2 | S16_E  | S16_G1 | S16_S)  // @
#define C16_A    (S16_A1 | S16_A2 | S16_B  | S16_C  | S16_E  | S16_F  | S16_G1 | S16_G2 | S16_S)  // Upper case alphabet
#define C16_B    (S16_A1 | S16_A2 | S16_B  | S16_C  | S16_D1 | S16_D2 | S16_J  | S16_M  | S16_G2 | S16_S)
#define C16_C    (S16_A1 | S16_A2 | S16_D1 | S16_D2 | S16_E  | S16_F)
#define C16_D    (S16_A1 | S16_A2 | S16_B  | S16_C  | S16_D1 | S16_D2 | S16_J  | S16_M  | S16_S)
#define C16_E    (S16_A1 | S16_A2 | S16_D1 | S16_D2 | S16_E  | S16_F  | S16_G1 | S16_S)
#define C16_F    (S16_A1 | S16_A2 | S16_E  | S16_F  | S16_G1 | S16_S)
#define C16_G    (S16_A1 | S16_A2 | S16_C  | S16_D1 | S16_D2 | S16_E  | S16_F  | S16_G2 | S16_S)
#define C16_H    (S16_B  | S16_C  | S16_E  | S16_F  | S16_G1 | S16_G2 | S16_S)
#define C16_I    (S16_A1 | S16_A2 | S16_D1 | S16_D2 | S16_J  | S16_M  | S16_S)
#define C16_J    (S16_B  | S16_C  | S16_D1 | S16_D2 | S16_E)
#define C16_K    (S16_E  | S16_F  | S16_G1 | S16_K  | S16_L  | S16_S)
#define C16_L    (S16_D1 | S16_D2 | S16_E  | S16_F)
#define C16_M    (S16_B  | S16_C  | S16_E  | S16_F  | S16_H  | S16_K  | S16_S)
#define C16_N    (S16_B  | S16_C  | S16_E  | S16_F  | S16_H  | S16_L  | S16_S)
#define C16_O    (S16_A1 | S16_A2 | S16_B  | S16_C  | S16_D1 | S16_D2 | S16_E  | S16_F)
#define C16_P    (S16_A1 | S16_A2 | S16_B  | S16_E  | S16_F  | S16_G1 | S16_G2 | S16_S)
#define C16_Q    (S16_A1 | S16_A2 | S16_B  | S16_C  | S16_D1 | S16_D2 | S16_E  | S16_F  | S16_L)
#define C16_R    (S16_A1 | S16_A2 | S16_B  | S16_E  | S16_F  | S16_G1 | S16_G2 | S16_L  | S16_S)
#define C16_S    (S16_A1 | S16_A2 | S16_C  | S16_D1 | S16_D2 | S16_F  | S16_G1 | S16_G2 | S16_S)
#define C16_T    (S16_A1 | S16_A2 | S16_J  | S16_M  | S16_S)
#define C16_U    (S16_B  | S16_C  | S16_D1 | S16_D2 | S16_E  | S16_F)
#define C16_V    (S16_E  | S16_F  | S16_N  | S16_K  | S16_S)
#define C16_W    (S16_B  | S16_C  | S16_E  | S16_F  | S16_L  | S16_N  | S16_S)
#define C16_X    (S16_H  | S16_K  | S16_L  | S16_N  | S16_S)
//#define C16_Y    (S16_H | S16_K | S16_M | S16_S) // Not correct when J and M are linked
#define C16_Y    (S16_B  | S16_C  | S16_D1 | S16_D2 | S16_F  | S16_G1 | S16_G2 | S16_S)
#define C16_Z    (S16_A1 | S16_A2 | S16_D1 | S16_D2 | S16_K  | S16_N  | S16_S)
//91 0x5B
#define C16_SBL  (S16_A1 | S16_D1 | S16_E  | S16_F)  // [
#define C16_LS   (S16_H  | S16_L  | S16_S)           // left slash
#define C16_SBR  (S16_A2 | S16_B | S16_C | S16_D2)   // ]
#define C16_PWR  (S16_L  | S16_N  | S16_S)           // ^
#define C16_UDS  (S16_D1 | S16_D2)                   // _
#define C16_DSH  (S16_H)                             // `  
//97 0x61
// a...z No defines provided. Just use the Upper case characters again
//122

//123 0x7B
#define C16_CBL  (S16_G1 | S16_J  | S16_M  | S16_S)          // {
#define C16_OR   (S16_J  | S16_M  | S16_S)                   // |
#define C16_CBR  (S16_G2 | S16_J  | S16_M  | S16_S)          // }
#define C16_TLD  (S16_B  | S16_E  | S16_G1 | S16_G2 | S16_S) // ~
#define C16_DEL  (0x0000)

//User Defined Characters (some examples)
#define UDC16_SANDHR  (S16_A1 | S16_A2 | S16_D1 | S16_D2 | S16_H  | S16_K | S16_L | S16_N | S16_S)  //Sandhour
#define UDC16_DGR     (S16_A  | S16_B  | S16_F | S16_G)  // degrees

#if(0)
#define UDC16_WHEEL0  (S16_G1 | S16_G2 | S16_S)  // -
#define UDC16_WHEEL1  (S16_H  | S16_L  | S16_S)  /* \ */
#define UDC16_WHEEL2  (S16_J  | S16_M  | S16_S)  // |
#define UDC16_WHEEL3  (S16_K  | S16_N  | S16_S)  // /
#define UDC16_WHEEL4  (S16_G1 | S16_G2 | S16_S)  // -
#define UDC16_WHEEL5  (S16_H  | S16_L  | S16_S)  /* \ */
#define UDC16_WHEEL6  (S16_J  | S16_M  | S16_S)  // |
#define UDC16_WHEEL7  (S16_K  | S16_N  | S16_S)  // /
#else
#define UDC16_WHEEL0  (S16_A1 | S16_A2 | S16_B | S16_C | S16_D1 | S16_D2 | S16_E | S16_F | S16_G1 | S16_G2 | S16_S)  // -
#define UDC16_WHEEL1  (S16_A1 | S16_A2 | S16_B | S16_C | S16_D1 | S16_D2 | S16_E | S16_F | S16_H  | S16_L  | S16_S)  /* \ */
#define UDC16_WHEEL2  (S16_A1 | S16_A2 | S16_B | S16_C | S16_D1 | S16_D2 | S16_E | S16_F | S16_J  | S16_M  | S16_S)  // |
#define UDC16_WHEEL3  (S16_A1 | S16_A2 | S16_B | S16_C | S16_D1 | S16_D2 | S16_E | S16_F | S16_K  | S16_N  | S16_S)  // /
#define UDC16_WHEEL4  (S16_A1 | S16_A2 | S16_B | S16_C | S16_D1 | S16_D2 | S16_E | S16_F | S16_G1 | S16_G2 | S16_S)  // -
#define UDC16_WHEEL5  (S16_A1 | S16_A2 | S16_B | S16_C | S16_D1 | S16_D2 | S16_E | S16_F | S16_H  | S16_L  | S16_S)  /* \ */
#define UDC16_WHEEL6  (S16_A1 | S16_A2 | S16_B | S16_C | S16_D1 | S16_D2 | S16_E | S16_F | S16_J  | S16_M  | S16_S)  // |
#define UDC16_WHEEL7  (S16_A1 | S16_A2 | S16_B | S16_C | S16_D1 | S16_D2 | S16_E | S16_F | S16_K  | S16_N  | S16_S)  // /
#endif

// Font data selection for transmission to PT6311 memory
#define LO(x)  ( x & 0xFF)
#define MD(x)  ((x >>  8) & 0xFF)
#define HI(x)  ((x >> 16) & 0xFF)

// ASCII Font definition table
//
#define FONT_16S_START     0x20
#define FONT_16S_END       0x7F
//#define FONT_16S16_LR_CHARS (FONT_16S16_END - FONT_16S16_START + 1)
extern const short FONT_16S[]; 


// Wheel animation definition table
extern const int WHEEL_ANI[]; 
#endif                         