/* mbed VFD Font Library, for Princeton PT6312 VFD controller as used in Cyberhome DVD462 and C2233
 * Copyright (c) 2015, v01: WH, Initial version, Test DVD462 and C2233
 *               2015, v02: WH, Added symbols
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
#ifndef MBED_FONT_7SEG_H
#define MBED_FONT_7SEG_H

// Select one of the testboards for Princeton PT6312 VFD controller
#include "PT6312_Config.h"

#if (DVD462_TEST == 1) 
// Segment bit positions for 7 Segment display using the DVD462 mapping for PT6312
// Modify this table for different 'bit-to-segment' mappings. The ASCII character defines and the FONT_7S const table below 
// will be adapted automatically according to the bit-to-segment mapping. Obviously this will only work when the segment
// mapping is identical for every digit position. This will be the case unless the hardware designer really hates software developers.
// In this specific case grids 2,3 and 4 have two 7 segment digits, grid 5 hase one. Unfortunetely the patterns for the second digits
// of grid 3 and 4 are shifted by one bit position.
//
#define S7_D    0x0001
#define S7_E    0x0002
#define S7_C    0x0004
#define S7_G    0x0008 
#define S7_F    0x0010
#define S7_B    0x0020
#define S7_A    0x0040

//Mask for blending out and setting 7 segments digits
#define MASK_7S_ALL = (S7_D | S7_E | S7_C | S7_G | S7_F | S7_B | S7_A}


//Icons Grid 1
#define S7_MP3  0x0800
#define S7_CD   0x1000
#define S7_V    0x2000
#define S7_S    0x4000
#define S7_DVD  0x8000
#define S7_ICON_GR1 (S7_MP3 | S7_CD | S7_V | S7_S | S7_DVD)

//Icons Grid 2
#define S7_DDD  0x4000
#define S7_DTS  0x8000
#define S7_ICON_GR2 (S7_DDD | S7_DTS)

//Icons Grid 3
#define S7_COL5 0x0080
#define S7_ICON_GR3 (S7_COL5)

//Icons Grid 4
#define S7_COL3 0x0080
#define S7_ICON_GR4 (S7_COL3)

//Icons Grid 5
#define S7_ARW  0x0100
#define S7_ALL  0x0200
#define S7_PSE  0x0400
#define S7_PLY  0x0800
#define S7_PBC  0x8000
#define S7_ICON_GR5 (S7_ARW | S7_ALL | S7_PSE | S7_PLY | S7_PBC)

//Icons Grid 6 (Piechart)
#define S7_P1   0x0004
#define S7_P2   0x0008
#define S7_P3   0x0010
#define S7_P4   0x0020
#define S7_P5   0x0040
#define S7_P6   0x0080
#define S7_P7   0x0100
#define S7_P8   0x0200
#define S7_P9   0x0400
#define S7_P10  0x0800
#define S7_P11  0x1000
#define S7_P12  0x2000
#define S7_P13  0x4000
#define S7_ICON_GR6 (S7_P1 | S7_P2 | S7_P3 | S7_P4 | S7_P5 | S7_P6 | S7_P7 | S7_P8 | S7_P9 | S7_P10 | S7_P11 | S7_P12 | S7_P13)

//Mask for blending out and restoring Icons
extern const char MASK_ICON_GRID[][2]; 
#endif

#if (C2233_TEST == 1) 
// Segment bit positions for 7 Segment display using the C2233 mapping for PT6312
// Modify this table for different 'bit-to-segment' mappings. The ASCII character defines and the FONT_7S const table below 
// will be adapted automatically according to the bit-to-segment mapping. Obviously this will only work when the segment
// mapping is identical for every digit position. This will be the case unless the hardware designer really hates software developers.
// In this specific case grids 2,3 and 4 have two 7 segment digits, grid 5 hase one. Unfortunetely the patterns for the second digits
// of grid 3 and 4 are shifted by one bit position.
//
#define S7_D    0x0001
#define S7_E    0x0002
#define S7_C    0x0004
#define S7_G    0x0008 
#define S7_F    0x0010
#define S7_B    0x0020
#define S7_A    0x0040

//Mask for blending out and setting 7 segments digits
#define MASK_7S_ALL = (S7_D | S7_E | S7_C | S7_G | S7_F | S7_B | S7_A}


//Icons Grid 1
//none
#define S7_ICON_GR1 (0)

//Icons Grid 2
#define S7_MP3  0x4000
#define S7_PBC  0x8000
#define S7_ICON_GR2 (S7_MP3 | S7_PBC)

//Icons Grid 3
#define S7_COL5 0x0080
#define S7_CAM  0x8000
#define S7_ICON_GR3 (S7_COL5 | S7_CAM)

//Icons Grid 4
#define S7_COL3 0x0080
#define S7_DDD  0x8000
#define S7_ICON_GR4 (S7_COL3 | S7_DDD)

//Icons Grid 5
#define S7_ARW  0x0100
#define S7_ALL  0x0200
#define S7_PSE  0x0400
#define S7_PLY  0x0800
#define S7_CD   0x1000
#define S7_V    0x2000
#define S7_S    0x4000
#define S7_DTS  0x8000
#define S7_ICON_GR5 (S7_ARW | S7_ALL | S7_PSE | S7_PLY | S7_CD | S7_V | S7_S | S7_DTS)

//Icons Grid 6 (Piechart)
#define S7_P1   0x0004
#define S7_P2   0x0008
#define S7_P3   0x0010
#define S7_P4   0x0020
#define S7_P5   0x0040
#define S7_P6   0x0080
#define S7_P7   0x0100
#define S7_P8   0x0200
#define S7_P9   0x0400
#define S7_P10  0x0800
#define S7_P11  0x1000
#define S7_P12  0x2000
#define S7_P13  0x4000
#define S7_DVD  0x8000
#define S7_ICON_GR6 (S7_P1 | S7_P2 | S7_P3 | S7_P4 | S7_P5 | S7_P6 | S7_P7 | S7_P8 | S7_P9 | S7_P10 | S7_P11 | S7_P12 | S7_P13 |S7_DVD)

//Mask for blending out and restoring Icons
extern const char MASK_ICON_GRID[][2]; 
#endif



// ASCII Font definitions for segments in each character
//
//32 0x20  Symbols
#define C7_SPC  ()

//48 0x30  Digits
#define C7_0    (S7_A | S7_B | S7_C | S7_D | S7_E | S7_F)
#define C7_1    (S7_B | S7_C)
#define C7_2    (S7_A | S7_B | S7_D | S7_E | S7_G)
#define C7_3    (S7_A | S7_B | S7_C | S7_D | S7_G)
#define C7_4    (S7_B | S7_C | S7_F | S7_G)
#define C7_5    (S7_A | S7_C | S7_D | S7_F | S7_G)
#define C7_6    (S7_A | S7_C | S7_D | S7_E | S7_F | S7_G)
#define C7_7    (S7_A | S7_B | S7_C)
#define C7_8    (S7_A | S7_B | S7_C | S7_D | S7_E | S7_F | S7_G)
#define C7_9    (S7_A | S7_B | S7_C | S7_D | S7_F | S7_G)
//64 0x40  Upper case alphabet
#define C7_A    (S7_A | S7_B | S7_C | S7_E | S7_F | S7_G )
#define C7_B    (S7_C | S7_D | S7_E | S7_F | S7_G)
#define C7_C    (S7_A | S7_D | S7_E | S7_F)
#define C7_D    (S7_B | S7_C | S7_D | S7_E | S7_G)
#define C7_E    (S7_A | S7_D | S7_E | S7_F | S7_G)
#define C7_F    (S7_A | S7_E | S7_F | S7_G)

#define C7_G    (S7_A | S7_C | S7_D | S7_E | S7_F)
#define C7_H    (S7_B | S7_C | S7_E | S7_F | S7_G)
#define C7_I    (S7_B | S7_C)
#define C7_J    (S7_B | S7_C | S7_D | S7_E)
#define C7_L    (S7_D | S7_E | S7_F)
#define C7_M    (S7_C | S7_E | S7_G)
#define C7_N    (S7_C | S7_E | S7_G)
#define C7_O    (S7_A | S7_B | S7_C | S7_D | S7_E | S7_F)
#define C7_P    (S7_A | S7_B | S7_E | S7_F | S7_G)
#define C7_Q    (S7_A | S7_B | S7_C | S7_F | S7_G)
#define C7_R    (S7_E | S7_G)
#define C7_S    (S7_A | S7_C | S7_D | S7_F | S7_G)
#define C7_T    (S7_D | S7_E | S7_F | S7_G)
#define C7_U    (S7_B | S7_C | S7_D | S7_E | S7_F)
#define C7_Y    (S7_B | S7_C | S7_D | S7_F | S7_G)
#define C7_Z    (S7_A | S7_B | S7_D | S7_E | S7_G)

//97 0x61  Lower case alphabet
#define C7_a     C7_A
#define C7_b     C7_B
#define C7_c     C7_C
#define C7_d     C7_D
#define C7_e     C7_E
#define C7_f     C7_H

#define C7_g     C7_G
#define C7_h     C7_H
#define C7_i     C7_I
#define C7_j     C7_J
#define C7_l     C7_L
#define C7_m     C7_M
#define C7_n     C7_N
#define C7_o     C7_O
#define C7_p     C7_P
#define C7_q     C7_Q
#define C7_r     C7_R
#define C7_s     C7_S
#define C7_t     C7_T
#define C7_u     C7_U
#define C7_y     C7_Y
#define C7_z     C7_Z


//User Defined Characters (some examples)
                                                                          
// Font data selection for transmission to PT6512 memory
#define LO(x)  ( x & 0xFF)
#define HI(x)  ((x >> 8) & 0xFF)


// ASCII Font definition table
//
//#define FONT_7S_START     0x20
//#define FONT_7S_END       0x7F
//#define FONT_7S_NR_CHARS (FONT_7S_END - FONT_7S_START + 1)
extern const char FONT_7S[]; 

#endif                         