/* mbed PT6302 UDC Library, for Princeton PT6302 VFD controller
 * Note the PT6302 is identical to the OKI ML9208 
 *
 * Copyright (c) 2017, v01: WH, Initial version
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
#include "PT6302_Config.h"

#if(PT6302_UDC == 1)

// User Defined Characters (UDCs) are defined by a 5 byte bitpattern.
// The C0..C34 form the character pattern.
//     D7 D6  D5  D4  D3 D2 D1 D0 
// 0   x  C30 C25 C20 ......   C0
// 1   x  C31 C24  ........... C1
// .       .............
// 4   x  C34 C29  ........... C4
//
//
// The UDC matrix will show on the VFD as
// 0   C0  C1  C2  C3  C4
// 1   C5  C6 .....    C9
// .    .............
// .    .............
// .    .............
// 6   C30 C31 ...     C34
//
//
// Some sample User Defined Chars 5x7 dots */
const char udc_Bat_Hi[]  = {0x0E, 0x1F, 0x1F, 0x1F, 0x1F};  // Battery Full
const char udc_Bat_Ha[]  = {0x0E, 0x11, 0x13, 0x17, 0x1F};  // Battery Half
const char udc_Bat_Lo[]  = {0x0E, 0x11, 0x11, 0x11, 0x11};  // Battery Low
const char udc_checker[] = {0xAA, 0x55, 0xAA, 0x55, 0xAA};                          
                                          
//const char udc_PO[] = {0x04, 0x0A, 0x0A, 0x1F, 0x1B, 0x1B};  //Padlock Open
//const char udc_PC[] = {0x1C, 0x10, 0x08, 0x1F, 0x1B, 0x1B};  //Padlock Closed

const char udc_LAR[]  = {0x07, 0x03, 0x05, 0x78, 0x00};   // Left Arrow
const char udc_RAR[]  = {0x00, 0x78, 0x05, 0x03, 0x07};   // Right Arrow
#endif
