/* BusDefines - Use the MBED Port pins and PCF8574s for controlling the Bus
 * Copyright (c) 2011 Wim Huiskamp
 *
 * Released under the MIT License: http://mbed.org/license/mit
 *
 * version 0.2 Initial Release
*/
#ifndef _BUS_DEFINES_H
#define _BUS_DEFINES_H


//Pin Defines for MBED Control Bus (inputs)
#define D_CDINT                p20
//Pin Defines for MBED Control Bus (outputs)
#define D_DTR                  p21
#define D_CDBUF                p22
#define D_RD                   p23
#define D_WR                   p24

#define D_CTRL_MSK             0xFF

//Pin Defines for I2C Bus
//#define D_SDA                  p9
//#define D_SCL                  p10
#define D_SDA                  p28
#define D_SCL                  p27

//I2C Bus Address Defines for PCF8574 slaves
#define D_I2C_DATA_BUS        0x40
#define D_I2C_ADDR_BUS        0x42
#define D_I2C_ENA_BUS         0x44


//Host PC Baudrate (Virtual Com Port on USB)
#define D_BAUDRATE            9600
//#define D_BAUDRATE            57600

#endif