/* PCF8574_EnableBus - Use the PCF8574 I2C Port Extender for controlling the Chip Enable Bus
 * Copyright (c) 2011 Wim Huiskamp
 *
 * Released under the MIT License: http://mbed.org/license/mit
 *
 * version 0.2 Initial Release
*/
#ifndef _PCF8574_ENABLEBUS_H
#define _PCF8574_ENABLEBUS_H

//Pin Defines for PCF8574 Enable Bus
//Note: 'Reset' causes all devices on the 'Control & Display Unit' to be reset!
#define D_CS_SWITCH            0x01
#define D_LATCHEN_1            0x02
#define D_LATCHEN_2            0x04
#define D_CS_BRIGHT            0x08
#define D_CS_DISP              0x10
#define D_CS_SPARE             0x20
#define D_RESET                0x40
#define D_NOGO                 0x80

#define D_ENABLE_MSK           0x3F

//Enums for Enable Bus
#include "BusEnums.h"
enum CS_Pin { CS_SWITCH, LATCHEN_1, LATCHEN_2, CS_BRIGHT, CS_DISP, CS_SPARE };


/** Create an PCF8574_EnableBus object connected to the specified I2C object and using the specified deviceAddress
 *
 * @param I2C &i2c the I2C port to connect to 
 * @param char deviceAddress the address of the PCF8574
*/
class PCF8574_EnableBus {
public:
    PCF8574_EnableBus(I2C &i2c, char deviceAddress);
    void chipselect (CS_Pin cs_pin, Bit_Level cs_level);
    void reset (Bit_Level rst_level);
    void nogo (Bit_Level nogo_level);
protected:
    I2C &_i2c;
    char _readOpcode;
    char _writeOpcode; 
    char _enable_bus;   
    char _reset_pin;   
    char _nogo_pin;   
//    char _read();
    void _write();  
    void _write(char byte);      
    void _init(); 
};

#endif