/* PCF8574_AddressBus - Use the PCF8574 I2C Port Extender for controlling the Address Bus
 * Copyright (c) 2011 Wim Huiskamp
 *
 * Released under the MIT License: http://mbed.org/license/mit
 *
 * version 0.2 Initial Release
*/
#ifndef _PCF8574_ADDRESSBUS_H
#define _PCF8574_ADDRESSBUS_H


//Pin Defines for PCF8574 Address Bus
#define D_A0                   0x01
#define D_A1                   0x02
#define D_A2                   0x04
#define D_A3                   0x08
#define D_A4                   0x10
#define D_A5                   0x20
#define D_A6                   0x40
#define D_A7                   0x80

#define D_ADDR_MSK             0x3F


/** Create an PCF8574_AddressBus object connected to the specified I2C object and using the specified deviceAddress
 *
 * @param I2C &i2c the I2C port to connect to 
 * @param char deviceAddress the address of the PCF8574
*/
class PCF8574_AddressBus {
public:
    PCF8574_AddressBus(I2C &i2c, char deviceAddress);
    void write(char address);
protected:
    I2C &_i2c;
    char _readOpcode;
    char _writeOpcode; 
    void _init(); 
};

#endif