/* PCF8574_AddressBus - Use the PCF8574 I2C Port Extender for controlling the Address Bus
 * Copyright (c) 2011 Wim Huiskamp
 *
 * Released under the MIT License: http://mbed.org/license/mit
 *
 * version 0.2 Initial Release
*/
#include "mbed.h"
#include "PCF8574_AddressBus.h"

/** Create an PCF8574_AddressBus object connected to the specified I2C object and using the specified deviceAddress
 *
 * @param I2C &i2c the I2C port to connect to 
 * @param char deviceAddress the address of the PCF8574
*/
PCF8574_AddressBus::PCF8574_AddressBus(I2C &i2c, char deviceAddress) : _i2c(i2c) {
   _writeOpcode = deviceAddress & 0xFE; // low order bit = 0 for write
   _readOpcode  = deviceAddress | 0x01; // low order bit = 1 for read
   _init();
}

/** Optimised AddressBus write operation.
 * @param address the addressvalue to output on the bus
*/
void PCF8574_AddressBus::write(char address) {
    char data[1];
    
    data[0] = address;
    _i2c.write(_writeOpcode, data, 1);    // Write addressvalue to bus   
}


/** Init PCF8574_AddressBus
 * @param
 * @returns 
 */
void PCF8574_AddressBus::_init() {
 
    write(0x00);
}