#include "mbed.h"
#include "MCP23017.h"

DigitalOut myled1(LED1);
DigitalOut myled2(LED2);

Serial pc(USBTX, USBRX);
I2C i2c(p9, p10);

MCP23017 mcp23017 = MCP23017(i2c, 0x40);

int main() {
    
    pc.printf("Hello World\n");
    
    // I2C init
    i2c.frequency(100000);
    
    // Port A is databus - Output
    mcp23017.direction(PORT_A, PORT_DIR_OUT);
    // Port B is controlbus - Output       
    mcp23017.direction(PORT_B, PORT_DIR_OUT); 
    
    myled2 = 1;
    pc.printf("MPC Init done\n");           
    
    while(1) {
        myled1 = 1;
        mcp23017.write(PORT_A, 0xFF);
        mcp23017.write(PORT_B, 0xFF);        
        wait(0.2);
           
        myled1 = 0;
        mcp23017.write(PORT_A, 0x00);
        mcp23017.write(PORT_B, 0x00);        
        wait(0.2);
        pc.printf("*");
    }
}
