/* mbed LC75710 Library, for Sanyo LC7571X VFD controller
 * Note: The LC75710, LC75711 and LC75712 differ only in the built-in character ROM
 *
 * Copyright (c) 2017, v01: WH, Initial version
 *               2017, v02: WH, Added some UDC definitions
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
#include "LC75711_Config.h"

#if(LC75711_UDC == 1)
// User Defined Characters (UDCs) are defined by a 7 byte bitpattern. 
// The P0..P4 form the UDC pattern.
//     P7 P6 P5 P4  P3  P2  P1  P0 
// 0   x  x  x  CD4 CD3 CD2 CD1 CD1
// 1   x  x  x  CD9 CD8 CD7 CD6 CD5
// .       .............
// 6   x  x  x  C35 C34  ...    C31
//
// The UDC matrix will show on the VFD as
// 0   CD1  CD2  CD3  CD4  CD5
// 1   CD6  CD7 .......    CD10
// .      .............
// .      .............
// .      .............
// 6   CD31 C32  .......   CD35
//

// Some sample User Defined Chars 5x7 dots */
const char udc_Bat_Hi[]  = {0x0E, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F};  // Battery Full
const char udc_Bat_Ha[]  = {0x0E, 0x11, 0x13, 0x17, 0x1F, 0x1F, 0x1F};  // Battery Half
const char udc_Bat_Lo[]  = {0x0E, 0x11, 0x11, 0x11, 0x11, 0x11, 0x1F};  // Battery Low
const char udc_checker[] = {0xAA, 0x55, 0xAA, 0x55, 0xAA, 0x55, 0xAA};                          
                                          
//const char udc_PO[] = {0x04, 0x0A, 0x0A, 0x1F, 0x1B, 0x1B, 0x1F, 0x00};  //Padlock Open
//const char udc_PC[] = {0x1C, 0x10, 0x08, 0x1F, 0x1B, 0x1B, 0x1F, 0x00};  //Padlock Closed

//
// NOTE: the bitpatterns below still need to be flipped or they will be mirrored on the display...
//
//const char udc_ae[] = {0x00, 0x00, 0x1B, 0x05, 0x1F, 0x14, 0x1F, 0x00};  //æ
//const char udc_0e[] = {0x00, 0x00, 0x0E, 0x13, 0x15, 0x19, 0x0E, 0x00};  //ø
//const char udc_ao[] = {0x0E, 0x0A, 0x0E, 0x01, 0x0F, 0x11, 0x0F, 0x00};  //å
//const char udc_AE[] = {0x0F, 0x14, 0x14, 0x1F, 0x14, 0x14, 0x17, 0x00};  //Æ
//const char udc_0E[] = {0x0E, 0x13, 0x15, 0x15, 0x15, 0x19, 0x0E, 0x00};  //Ø
//const char udc_Ao[] = {0x0E, 0x0A, 0x0E, 0x11, 0x1F, 0x11, 0x11, 0x00};  //Å

//const char udc_alpha[] = {0x00, 0x00, 0x0D, 0x12, 0x12, 0x12, 0x0D, 0x00};  //alpha
//const char udc_ohm[]   = {0x0E, 0x11, 0x11, 0x11, 0x0A, 0x0A, 0x1B, 0x00};  //ohm
//const char udc_sigma[] = {0x1F, 0x08, 0x04, 0x02, 0x04, 0x08, 0x1F, 0x00};  //sigma
//const char udc_pi[]    = {0x1F, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x00};  //pi
//const char udc_root[]  = {0x07, 0x04, 0x04, 0x04, 0x14, 0x0C, 0x04, 0x00};  //root

//const char udc_TM_T[]   = {0x1F, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00};  // Trademark T
//const char udc_TM_M[]   = {0x11, 0x1B, 0x15, 0x11, 0x00, 0x00, 0x00, 0x00};  // Trademark M
#endif
