/* mbed LC75710 Library, for Sanyo LC7571X VFD controller
 * Note: The LC75710, LC75711 and LC75712 differ only in the built-in character ROM
 *
 * Copyright (c) 2017, v01: WH, Initial version
 *               2017, v02: WH, Added some UDC definitions
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
#ifndef MBED_LC75711_UDC_H
#define MBED_LC75711_UDC_H

#include "LC75711_Config.h"

#if(LC75711_UDC == 1)
// User Defined Characters (UDCs) are defined by a 7 byte bitpattern. 
// The P0..P4 form the UDC pattern.
//     P7 P6 P5 P4  P3  P2  P1  P0 
// 0   x  x  x  CD4 CD3 CD2 CD1 CD1
// 1   x  x  x  CD9 CD8 CD7 CD6 CD5
// .       .............
// 6   x  x  x  C35 C34  ...    C31
//
// The UDC matrix will show on the VFD as
// 0   CD1  CD2  CD3  CD4  CD5
// 1   CD6  CD7 .......    CD10
// .      .............
// .      .............
// .      .............
// 6   CD31 C32  .......   CD35
//


// Some sample User Defined Chars 5x7 dots */
extern const char udc_Bat_Hi[];  // Battery Full
extern const char udc_Bat_Ha[];  // Battery Half
extern const char udc_Bat_Lo[];  // Battery Low
extern const char udc_checker[];                          
                                          
//extern const char udc_PO[];    //Padlock Open
//extern const char udc_PC[];    //Padlock Closed

//
// NOTE: the bitpatterns below still need to be flipped or they will be mirrored on the display...
//
//extern const char udc_ae[];    //æ
//extern const char udc_0e[];    //ø
//extern const char udc_ao[];    //å
//extern const char udc_AE[];    //Æ
//extern const char udc_0E[];    //Ø
//extern const char udc_Ao[];    //Å

//extern const char udc_alpha[]  //alpha
//extern const char udc_ohm[];   //ohm
//extern const char udc_sigma[]; //sigma
//extern const char udc_pi[];    //pi
//extern const char udc_root[];  //root

//extern const char udc_TM_T[];  // Trademark T
//extern const char udc_TM_M[];  // Trademark M
#endif

#endif
