/* HDSP253X_Display - Intelligent 8 digit 5x7 LED matrix display
 *
 * Copyright (c) 2011 Wim Huiskamp
 * Modified software based on sourcecode by RAC 06/08/2008
 *
 * Released under the MIT License: http://mbed.org/license/mit
 *
 * version 0.2 Initial Release
*/
#ifndef MBED_HDSP253X_H
#define MBED_HDSP253X_H
/*---------------------------------------------------------------------------*\
 |  Original text by RAC 06/08/2008 has been modified to fix those parts of
 |  the description which explain hardware or software that has been removed or
 |  adapted in the new version. 
 |
 |  Description: Display driver and demonstrator for HDSP253X series intelligent
 |            8 character LED display modules. Options include adjusting 
 |            brightness and message blinking.
 |            This software drives a single display module using 8 bit databus,
 |            5 bit addressbus and controlsignals. Note that this software
 |            will drive all display devices in the series, including HDSP2530 Orange,
 |            HDSP2531 Yellow, HDSP2532 red and HDSP2533 green devices. It will also
 |            drive the smaller HDSP21XX series.
 |
 |            The peripheral is connected to the following pins:
 |            HDSP253X
 |                    - Reset (pin 1) to EnableBus.RESET
 |                    - Flash (pin 2) to AddressBus.A5
 |                    - Addr A0 (pin 3) to AddressBus.A0
 |                    - Addr A1 (pin 4) to AddressBus.A1
 |                    - Addr A2 (pin 5) to AddressBus.A2
 |                    - Addr A3 (pin 6) to AddressBus.A3
 |                    - Addr A4 (pin 10) to AddressBus.A4
 |                    - Clock select (pin 11) to VCC (Pull Up)
 |                    - Clock in/out (pin 12) to Not Connected
 |                    - Write (pin 13) to ControlBus.WR
 |                    - CE (Pin 14) to EnableBus.CSDISP
 |                    - VDD 5V (Pin 15)
 |                    - GND (supply) (Pin 16)
 |                    - TST (Pin 16) NC
 |                    - GND (logic) (Pin 18)   
 |                    - Read (pin 19) to ControlBus.RD
 |                    - Data D0 (pin 20) to Databus.D0
 |                    - Data D1 (pin 21) to Databus.D1
 |                    - Data D2 (pin 25) to Databus.D2
 |                    - Data D3 (pin 26) to Databus.D3
 |                    - Data D4 (pin 27) to Databus.D4
 |                    - Data D5 (pin 28) to Databus.D5
 |                    - Data D6 (pin 29) to Databus.D6
 |                    - Data D7 (pin 30) to Databus.D7
 |
 |            The peripheral is connected to the following pins:
 |            HDSP211X
 |                    - Reset (pin 1) to EnableBus.RESET
 |                    - Flash (pin 2) to AddressBus.A5
 |                    - Addr A0 (pin 3) to AddressBus.A0
 |                    - Addr A1 (pin 4) to AddressBus.A1
 |                    - Addr A2 (pin 5) to AddressBus.A2
 |                    - Addr A3 (pin 6) to AddressBus.A3
 |                    - Addr A4 (pin 10) to AddressBus.A4
 |                    - Clock select (pin 11) to VCC (Pull Up)
 |                    - Clock in/out (pin 12) to Not Connected
 |                    - Write (pin 13) to ControlBus.WR
 |                    - VDD 5V (Pin 14)
 |                    - GND (supply) (Pin 15)
 |                    - GND (logic) (Pin 16)   
 |                    - CE (Pin 17) to EnableBus.CSDISP
 |                    - Read (pin 18) to ControlBus.RD
 |                    - Data D0 (pin 19) to Databus.D0
 |                    - Data D1 (pin 20) to Databus.D1
 |                    - Data D2 (pin 23) to Databus.D2
 |                    - Data D3 (pin 24) to Databus.D3
 |                    - Data D4 (pin 25) to Databus.D4
 |                    - Data D5 (pin 26) to Databus.D5
 |                    - Data D6 (pin 27) to Databus.D6
 |                    - Data D7 (pin 28) to Databus.D7
 |
 |  Details:  All signals to the HDSP253X are pulled up by 10K resistors.
 |            The device must be reset by pulsing Reset low with Chip Enable
 |            set high. Other signals are don't cares during a reset. This
 |            firmware meets these conditions, as long as the pullups are 
 |            correctly installed.
 |
 |            Connecting the clock select and in/out lines to the CPU is optional,
 |            and may be used for experimentation.
 |            If using one display, the clock select should normally be pulled
 |            up high, which results in the clock signal being an output.
 |            This driver software does not currently control these signals.
 |
 |            If using more than one display, the driver software will 
 |            require modification and extension. Multiple displays should
 |            have reset, data, address, flash and read/write lines paralleled.
 |            Each display requires a unique Chip Enable input, and the 
 |            driver software will need to select which display to access.
 |            The first display should have clock select high, and its clock
 |            output connected to the clock inputs on all the other displays;
 |            these should have clock select low to input the clock signal.
 |
 |            Calls to wait_ms() are used to meet the display timing specs
 |            may need to be modified at higher CPU speeds.
 |
 |
 |  Legalese: This software is FREEWARE, and you can adapt it for any
 |            purpose whatsoever. I cannot be held responsible for any
 |            loss, injury, damage or death caused by the use of this 
 |            software.
 |
\*---------------------------------------------------------------------------*/

//Useful stuff to simplify porting of some third party software
 #include <stdarg.h>
 //#include "Utils.h"


/*****************************************************************************/
/*********************  DEFINITIONS FOR HDSP253X DISPLAY  ********************/
/*****************************************************************************/

// Specific delays for display operation, assuming internal clocking
// This may need to be lengthened if a significantly slower external clock is used
#define HDSP253X_1TCY_WAIT_MS       1
//#define HDSP253X_1TCY_WAIT_MS       10
#define HDSP253X_RST_CLR_DELAY_MS   2       // delay AFTER issuing reset or clear
#define HDSP253X_SELFTEST_WAIT_MS   6000    // duration of self test operation

// address values and masks for HDSP253X display access
#define HDSP253X_ADDR_FLASH_BASE    0x00 
#define HDSP253X_ADDR_UDC_ADDRESS   0x20 
#define HDSP253X_ADDR_UDC_ROW_BASE  0x28 
#define HDSP253X_ADDR_CTRL_WORD     0x30 
#define HDSP253X_ADDR_CHAR_BASE     0x38 
// minimises address line power consumption through pullups
#define HDSP253X_ADDR_LOW_POWER     0x3F

// control word masks for HDSP253X display
#define HDSP253X_CTRL_BRIGHT_MASK   0x07 
#define HDSP253X_CTRL_FLASH_MASK    0x08 
#define HDSP253X_CTRL_BLINK_MASK    0x10 
#define HDSP253X_CTRL_STRESULT_MASK 0x20 
#define HDSP253X_CTRL_SELFTEST_MASK 0x40 
#define HDSP253X_CTRL_CLEAR_MASK    0x80 

// Masks for register read, Bit 7 not readable in the target hardware 
#define HDSP253X_CTRL_MASK          0x7F 


// display brightness definitions, indicating percentage brightness
#define HDSP253X_BRIGHT_100         0x00
#define HDSP253X_BRIGHT_80          0x01
#define HDSP253X_BRIGHT_53          0x02
#define HDSP253X_BRIGHT_40          0x03
#define HDSP253X_BRIGHT_27          0x04
#define HDSP253X_BRIGHT_20          0x05
#define HDSP253X_BRIGHT_13          0x06
#define HDSP253X_BRIGHT_0           0x07

// miscellaneous definitions for HDSP253X display
#define HDSP253X_NUM_CHARS          8
#define HDSP253X_CHAR_MASK          0x7F  
#define HDSP253X_UDC_SEL            0x80
#define HDSP253X_UDC_MASK           0x0F
#define HDSP253X_ASCII_UDC_CHARS    0x80

// default display brightness
#define HDSP253X_DEF_DISPLAY_BRIGHT HDSP253X_BRIGHT_100


/** Create an HDSP253X_Display object connected to the proper busses
 *
 * @param  PCF8574_DataBus data databus to connect to 
 * @param  PCF8574_AddressBus address addressbus to connect to 
 * @param  PCF8574_EnableBus enable enablebus to connect to 
 * @param  MBED_ControlBus control controlbus to connect to 
*/
class HDSP253X_Display {
public:
    HDSP253X_Display(PCF8574_DataBus &databus, PCF8574_AddressBus &addressbus,
                     PCF8574_EnableBus &enablebus, MBED_ControlBus &controlbus);
    void cls();                              
    void putc(char disp_char);
//    char getc();    

    void printf (char * format, ...);    
    void locate(uint8_t column);
    void define_user_char(uint8_t udc_char_num, uint8_t row_data_1, uint8_t row_data_2,
                          uint8_t row_data_3, uint8_t row_data_4, uint8_t row_data_5, 
                          uint8_t row_data_6, uint8_t row_data_7);    
    void putudc(char udc_char_num);
                          
    void set_char_flash_state(bool flash_state, uint8_t char_pos);
    void set_all_flash_states(uint8_t flash_bits);
    void set_brightness(uint8_t brightness);  
    void set_blink_mode(bool enable);  
    void set_flash_mode(bool enable);        
    void reset();
    void start_self_test();  
    bool finish_self_test();  
    
protected:
    PCF8574_DataBus &_databus;
    PCF8574_AddressBus &_addressbus;
    PCF8574_EnableBus &_enablebus;
    MBED_ControlBus &_controlbus;

//    int _row;
    int _column;
    void _write(uint8_t address, uint8_t data);
    uint8_t _read(uint8_t address);
    void _init(); 
//    void _display_ascii_char(char ascii_char, uint8_t char_pos);  
//    void _display_udc_char(char udc_char, uint8_t char_pos);  
//    void _display_part_string(const char *disp_string, uint8_t start_pos, uint8_t end_pos);  
//    void _display_fixed_string(const char *disp_string, uint8_t start_pos);
          
};


#endif
/*****************************************************************************/
/******************************  END OF FILE  ********************************/
/*****************************************************************************/

