/* mbed CU209SCPB UDC Library, for Noritake Itron CU209SCPB VFD module
 *
 * Copyright (c) 2017, v01: WH, Initial version
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
#include "CU209SCPB_Config.h"

#if(CU209SCPB_UDC == 1)

//User Defined Characters (UDCs) are a 5x7 Matrix pattern that will show on the VFD as
// 0   P1  P2  P3  P4  P5
// 1   P6  P7 .....    P10
// .    .............
// .    .............
// .    .............
// 6   P31 P32 ...     P35
//

//UDCs are defined by sending a 5 byte bitpattern to the display.
//UDC Command: ESC, 'C', UDC idx
//Followed by:
//UDC Data (4th byte .. 8th byte)
//    D7  D6   D5   D4  D3  D2  D1  D0 
// 0  P8  P7   P6   ......  P3  P2  P1
// 1  P16 P15  P14  ........    P10 P9
// 2  P24 P23  P22  ..........      P17
// 3  P32 P31  P30  ............    P25
// 4  *   *    *    .... *  P35 P34 P33
//

//UDCs are defined by a 5x7 matrix and stored for convenience as 7 bytes with 5 significant bits
//The patterns below will show up in mirrored form on the display
//
// Some sample User Defined Chars 5x7 dots */
const char udc_Bat_Hi[]  = {0x0E, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F};  // Battery Full
const char udc_Bat_Ha[]  = {0x0E, 0x11, 0x13, 0x17, 0x1F, 0x1F, 0x1F};  // Battery Half
const char udc_Bat_Lo[]  = {0x0E, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11};  // Battery Low
const char udc_checker[] = {0xAA, 0x55, 0xAA, 0x55, 0xAA, 0x55, 0xAA};                          
                                          
//const char udc_PO[] = {0x04, 0x0A, 0x0A, 0x1F, 0x1B, 0x1B, 0x1B};  //Padlock Open
//const char udc_PC[] = {0x1C, 0x10, 0x08, 0x1F, 0x1B, 0x1B, 0x1B};  //Padlock Closed

const char udc_LAR[]  = {0x07, 0x03, 0x05, 0x04, 0x04, 0x04, 0x04};   // Left Arrow
const char udc_RAR[]  = {0x1C, 0x18, 0x14, 0x04, 0x04, 0x04, 0x04};   // Right Arrow
#endif
