#include "mbed.h"
#include "SAA1064.h"
#include "PCF8591.h"

#define lpc812  1
#define lpc1768 0

//DigitalOut myled1(LED1);
DigitalOut heartbeatLED(LED1);

//Pin Defines for I2C Bus

#if (lpc1768)
// SDA, SCL for LPC1768
#define D_SDA                  p28
#define D_SCL                  p27
#endif

#if (lpc812)
// SDA, SCL for LPC812
#define D_SDA                  P0_10
#define D_SCL                  P0_11
#endif

//I2C Bus
I2C i2c_bus(D_SDA, D_SCL);


//SAA1064 LED(&i2c_bus, SAA1064_SA0);
SAA1064 LED(&i2c_bus);

//PCF8591 adc_dac(&i2c_bus, PCF8591_SA0);
PCF8591 adc_dac(&i2c_bus);

PCF8591_AnalogOut anaOut(&i2c_bus);

PCF8591_AnalogIn anaIn(&i2c_bus, PCF8591_ADC1);


//Host PC Baudrate (Virtual Com Port on USB)
#define D_BAUDRATE            9600
//#define D_BAUDRATE            57600

// Host PC Communication channels
#if (lpc1768)
Serial pc(USBTX, USBRX); // tx, rx for mbed LPC800 MAX
#endif

#if (lpc812)
Serial pc(P0_4, P0_0); // tx, rx for LPC812 LPCXpresso
#endif

// Variables for Heartbeat and Status monitoring
Ticker heartbeat;
bool heartbeatflag=false;

// Cycle Timer
//const int maxcount = 1000;

// Local functions
void clear_screen() {
//ANSI Terminal Commands
 //   pc.printf("\x1B[2J");
  //  pc.printf("\x1B[H");
}


void init_interfaces() {
    // Init Host PC communication, default is 9600
    //pc.baud(D_BAUDRATE);
      
    // Init I/F hardware
    i2c_bus.frequency(100000);  

    // Init LEDs off
    heartbeatLED = 1; 
}

// Heartbeat monitor
void pulse() {
  heartbeatLED = !heartbeatLED;
}

void heartbeat_start() {
  heartbeat.attach(&pulse, 0.5);
}

void heartbeat_stop() {
  heartbeat.detach();
}


int main() {
  uint8_t slave_address = 0x40; //PCF8574
  char buf[128];  
  uint8_t count = 0;
  uint8_t analog;    

  init_interfaces();
    
  heartbeat_start();
          
  clear_screen(); 
    
  pc.printf("\r\nHello World from LPC812\r\n");

  LED.write(SAA1064_SEGM[0], SAA1064_SEGM[1], SAA1064_SEGM[2], SAA1064_SEGM[3]);
//  LED.write(SAA1064_SEGM[4], SAA1064_SEGM[5], SAA1064_SEGM[6], SAA1064_SEGM[7]);
//  LED.write(SAA1064_SEGM[8], SAA1064_SEGM[9], SAA1064_SEGM[0x0A], SAA1064_SEGM[0x0B]);
//  LED.write(SAA1064_SEGM[0x0C], SAA1064_SEGM[0x0D], SAA1064_SEGM[0x0E], SAA1064_SEGM[0x0F]);

   wait(1.0);    

   LED.snake(1); 
   wait(1.0);    
       
   LED.snake(4);
   wait(1.0);    

   LED.splash(6);
   wait(1.0);    


//LPC812 I2C BLOCKWRITE BUG: ADC results are unstable, DAC values leaking through...    
//The Heartbeat Interrupt also seems to make the problem worse

// Test for PCF8591          
  while(1) {
    float ana;  
    //pc.putc('*');            
  
    wait_ms(20);        

//    analog = adc_dac.read(PCF8591_ADC0);  // read A/D value for Channel 0 (LDR)
//    analog = adc_dac.read(PCF8591_ADC1);  // read A/D value for Channel 1 (potmeter)   
//    pc.printf("%d ", analog);      
   
    ana=anaIn;     
    pc.printf("%2.2f ", ana);           
    
//    pc.printf("%2.2f ", anaIn);                   

    anaOut = ana;    
  }
  

// Test for SAA1064 and PCF8591          
  while(0) {
              
    //pc.printf("*");        
    pc.putc('*');            
    wait_ms(200);    

    buf[0] = count;
    i2c_bus.write(slave_address, buf, 1);
    count++;       
    
//    LED.writeInt(-150 + count, 3, false);    
    LED.writeInt(-150 + count, 3);    //suppress leading zero
    
    adc_dac.write(count);                 // write D/A value

//    analog = adc_dac.read(PCF8591_ADC0);  // read A/D value for Channel 0 (LDR)
    analog = adc_dac.read(PCF8591_ADC1);  // read A/D value for Channel 1 (potmeter)   
    pc.printf("%d ", analog);        
   
  }
  
//  pc.printf("Bye World!\n\r");   
}
