#include "mbed.h"
#include "AnaloginDMA.h"
#include "ff_gen_drv.h"
#include "stm32_adafruit_lcd.h"
#include "stm32_adafruit_sd.h"
#include "stm32f4xx_nucleo.h"

extern Diskio_drvTypeDef  SD_Driver; 

PwmOut mypwm(PWM_OUT);          // This is the TX pulse pin
AnalogInDMA adc1(PA_0);              // This is the ADC pin
PwmOut buzzer(PC_9);             // This is the digital out pin connected to the buzzer
InterruptIn event(PA_0);          // This sets a semaphore on rising front of pulse pin
DigitalIn button(USER_BUTTON);
Timeout timer;                  // This sets the net reading period

uint16_t reading[50][500];                  // most current ADC capture values 
uint16_t data_buf[500];   
bool sema, end_period;
int n, nbsamples;

int linenr;
FIL gp_file;
FIL grid_file;
char  buf[256];
int filenum;

// system parameters
float Gradient_Threshold = 0.05;    // audio threshold 
int reading_period = 10000;         // in µsec
int integration_ratio = 10;
int pulse_period = 207;
int pulse_width = 200;


void read_one_pulse () {
    sema = false;
    while (!sema)
        ;
    adc1.read(&reading[n][0],nbsamples);
    }

void trigger () {
    sema = true;
    }

void TO() {
   end_period = true;
   }

static int TFT_ShieldDetect(void)
{
  GPIO_InitTypeDef  GPIO_InitStruct; 

  /* Enable GPIO clock */
  __GPIOB_CLK_ENABLE();
  
  GPIO_InitStruct.Pin = GPIO_PIN_0;
  GPIO_InitStruct.Mode = GPIO_MODE_INPUT;
  GPIO_InitStruct.Pull = GPIO_PULLDOWN;
  HAL_GPIO_Init(GPIOB, &GPIO_InitStruct);
  
  if(HAL_GPIO_ReadPin(GPIOB, GPIO_PIN_0) != 0)
  {
    return 1;
  }
  else
  {
    return 0;
  }
}

int get_num(void) {
FIL f;
int i;
UINT br;
    if ( f_open( &f,  "NUM.BIN" , FA_READ ) == 0) {
        f_read (&f,&i,4,&br);
        i++;
        f_close(&f);
        }
    else 
        i = 1;
    f_open( &f, "NUM.BIN" , FA_WRITE | FA_OPEN_ALWAYS );
    f_write(&f,&i,4,&br);
    f_close(&f);
    return(i);
}

void OpenGrid(char* grid_name){
int i;
    f_unlink( grid_name );
    i = f_open( &grid_file, grid_name , FA_WRITE | FA_OPEN_ALWAYS );
}
 
void CloseGrid(void){
    f_close( &grid_file );
}
   

void Save_Buffer(void) {
int i,j;
UINT byteswritten;
//    data_buf[0] = T1TC;
    j = (nbsamples+5)*2;
    i = 0;


    i = f_write(&grid_file,&linenr,2,&byteswritten);
    i = f_write(&grid_file,data_buf,j,&byteswritten);
//  i = f_write(&grid_file,buf,strlen(buf),&byteswritten);
    if (i > 0) {
//      generate_tics (5, 200);
        return;
        }
    if (byteswritten < j) {
//      generate_tics (5, 200);
        return;
        }
    f_sync(&grid_file);
    }

void convert_file(void) {
UINT i,byteswritten,bytesread;
float r = 3300.0/1024.0;
//      sprintf(buf,"grid%i.BIN",filenum);
        if ( f_open( &gp_file,  "grid.$$$" , FA_READ ) == 0) {
//          sprintf(buf,"grid%i.TXT",filenum);
            i = f_open( &grid_file, "grid.txt" , FA_WRITE | FA_OPEN_ALWAYS );
            strcpy(buf,"SESSION\r\n");
            f_write(&grid_file,buf,strlen(buf),&byteswritten);
            while (1) {
                f_read (&gp_file,&linenr,4,(UINT *)&bytesread);
                if (bytesread < 4 || linenr == 0xFFFFFFFF)
                    break;
                sprintf(buf,"$ %u 0 ",linenr);
                f_write(&grid_file,buf,strlen(buf),&byteswritten);
                f_read (&gp_file,&data_buf,(nbsamples+5)*2,(UINT *)&bytesread);
                if (bytesread < (nbsamples+5)*2 || data_buf[0] == 0xFFFFFFFF)
                    break;
                sprintf(buf,"%i ",data_buf[0]);
                f_write(&grid_file,buf,strlen(buf),&byteswritten);
                for (i = 1;i<nbsamples+1;i++) {
                    sprintf(buf,"%0.0f ",r*data_buf[i]);
                    f_write(&grid_file,buf,strlen(buf),&byteswritten);
                    }
                for (i = nbsamples+1;i<nbsamples+5;i++) {
                    sprintf(buf,"%i ",data_buf[i]);
                    f_write(&grid_file,buf,strlen(buf),&byteswritten);
                    }
                f_write(&grid_file,"\r\n",2,&byteswritten);
                }

            }
        f_truncate (&grid_file);
        f_close( &gp_file );
        f_close( &grid_file );
        filenum = get_num();
        sprintf(buf,"grid%i.TXT",filenum);
        f_rename("grid.txt",buf );
//        generate_tics (5, 200);

}

  
int main() {

    uint16_t ref_reading[500];          // Reference reading of ground signal
    int sample_count;
    int delta, j;
    UINT i;
    char SD_Path[4];
    FATFS SD_FatFs;  /* File system object for SD card logical drive */


 
    if(TFT_ShieldDetect() == 0)
        {
        /* Initialize the LCD */
        BSP_LCD_Init();
        /* Initialize the Joystick available on adafruit 1.8" TFT shield */
        BSP_JOY_Init();
        FATFS_LinkDriver(&SD_Driver, SD_Path);
        /* Initialize the SD mounted on adafruit 1.8" TFT shield */
        BSP_SD_Init();
        f_mount(&SD_FatFs, (TCHAR const*)"/", 0);  
        }       
    mypwm.period_us(pulse_period);
    mypwm.pulsewidth_us(0);
    buzzer.period_ms(0);
    buzzer.write(50);
    event.rise(&trigger);
    
    while (button == 1)     //Wait to start session until button is pressed and released
        ;
    while (button == 0)
        ;       
    sample_count = 0;
    OpenGrid("grid.$$$");
    while(1) {
        end_period = false;
        timer.attach_us(&TO,reading_period);
        mypwm.pulsewidth_us(pulse_width);       // Start TX pulses
        nbsamples = pulse_period*2;
        for (n=0;n<integration_ratio;n++)
            read_one_pulse();                   // Accumulate ADC captures into reading
        mypwm.pulsewidth_us(0);                 // Stop TX pulses
        for (i=0; i < nbsamples;i++) {
            data_buf[j] = 0;
            for (j=0; j < integration_ratio;j++)
                data_buf[j] += reading[j][i];
            }
        for (i=0; i < nbsamples;i++)
            data_buf[i] /= integration_ratio;           // Average reading
        if (sample_count == 0) {                // If first reading of session, save reading into ground reference signal level
            for (i=0; i < integration_ratio;i++)
                ref_reading[i] = data_buf[i];
            sample_count++;
            }
        delta = ref_reading[0] - data_buf[0];          // Delta is the gradient
        if (abs(delta) > Gradient_Threshold )   // if hte graient is larger than a threshold, start buzzing
            buzzer.period_ms(1);
        else 
            buzzer.period_ms(0);
        if (delta != 0 && abs(delta) <= 0.01 )  // If delta is small enough but not nul, update the ref_reading with th ecurrent reading through a powerful low pass FIR filter.
            for (i=0; i < integration_ratio;i++)
               ref_reading[i] = (ref_reading[i]*127 + reading[0][i] ) / 128;
        Save_Buffer();
        if (button == 0) {                      // pushing again on the button and relasing it stops the session
            while (button == 0)
                ;
            data_buf[0] = 0xFFFF;
            f_write(&grid_file,data_buf,(nbsamples+1)*2,&i);            CloseGrid();
            return(0);
            }
        while (!end_period)             // Wait for end of reading period (i.e. 10msec)
            ;
      }
}

