#include "mbed.h"
#include "Queue.h"

#define     COMMAND_ON          0X70
#define     COMMAND_INIT        0X71
#define     COMMAND_GPRS        0X72
#define     COMMAND_DATA        0X73
#define     COMMAND_POST        0X74
#define     COMMAND_ANSWER      0X75
#define     COMMAND_SIGNAL      0X76
#define     COMMAND_CONNECT     0X77
#define     COMMAND_OFF         0X78
#define     HOSTING_STEP1       0x79
#define     HOSTING_STEP2       0x7A
#define     HOSTING_STEP3       0x7B
#define     HOSTING_STEP4       0x7C
#define     HOSTING_STEP5       0x7D
#define     HOSTING_STEP6       0x7E
#define     HOSTING_STEP7       0x7F
#define     HOSTING_STEP8       0x80
#define     HOSTING_STEP9       0x81
#define     HOSTING_STEP10      0x82
#define     HOSTING_STEP11      0x83
#define     HOSTING_OFF         0x84
#define     NEXT_STEP           0x85
#define     NEXT_SLEEP          0x86
#define     NO_DATA             0x87
#define     COMMAND_END         0X88

RawSerial   Computer(SERIAL_TX, SERIAL_RX,9600);      // tx, rx
RawSerial   Master(PC_1, PC_0,9600);
RawSerial   Gsm(PA_0,PA_1,19200);

DigitalOut  EnableSIM900(PB_0);
DigitalOut  ResetSIM900(PA_10);
DigitalOut  Led(LED2);
DigitalIn   Button(USER_BUTTON);

Timer       BaseClock;
QUEUE       MasterCommand;

char Command;
int  Sim900_Counter=0;
char Sim900_Buffer[1000];
unsigned long Inicio, Fin, Transcurrido;
char HostingData[]="{\"municipio\":\"San Jose\",\"id\":\"1068\",\"alerts\":\"AAAAAA\"}\r\n";//"municipio":"San Jose","id":1068, "alerts":"AAAAAA"}
char HostingAnswer[]="OK+000+00:00";
char Encrypt[174];

void Interrupt_Sim900()
{
    if(Gsm.readable()) {
        Sim900_Buffer[Sim900_Counter]=Gsm.getc();
        Sim900_Counter++;
    }
}

void Interrupt_Master()
{
    if(Master.readable()) {
        MasterCommand.Put(Master.getc());
    }
}

void PrintSerialRepeat(char Command[],char Answer[],uint32_t Espera,uint32_t Delay)//
{
    if(Gsm.writeable()) {
        Gsm.printf("%s",Command);
    }
    Sim900_Counter=0;
    bool TimeOut=0;
    bool RightAnswer1=0;
    bool RightAnswer2=0;
    Inicio=BaseClock.read_ms();

    while(true) {               // Esta funcion detiene el programa y espera una respuesta
        Fin=BaseClock.read_ms();
        Transcurrido=Fin-Inicio;
        if(Sim900_Counter>5) {
            TimeOut=1;
            break;
        }
        if(Transcurrido>Espera) {
            TimeOut=0;
            break;
        }
    }
    wait_ms(Delay);
    if(TimeOut) {
        for(int i=0; i<Sim900_Counter; i++) {
            Computer.putc(Sim900_Buffer[i]);
            if(Sim900_Buffer[i]==Answer[0]) {
                RightAnswer1=1;
            }
            if(Sim900_Buffer[i]==Answer[1]) {
                RightAnswer2=1;
            }
        }
        if(RightAnswer1 && RightAnswer2) {
            Computer.printf("OK-> Respuesta correcta\n");
        } else {
            Computer.printf("ERROR-> Respuesta incorrecta\n");
            wait_ms(2000);

            Gsm.printf("%s",Command);
            Sim900_Counter=0;
            TimeOut=0;
            RightAnswer1=0;
            RightAnswer2=0;
            Inicio=BaseClock.read_ms();

            while(true) {               // Esta funcion detiene el programa y espera una respuesta
                Fin=BaseClock.read_ms();
                Transcurrido=Fin-Inicio;
                if(Sim900_Counter>0) {
                    TimeOut=1;
                    break;
                }
                if(Transcurrido>Espera) {
                    TimeOut=0;
                    break;
                }
            }
            wait_ms(Delay);
            if(TimeOut) {
                for(int i=0; i<Sim900_Counter; i++) {
                    Computer.putc(Sim900_Buffer[i]);
                    if(Sim900_Buffer[i]==Answer[0]) {
                        RightAnswer1=1;
                    }
                    if(Sim900_Buffer[i]==Answer[1]) {
                        RightAnswer2=1;
                    }
                }
                if(RightAnswer1 && RightAnswer2) {
                    Computer.printf("OK-> Respuesta correcta\n");
                } else {
                    Computer.printf("ERROR-> Respuesta incorrecta\n");
                }
            } else {
                Computer.printf("ERROR-> Sin respuesta\n");
            }
        }
    } else {
        Computer.printf("ERROR-> Sin respuesta\n");
    }
}

void EncenderSIM900()
{
    Sim900_Counter=0;
    if(Gsm.writeable()) {
        Gsm.printf("AT\r\n");
    }
    wait_ms(100);

    if(Sim900_Counter==0) {
        Sim900_Counter=0;
        EnableSIM900 = 1;
        wait_ms(600);
        EnableSIM900 = 0;
        wait_ms(1000);

        bool TimeOut=0;
        bool RightAnswer1=0;
        bool RightAnswer2=0;
        bool WrongAnswer1=0;
        bool WrongAnswer2=0;
        Inicio=BaseClock.read_ms();

        while(true) {               // Esta funcion detiene el programa y espera una respuesta
            Fin=BaseClock.read_ms();
            Transcurrido=Fin-Inicio;
            if(Sim900_Counter>5) {
                TimeOut=1;
                break;
            }
            if(Transcurrido>1000) {
                TimeOut=0;
                break;
            }
        }
        wait_ms(500);
        if(TimeOut) {
            for(int i=0; i<Sim900_Counter; i++) {
                Computer.putc(Sim900_Buffer[i]);
                if(Sim900_Buffer[i]=='F') {
                    RightAnswer1=1;
                }
                if(Sim900_Buffer[i]=='I') {
                    RightAnswer2=1;
                }
                if(Sim900_Buffer[i]=='O') {
                    WrongAnswer1=1;
                }
                if(Sim900_Buffer[i]=='W') {
                    WrongAnswer2=1;
                }
            }
            if(RightAnswer1 && RightAnswer2) {
                Computer.printf("OK-> Encendido correctamente\n");
                wait_ms(3500);
            } else {
                if(WrongAnswer1 && WrongAnswer2) {
                    Computer.printf("OK-> Apagado error\n");
                    wait_ms(4000);
                    Sim900_Counter=0;
                    EnableSIM900 = 1;
                    wait_ms(600);
                    EnableSIM900 = 0;
                    wait_ms(5000);
                }
            }
        }
    } else {
        for(int i=0; i<=Sim900_Counter; i++) {
            Computer.putc(Sim900_Buffer[i]);
        }
    }

}

void IniciarSIM900()
{
    PrintSerialRepeat("AT+CPIN?\r\n","OK",500,75);                                       // Respuesta +CPIN: READY\n\nOK
    PrintSerialRepeat("AT+CSQ\r\n","OK",500,100);                                        // Respuesta +Señal Disponible   OK
    PrintSerialRepeat("AT+CREG=1\r\n","OK",500,250);                                     // Peticion de conexion GPRS   OK
    wait(2);
}

void ConexionGPRS()
{
    PrintSerialRepeat("AT+CGATT=1\r\n","OK",2000,1000); 
    PrintSerialRepeat("AT+SAPBR=1,1\r\n","OK",500,1000);  
    if(Master.writeable()) {
       Master.putc(NEXT_STEP);
    }                                
}

void ApagarSIM900()
{
    PrintSerialRepeat("AT+CPOWD=1\r\n","WD",500,500);
    wait_ms(1000);

    Sim900_Counter=0;
    if(Gsm.writeable()) {
        Gsm.printf("AT\r\n");
    }
    wait_ms(100);

    if(Sim900_Counter>5) {
        EnableSIM900 = 1;
        wait_ms(600);
        EnableSIM900 = 0;
    }
}

void PostEncryptHTTP()
{
    PrintSerialRepeat("AT+HTTPINIT\r\n","OK",500,50);                                     // Iniciar servicio HTTP, Respuesta OK
    //PrintSerialRepeat("AT+HTTPPARA=\"CID\",1\r\n","OK",500,50);  
    PrintSerialRepeat("AT+HTTPPARA=\"URL\",\"http://52.39.146.172:8181/AIGRest/AIGService/parkPQ\"\r\n","OK",1500,140);   // AT+HTTPPARA="URL","http://34.211.174.1:8080/AIGRest/AIGService/parkPQ"
    //PrintSerialRepeat("AT+HTTPPARA=\"URL\",\"http://34.211.174.1:8080/AIGRest/AIGService/parkPQ\"\r\n","OK",1500,140);
    //PrintSerialData("AT+HTTPPARA=\"URL\",\"https://www.e-park.cr/AIGRest/AIGService/parkPQ\"\r\n","OK",1500,140);   // AT+HTTPPARA="URL","http://34.211.174.1:8080/AIGRest/AIGService/parkPQ"
    PrintSerialRepeat("AT+HTTPPARA=\"CONTENT\",\"application/json\"\r\n","OK",500,75);    // AT+HTTPPARA="CONTENT","application/json"
    char Len[24];
    sprintf(Len,"AT+HTTPDATA=%i,10000\r\n",(strlen(Encrypt)));
    if(Gsm.writeable()) {
        Gsm.printf("%s",Len);
    }                                                                                   // Envio de parametros de la informacion, Respuesta DOWNLOAD OK
    wait_ms(200);
    if(Gsm.writeable()) {
        for(int i=0; i<174; i++) {
            Gsm.putc(Encrypt[i]);
        }
    }                                                                                   // Envio de informacion al web servicio
    wait_ms(500);
    for(int i=0; i<=Sim900_Counter; i++) {
        Computer.putc(Sim900_Buffer[i]);
    }
    wait_ms(500);
    PrintSerialRepeat("AT+HTTPACTION=1\r\n","OK",8000,1800);                              // Respuesta OK +HTTPACTION:1,200,7
}

void PrintEncryption()
{
    Computer.printf("Mensaje: ");
    for(int i=0; i<173; i++) {
        Computer.putc(Encrypt[i]);
    }
}

void RespuestaHTTP()
{
    PrintSerialRepeat("AT+HTTPREAD=0,9000\r\n","OK",500,150);
    Sim900_Counter=0;
    Inicio=BaseClock.read_ms();
    while(true) {               // Esta funcion detiene el programa y espera una respuesta
        Fin=BaseClock.read_ms();
        Transcurrido=Fin-Inicio;
        if(Sim900_Counter>10) {
            break;
        }
        if(Transcurrido>20000) {
            break;
        }
    }
    wait_ms(150);
    Sim900_Counter=0;                             // +HTTPREAD:7 OKAlpha, OK+310325+10:29+2018-04-10
    bool RightAnswer1=0;
    bool RightAnswer2=0;
    bool RightAnswer3=0;
    int  RightAnswer4=0;
    bool WrongAnswer1=0;
    int  WrongAnswer2=0;


    if(Gsm.writeable()) {
        Gsm.printf("AT+HTTPREAD=0,9000\r\n");
    }
    wait_ms(250);
    for(int i=0; i<Sim900_Counter; i++) {
        Computer.printf("%c",Sim900_Buffer[i]);
        if(Sim900_Buffer[i]=='O') {
            RightAnswer1=1;
        }
        if(Sim900_Buffer[i]=='K') {
            RightAnswer2=1;
        }
        if(Sim900_Buffer[i]=='-') {
            RightAnswer3=1;
        }
        if(Sim900_Buffer[i]=='E') {
            WrongAnswer1=1;
        }
        if(Sim900_Buffer[i]=='R') {
            WrongAnswer2++;
        }
        if(Sim900_Buffer[i]=='+') {
            RightAnswer4++;
        }
    }

    if(RightAnswer4==1&&WrongAnswer2==1) {
        Computer.printf("Respuesta incompleta %s\n",RightAnswer4 );
        PrintSerialRepeat("AT+HTTPREAD=0,9000\r\n","OK",500,150);
        Sim900_Counter=0;
        Computer.printf("Esperando respuesta\n");
        Inicio=BaseClock.read_ms();
        while(true) {               // Esta funcion detiene el programa y espera una respuesta
            Fin=BaseClock.read_ms();
            Transcurrido=Fin-Inicio;
            if(Sim900_Counter>10) {
                break;
            }
            if(Transcurrido>20000) {
                break;
            }
        }
        wait_ms(250);                                 // +HTTPREAD:7 OKAlpha, OK+310325+10:29+2018-04-10
        RightAnswer1=0;
        RightAnswer2=0;
        RightAnswer3=0;
        RightAnswer4=0;

        PrintSerialRepeat("AT+HTTPREAD=0,9000\r\n","OK",500,250);
        for(int i=0; i<Sim900_Counter; i++) {
            Computer.printf("%c",Sim900_Buffer[i]);
            if(Sim900_Buffer[i]=='O') {
                RightAnswer1=1;
            }
            if(Sim900_Buffer[i]=='K') {
                RightAnswer2=1;
            }
            if(Sim900_Buffer[i]=='-') {
                RightAnswer3=1;
            }
            if(Sim900_Buffer[i]=='+') {
                RightAnswer4++;
            }
        }
    }

    if(RightAnswer3&&RightAnswer2&&RightAnswer1) {
        Computer.printf("Aceptada\n");
        if(Master.writeable()) {
            Computer.printf("<--");
            for(int i=37; i<=(Sim900_Counter-6); i++) {
                Master.putc(Sim900_Buffer[i]);
                Computer.putc(Sim900_Buffer[i]);
            }
            Master.putc('A');
            Computer.printf("-->");
        }
    } else if(WrongAnswer1&&(WrongAnswer2>1)) {
        Computer.printf("Rechazada\n");
        if(Master.writeable()) {
            Master.printf("Rechazada");
            Master.putc('R');
        }
    } else {
        Computer.printf("Sin respuesta\n");
        if(Master.writeable()) {
            Master.printf("Rechazada");
            Master.putc('R');
        }
    }
    PrintSerialRepeat("AT+HTTPTERM\r\n","OK",500,50);
    PrintSerialRepeat("AT+SAPBR=0,1\r\n","OK",500,50);
}


void FinalizarComunicacion()
{
    PrintSerialRepeat("AT+SAPBR=0,1\r\n","OK",500,50);
}

void ReadUsuario()
{
    Computer.printf("Read Usuario\n");
    wait_ms(1000);
    for(int i=0; i<172; i++) {
        Encrypt[i]=MasterCommand.Get();
        Computer.printf("-%c-",Encrypt[i]);
    }
    Encrypt[173]='\r';
    if(Master.writeable()) {
        Master.putc(NEXT_STEP);
    }
}

void ConexionSIM900()
{
    Sim900_Counter=0;
    EnableSIM900 = 1;
    wait_ms(600);
    EnableSIM900 = 0;
    char ConectionEnable;
    Inicio=BaseClock.read_ms();
    while (true) {
        Fin=BaseClock.read_ms();
        Transcurrido=Fin-Inicio;
        if(Sim900_Counter>0) {
            Computer.printf("Conectado\n");
            ConectionEnable='A';
            break;
        }
        if(Transcurrido>5000) {
            Computer.printf("Desconectado\n");
            ConectionEnable='E';
            break;
        }
    }
    if(Master.writeable()) {
        Master.putc(ConectionEnable);
    }
    wait(5);
    ApagarSIM900();
}

void CoberturaSIM900()
{
    Sim900_Counter=0;
    EnableSIM900 = 1;
    wait_ms(600);
    EnableSIM900 = 0;
    wait_ms(6000);
    Sim900_Counter=0;

    if(Gsm.writeable()) {
        Gsm.printf("AT+CSQ\r\n");
    }

    Inicio=BaseClock.read_ms();
    while (true) {
        Fin=BaseClock.read_ms();
        Transcurrido=Fin-Inicio;
        if(Sim900_Counter>0) {
            wait_ms(75);
            break;
        }
        if(Transcurrido>1000) {
            break;
        }
    }
    if(Sim900_Counter>0) {
        for(int i=0; i<Sim900_Counter; i++) {
            Computer.printf("%c",Sim900_Buffer[i]);
            if(((uint8_t)Sim900_Buffer[i]>=0x30)&&((uint8_t)Sim900_Buffer[i]<0x3A)) {
                if(Master.writeable()) {
                    Master.putc(Sim900_Buffer[i]);
                }
            }
            Computer.putc(Sim900_Buffer[i]);
        }
        if(Master.writeable()) {
            Master.putc('A');
        }
    } else {
        if(Master.writeable()) {
            Master.putc('E');
        }
    }
    ApagarSIM900();
    wait_ms(3900);
}
void Step1()
{
    Computer.printf("Encender\n");
    EncenderSIM900();
    wait(5);
    if(Master.writeable()) {
        Master.putc(NEXT_STEP);
    }
}

void Step2(){
    PrintSerialRepeat("AT+CPIN?\r\n","OK",500,75);                                       // Respuesta +CPIN: READY\n\nOK
    PrintSerialRepeat("AT+CSQ\r\n","OK",500,100); 
    PrintSerialRepeat("AT+CREG=1\r\n","OK",500,250); 
    PrintSerialRepeat("AT+CIPSHUT\r\n","OK",500,150);                                         // Respuesta OK
    
    if(Master.writeable()) {
        Master.putc(NEXT_STEP);
    }
}

void Step3()
{
    PrintSerialRepeat("AT+CIPSTATUS\r\n","OK",500,100);                                   // Respuesta OK  STATE: IP INITIAL
    PrintSerialRepeat("AT+CIPMUX=0\r\n","OK",500,100);                                    // Respuesta OK
    wait(4);
    PrintSerialRepeat("AT+CGATT=1\r\n","OK",2000,3000);
    if(Master.writeable()) {
        Master.putc(NEXT_STEP);
    }
}

void Step4()
{
    wait(3);
    if(Master.writeable()) {
        Master.putc(NEXT_STEP);
    }
}

void Step5()
{
    //PrintSerialRepeat("AT+SAPBR=3,1,\"CONTYPE\",\"GPRS\"\r\n","OK",500,100);              // Respuesta OK
    //PrintSerialRepeat("AT+SAPBR=3,1,\"APN\",\"\"\r\n","OK",500,100);                      // Respuesta OK, AT+SAPBR=3,1,"APN",""
    wait(3);
    if(Master.writeable()) {
        Master.putc(NEXT_STEP);
    }
}
void Step6()
{
    PrintSerialRepeat("AT+SAPBR=1,1\r\n","OK",500,1000);                                  // Respuesta OK
    //PrintSerialRepeat("AT+SAPBR=2,1\r\n","OK",500,1000); 
    if(Master.writeable()) {
        Master.putc(NEXT_STEP);
    }
}

void Step7()
{
    PrintSerialRepeat("AT+HTTPINIT\r\n","OK",500,50); 
    //PrintSerialRepeat("AT+HTTPPARA=\"CID\",1\r\n","OK",500,50);                                    
    //PrintSerialRepeat("AT+HTTPPARA=\"REDIR\",1\r\n","OK",1500,140); 
    PrintSerialRepeat("AT+HTTPPARA=\"URL\",\"http://52.39.146.172:8181/AIGRest/AIGService/alertPQ\"\r\n","OK",1500,140);  
    //PrintSerialRepeat("AT+HTTPPARA=\"URL\",\"http://34.211.174.1:8080/AIGRest/AIGService/alertPQ\"\r\n","OK",1500,140);   
    if(Master.writeable()) {
        Master.putc(NEXT_STEP);
    }
}

void Step8()
{
    //char HostingData[]="{\"municipio\":\"Santa Ana\",\"id\":0000, \"alerts\":\"000000\"}\r\n";
    Computer.printf("%s\n",HostingData);
    wait_ms(100);
    // Municipio
    HostingData[14]=MasterCommand.Get();
    HostingData[15]=MasterCommand.Get();
    HostingData[16]=MasterCommand.Get();
    HostingData[17]=MasterCommand.Get();
    HostingData[18]=MasterCommand.Get();
    HostingData[19]=MasterCommand.Get();
    HostingData[20]=MasterCommand.Get();
    HostingData[21]=MasterCommand.Get();
    // Alarmas
    HostingData[46]=MasterCommand.Get();
    HostingData[47]=MasterCommand.Get();
    HostingData[48]=MasterCommand.Get();
    HostingData[49]=MasterCommand.Get();
    HostingData[50]=MasterCommand.Get();
    HostingData[51]=MasterCommand.Get();
    // Identificador
    HostingData[30]=MasterCommand.Get();
    HostingData[31]=MasterCommand.Get();
    HostingData[32]=MasterCommand.Get();
    HostingData[33]=MasterCommand.Get();
    Computer.printf("%s\n",HostingData);
    PrintSerialRepeat("AT+HTTPPARA=\"CONTENT\",\"application/json\"\r\n","OK",500,75);    // AT+HTTPPARA="CONTENT","application/json"
    if(Master.writeable()) {
        Master.putc(NEXT_STEP);
    }
}

void Step9()
{
    Computer.printf("-1-\n");
    char Len[23];
    Sim900_Counter=0;
    sprintf(Len,"AT+HTTPDATA=%i,10000\r\n",(strlen(HostingData)));
    if(Gsm.writeable()) {
        Gsm.printf("%s",Len);
    }                                                 // Envio de parametros de la informacion, Respuesta DOWNLOAD OK
    Computer.printf("-2-\n");
    wait_ms(200);
    if(Gsm.writeable()) {
        Gsm.printf("%s",HostingData);
    }                                             // Envio de informacion al web servicio
    wait_ms(200);
    for(int i=0; i<=Sim900_Counter; i++) {
        Computer.putc(Sim900_Buffer[i]);
    }
    Computer.printf("-3-\n");
    //PrintSerialRepeat("AT+HTTPSCONT?\r\n","OK",8000,1800);
    PrintSerialRepeat("AT+HTTPACTION=1\r\n","OK",8000,1800);
    if(Master.writeable()) {
        Master.putc(NEXT_STEP);
    }
    Computer.printf("-4-\n");
}

void Step10()
{
    PrintSerialRepeat("AT+HTTPREAD=0,9000\r\n","OK",150,50);
    Sim900_Counter=0;
    Computer.printf("Esperando respuesta\n");
    Inicio=BaseClock.read_ms();
    while(true) {               // Esta funcion detiene el programa y espera una respuesta
        Fin=BaseClock.read_ms();
        Transcurrido=Fin-Inicio;
        if(Sim900_Counter>10) {
            Computer.printf("Recibido\n");
            break;
        }
        if(Transcurrido>9000) {
            Computer.printf("Tiempo\n");
            break;
        }
    }
    wait_ms(50);  
                                
    bool RightAnswer1=0;
    bool RightAnswer2=0;
    bool RightAnswer3=0;    
    Sim900_Counter=0;
    if(Gsm.writeable()) {
        Gsm.printf("AT+HTTPREAD=0,9000\r\n");
    }      
    wait_ms(100); 

    for(int i=0; i<Sim900_Counter; i++) {
        Computer.putc(Sim900_Buffer[i]);
        if(Sim900_Buffer[i]=='O') {
            RightAnswer1=1;
        }
        if(Sim900_Buffer[i]=='K') {
            RightAnswer2=1;
        }
        if(Sim900_Buffer[i]=='+') {
            RightAnswer3=1;
        }
    }
    if(RightAnswer3&&RightAnswer2&&RightAnswer1) {
        HostingAnswer[0]=Sim900_Buffer[36];
        HostingAnswer[1]=Sim900_Buffer[37];
        HostingAnswer[2]=Sim900_Buffer[38];
        HostingAnswer[3]=Sim900_Buffer[39];
        HostingAnswer[4]=Sim900_Buffer[40];
        HostingAnswer[5]=Sim900_Buffer[41];        
        HostingAnswer[6]=Sim900_Buffer[42];
        HostingAnswer[7]=Sim900_Buffer[43];
        HostingAnswer[8]=Sim900_Buffer[44];
        HostingAnswer[9]=Sim900_Buffer[45];
        HostingAnswer[10]=Sim900_Buffer[46];
        HostingAnswer[11]=Sim900_Buffer[47];
        Computer.printf("Aceptada\n");
        Computer.printf("<--%s-->\n",HostingAnswer);
    } else {
        Computer.printf("Rechazada\n");
    }
    if(Master.writeable()) {
        Master.putc(NEXT_STEP);
    }
}

void Step11()
{
    if(Master.writeable()) {
        Master.printf("%s",HostingAnswer);
        Computer.printf("<--%s-->",HostingAnswer);
    }
    //PrintSerialRepeat("AT+HTTPSCONT?\r\n","OK",2000,2000);
    //PrintSerialRepeat("AT+HTTPPARA?\r\n","OK",2000,2000);
    //PrintSerialRepeat("AT+SAPBR=4,1\r\n","OK",500,50);
    PrintSerialRepeat("AT+HTTPTERM\r\n","OK",500,50);
    PrintSerialRepeat("AT+SAPBR=0,1\r\n","OK",500,50);
    if(Master.writeable()) {
        Master.putc(NEXT_STEP);
    }
    HostingAnswer[0]='0';
    HostingAnswer[1]='0';
    HostingAnswer[2]='0';
    HostingAnswer[3]='0';
    HostingAnswer[4]='0';
    HostingAnswer[5]='0';
    wait_ms(3900);
}

int main()
{
    Gsm.attach(&Interrupt_Sim900);
    Master.attach(&Interrupt_Master);
    BaseClock.start();
    Computer.printf("Paquimetro 1067 Produccion\n");
    Led=0;
    ResetSIM900=0;
    while(1) {
        if(Button==0) {
            Led=1;
            BaseClock.start();
            BaseClock.reset();
            Computer.printf("Button\n");
            EncenderSIM900();
            BaseClock.stop();
            Led=0;
        }
        while(MasterCommand.Available()>0) {
            Command=MasterCommand.Get();
            switch (Command) {
                case COMMAND_ON:
                    Computer.printf("-> -> Encender\n");
                    BaseClock.start();
                    BaseClock.reset();
                    EncenderSIM900();
                    break;

                case COMMAND_INIT:
                    Computer.printf("-> -> Iniciar\n");
                    IniciarSIM900();
                    break;

                case COMMAND_GPRS:
                    Computer.printf("-> -> GPRS\n");
                    ConexionGPRS();
                    break;

                case COMMAND_DATA:
                    Computer.printf("-> -> Datos\n");
                    ReadUsuario();
                    break;

                case COMMAND_POST:
                    Computer.printf("-> -> Post HTTP\n");
                    PostEncryptHTTP();
                    break;

                case COMMAND_ANSWER:
                    Computer.printf("-> -> Respuesta\n");
                    RespuestaHTTP();
                    break;

                case COMMAND_END :
                    Computer.printf("-> -> finalizar tiempo\n");
                    FinalizarComunicacion();
                    break;

                case COMMAND_SIGNAL:
                    Computer.printf("Cobertura Sim900\n");
                    BaseClock.start();
                    BaseClock.reset();
                    CoberturaSIM900();
                    BaseClock.stop();
                    break;

                case COMMAND_CONNECT:
                    Computer.printf("Conexion Sim900\n");
                    BaseClock.start();
                    BaseClock.reset();
                    ConexionSIM900();
                    BaseClock.stop();
                    break;

                case COMMAND_OFF:
                    Computer.printf("-> -> Apagar\n");
                    MasterCommand.Flush();
                    ApagarSIM900();
                    wait_ms(4000);
                    BaseClock.stop();
                    break;

                case HOSTING_STEP1:
                    Computer.printf("Paso 1\n");
                    BaseClock.start();
                    BaseClock.reset();
                    Step1();
                    break;

                case HOSTING_STEP2:
                    Computer.printf("Paso 2\n");                                // Respuesta SHUT OK
                    Step2();
                    break;

                case HOSTING_STEP3:
                    Computer.printf("Paso 3\n");
                    Step3();
                    break;

                case HOSTING_STEP4:
                    Computer.printf("Paso 4\n");
                    Step4();                                                    // Respuesta OK
                    break;

                case HOSTING_STEP5:
                    Computer.printf("Paso 5\n");
                    Step5();
                    break;

                case HOSTING_STEP6:
                    Computer.printf("Paso 6\n");
                    Step6();
                    break;

                case HOSTING_STEP7:
                    Computer.printf("Paso 7\n");
                    Step7();
                    break;

                case HOSTING_STEP8:
                    Computer.printf("Paso 8\n");
                    Step8();
                    break;

                case HOSTING_STEP9:
                    Computer.printf("Paso 9\n");
                    Step9();
                    break;

                case HOSTING_STEP10:
                    Computer.printf("Paso 10\n");
                    Step10();
                    break;

                case HOSTING_STEP11:
                    Computer.printf("Paso 11\n");
                    MasterCommand.Flush();
                    Step11();
                    BaseClock.stop();
                    break;

                case HOSTING_OFF:
                    Computer.printf("Paso salida\n");
                    PrintSerialRepeat("AT+HTTPTERM\r\n","OK",500,50);
                    break;
            }
        }
    }
}
// Proceso Usuario, lista de comandos que se deben enviar:
// 1.COMMAND_ON      ---> Encerder el modulo.
// 2.COMMAND_INIT    ---> Cargar configuracion del modulo.
// 3.COMMAND_GPRS    ---> Iniciar conexion GPRS.
// 4.COMMAND_DATA    ---> Enviar datos [Tiempo,Identificador,Espacio] y se espera confirmacion.
// 5.COMMAND_POST    ---> Realizar post HTTP.
// 6.COMMAND_ANSWER  ---> Recibir respuesta del servicio.
// 7.COMMAND_OFF     ---> Apagar el modulo.

// Proceso Hosting, lista de comando que se deben enviar:
// 1.HOSTING_STEP1   ---> Encerder el modulo.
// 2.HOSTING_STEP2   ---> Comandos CREG Y CIPSHUT.
// 3.HOSTING_STEP3   ---> Comandos CIPSTATUS Y CIPMUX.
// 4.HOSTING_STEP4   ---> Comando CGATT.
// 5.HOSTING_STEP5   ---> Comandos SAPBR GPRS y APN.
// 6.HOSTING_STEP6   ---> Comando SAPBR 1,1.
// 7.HOSTING_STEP7   ---> Comandos HTTPINIT y HTTPPARA.
// 8.HOSTING_STEP8   ---> Se envian los datos [Indentificador, Alarmas] y HTTPPARA JSON.
// 9.HOSTING_STEP9   ---> Comandos HTTPDATA y HTTPACTION.
// 10.HOSTING_STEP10 ---> Comando HTTPREAD y se espera respuesta.
// 11.HOSTING_STEP11 ---> Comandos HTTPTERM y se enviar respuesta, y se apaga modulo.
// 12.HOSTING_OFF    ---> Comando HTTPTERM en caso de choque con usuario.