#include "mbed.h"

//------------------------------------
// Hyperterminal configuration
// 9600 bauds, 8-bit data, no parity
//------------------------------------

RawSerial   Computer(SERIAL_TX, SERIAL_RX,9600);      // tx, rx
RawSerial   Gsm(PA_0,PA_1,19200);
bool Completo = false;
char Command;
int  Sim900_Counter=0;
char Sim900_Buffer[1000];
int  Computer_Counter=0;
char Computer_Buffer[1000];
unsigned long Inicio, Fin, Transcurrido;
Timer       BaseClock;

DigitalOut  EnableSIM900(PB_0);
DigitalOut  ResetSIM900(PA_10);
InterruptIn Button(USER_BUTTON);

void Interrupt_Sim900()
{
    if(Gsm.readable()) {
        Sim900_Buffer[Sim900_Counter]=Gsm.getc();
        Sim900_Counter++;
    }
}

void Interrupt_Computer()
{
    Computer_Buffer[Computer_Counter]=Computer.getc();
    if(Computer_Buffer[Computer_Counter]=='\n'){
        Completo=true;
    }
    Computer_Counter++;
}

void EncenderSIM900()
{
    Computer.printf("Computer\r\n");
    Sim900_Counter=0;
    if(Gsm.writeable()) {
        Gsm.printf("AT\r\n");
    }
    wait_ms(100);

    if(Sim900_Counter==0) {
        Sim900_Counter=0;
        EnableSIM900 = 1;
        wait_ms(600);
        EnableSIM900 = 0;
        wait_ms(1000);

        bool TimeOut=0;
        bool RightAnswer1=0;
        bool RightAnswer2=0;
        bool WrongAnswer1=0;
        bool WrongAnswer2=0;
        Inicio=BaseClock.read_ms();

        while(true) {               // Esta funcion detiene el programa y espera una respuesta
            Fin=BaseClock.read_ms();
            Transcurrido=Fin-Inicio;
            if(Sim900_Counter>5) {
                TimeOut=1;
                break;
            }
            if(Transcurrido>1000) {
                TimeOut=0;
                break;
            }
        }
        wait_ms(500);
        if(TimeOut) {
            for(int i=0; i<Sim900_Counter; i++) {
                Computer.putc(Sim900_Buffer[i]);
                if(Sim900_Buffer[i]=='F') {
                    RightAnswer1=1;
                }
                if(Sim900_Buffer[i]=='I') {
                    RightAnswer2=1;
                }
                if(Sim900_Buffer[i]=='O') {
                    WrongAnswer1=1;
                }
                if(Sim900_Buffer[i]=='W') {
                    WrongAnswer2=1;
                }
            }
            if(RightAnswer1 && RightAnswer2) {
                Computer.printf("OK-> Encendido correctamente\n");
                wait_ms(3500);
            } else {
                if(WrongAnswer1 && WrongAnswer2) {
                    Computer.printf("OK-> Apagado error\n");
                    wait_ms(4000);
                    Sim900_Counter=0;
                    EnableSIM900 = 1;
                    wait_ms(600);
                    EnableSIM900 = 0;
                    wait_ms(5000);
                }
            }
        }
    } else {
        for(int i=0; i<=Sim900_Counter; i++) {
            Computer.putc(Sim900_Buffer[i]);
        }
    }

}

void PrintSerialRepeat(char Answer[],uint32_t Espera,uint32_t Delay)//
{
    for(int i=0; i<Computer_Counter; i++) {
        if(Gsm.writeable()) {
            Gsm.putc(Computer_Buffer[i]);
        }
    }
    Sim900_Counter=0;
    bool TimeOut=0;
    bool RightAnswer1=0;
    bool RightAnswer2=0;
    Inicio=BaseClock.read_ms();

    while(true) {               // Esta funcion detiene el programa y espera una respuesta
        Fin=BaseClock.read_ms();
        Transcurrido=Fin-Inicio;
        if(Sim900_Counter>2) {
            TimeOut=1;
            break;
        }
        if(Transcurrido>Espera) {
            TimeOut=0;
            break;
        }
    }
    wait_ms(Delay);
    if(TimeOut) {
        for(int i=0; i<Sim900_Counter; i++) {
            Computer.putc(Sim900_Buffer[i]);
            if(Sim900_Buffer[i]==Answer[0]) {
                RightAnswer1=1;
            }
            if(Sim900_Buffer[i]==Answer[1]) {
                RightAnswer2=1;
            }
        }
        if(RightAnswer1 && RightAnswer2) {
            Computer.printf("OK-> Respuesta correcta\n");
            Computer_Counter=0;
        } else {
            Computer.printf("ERROR-> Respuesta incorrecta\n");
            wait_ms(2000);

            for(int i=0; i<Computer_Counter; i++) {
                if(Gsm.writeable()) {
                    Gsm.putc(Computer_Buffer[i]);
                }
            }
            Sim900_Counter=0;
            TimeOut=0;
            RightAnswer1=0;
            RightAnswer2=0;
            Inicio=BaseClock.read_ms();

            while(true) {               // Esta funcion detiene el programa y espera una respuesta
                Fin=BaseClock.read_ms();
                Transcurrido=Fin-Inicio;
                if(Sim900_Counter>0) {
                    TimeOut=1;
                    break;
                }
                if(Transcurrido>Espera) {
                    TimeOut=0;
                    break;
                }
            }
            wait_ms(Delay);
            if(TimeOut) {
                for(int i=0; i<Sim900_Counter; i++) {
                    Computer.putc(Sim900_Buffer[i]);
                    if(Sim900_Buffer[i]==Answer[0]) {
                        RightAnswer1=1;
                    }
                    if(Sim900_Buffer[i]==Answer[1]) {
                        RightAnswer2=1;
                    }
                }
                if(RightAnswer1 && RightAnswer2) {
                    Computer.printf("OK-> Respuesta correcta\n");
                    Computer_Counter=0;
                } else {
                    Computer.printf("ERROR-> Respuesta incorrecta\n");
                    Computer_Counter=0;
                }
            } else {
                Computer.printf("ERROR-> Sin respuesta\n");
                Computer_Counter=0;
            }
        }
    } else {
        Computer.printf("ERROR-> Sin respuesta\n");
        Computer_Counter=0;
    }
}

int main()
{
    Gsm.attach(&Interrupt_Sim900);
    Computer.attach(&Interrupt_Computer);
    Button.fall(&EncenderSIM900);
    BaseClock.start();
    Computer.printf("USB-TTL\n");
    ResetSIM900=0;
    while(1) {
        if(Completo){
            Completo=false;
            PrintSerialRepeat("ok",500,2000);
        }        
    }
}