#include "ThermalPrinter.h"
#include "mbed.h"
#include "stdio.h"

const char HORIZONTAL_TAB=9;
const char NEXT_POSITION=10;
const char ESC=27;
const char SPECIAL_CHARACTER=82;
const char SPANISH=11;
const char U_TILDE=126;
const char A_TILDE=64;
const char INICIAR=64;
const char TAMANO=33;
const char LETRA_12X24_DOBLE=49;
const char LETRA_16X16_DOBLE=34;
const char XON=17;//0x11
const char XOFF=19;//0x13
const char POWER_DOWN=18;
const char GS=29;
const char CUTTING=86;
const char PARTIAL=49;
const char FULL=48;

char ThermalPrinter_Buffer[255];
int ThermalPrinter_Counter=0;
int Tiquete=0;

PRINTER::PRINTER(PinName TX, PinName RX,PinName PAPER, PinName SELECT,PinName RESET,PinName POWER) : ThermalPrinter(TX,RX),_PAPER(PAPER),_SELECT(SELECT),_RESET(RESET),_POWER(POWER)
{
    _PAPER=0;          // AFT
    _SELECT=0;         // SLCTIN
    _RESET=0;          // INPRM
    _POWER=0;          // RELE
    ThermalPrinter.attach(this,&PRINTER::ThermalPrinterInterruption);
}


void PRINTER::ThermalPrinterInterruption()
{
    if(ThermalPrinter.readable()) {
        ThermalPrinter_Buffer[ThermalPrinter_Counter]=ThermalPrinter.getc();
        ThermalPrinter_Counter++;
    }
}

uint8_t PRINTER::Reset()
{
    ThermalPrinter_Counter=0;
    _RESET = 1;
    wait_ms(500);
    _RESET = 0;
    int Error=2;
    wait_ms(1300);
    int Counter = ThermalPrinter_Counter;
    
    while(Counter>0){
        Counter--;
        if(ThermalPrinter_Buffer[Counter]==XON) {
            Error=1;
        }
        if(ThermalPrinter_Buffer[Counter]==XOFF) {
            Error=0;
            break;
        }
    }
    return Error;
}

uint8_t PRINTER::Output(char Date[],char Hour_Start[],char Hour_Finish[],char Place[],char Time[],char Ticket[],char Money[])
{
    ThermalPrinter_Counter=0;
    int Counter;
    bool Error=1;
    
    if(ThermalPrinter.writeable()) {
        ThermalPrinter.putc(ESC);
        ThermalPrinter.putc(INICIAR);
        wait_ms(15);
    }
    
    Counter = ThermalPrinter_Counter;
    if(Counter>0){
        Counter--;
        if(ThermalPrinter_Buffer[Counter]==XON) {
            Error=1;
        }
        if(ThermalPrinter_Buffer[Counter]==XOFF) {
            Error=0;
            return Error;
        }
    }

    if(ThermalPrinter.writeable()) {
        ThermalPrinter.putc(ESC);
        ThermalPrinter.putc(TAMANO);
        ThermalPrinter.putc(LETRA_12X24_DOBLE);
        ThermalPrinter.printf("  Municipalidad");
        wait_ms(200);
    }
    
    Counter = ThermalPrinter_Counter;
    if(Counter>0){
        Counter--;
        if(ThermalPrinter_Buffer[Counter]==XON) {
            Error=1;
        }
        if(ThermalPrinter_Buffer[Counter]==XOFF) {
            Error=0;
            return Error;
        }
    }
    
    if(ThermalPrinter.writeable()) {
        ThermalPrinter.putc(NEXT_POSITION);
        ThermalPrinter.printf("  de Santa Ana");
        wait_ms(400);
    }
    
    Counter = ThermalPrinter_Counter;
    if(Counter>0){
        Counter--;
        if(ThermalPrinter_Buffer[Counter]==XON) {
            Error=1;
        }
        if(ThermalPrinter_Buffer[Counter]==XOFF) {
            Error=0;
            return Error;
        }
    }
    
    if(ThermalPrinter.writeable()) {
        ThermalPrinter.putc(NEXT_POSITION);
        ThermalPrinter.putc(NEXT_POSITION);        
        ThermalPrinter.printf("Setex Costa Rica");      
        wait_ms(200);
    }
    
    Counter = ThermalPrinter_Counter;
    if(Counter>0){
        Counter--;
        if(ThermalPrinter_Buffer[Counter]==XON) {
            Error=1;
        }
        if(ThermalPrinter_Buffer[Counter]==XOFF) {
            Error=0;
            return Error;
        }
    }

    if(ThermalPrinter.writeable()) {
        ThermalPrinter.putc(NEXT_POSITION);
        ThermalPrinter.printf("- - - - - - - -");
        ThermalPrinter.putc(NEXT_POSITION);
        wait_ms(200);
    }
    
    Counter = ThermalPrinter_Counter;
    if(Counter>0){
        Counter--;
        if(ThermalPrinter_Buffer[Counter]==XON) {
            Error=1;
        }
        if(ThermalPrinter_Buffer[Counter]==XOFF) {
            Error=0;
            return Error;
        }
    }

    if(ThermalPrinter.writeable()) {
        ThermalPrinter.putc(ESC);
        ThermalPrinter.putc(TAMANO);
        ThermalPrinter.putc(LETRA_16X16_DOBLE);
        ThermalPrinter.printf("Fin de estacionamiento:");
        ThermalPrinter.putc(NEXT_POSITION);
        wait_ms(100);
        ThermalPrinter.putc(HORIZONTAL_TAB);
        ThermalPrinter.putc(ESC);
        ThermalPrinter.putc(TAMANO);
        ThermalPrinter.putc(LETRA_12X24_DOBLE);
        ThermalPrinter.printf("   %s",Hour_Finish);
        ThermalPrinter.putc(NEXT_POSITION);
        wait_ms(200);
    }
    
    Counter = ThermalPrinter_Counter;
    if(Counter>0){
        Counter--;
        if(ThermalPrinter_Buffer[Counter]==XON) {
            Error=1;
        }
        if(ThermalPrinter_Buffer[Counter]==XOFF) {
            Error=0;
            return Error;
        }
    }

    if(ThermalPrinter.writeable()) {
        ThermalPrinter.putc(ESC);
        ThermalPrinter.putc(TAMANO);
        ThermalPrinter.putc(LETRA_16X16_DOBLE);

        ThermalPrinter.printf("N");
        ThermalPrinter.putc(ESC);
        ThermalPrinter.putc(SPECIAL_CHARACTER);
        ThermalPrinter.putc(SPANISH);
        ThermalPrinter.putc(U_TILDE);
        ThermalPrinter.printf("mero ticket:");
        ThermalPrinter.putc(NEXT_POSITION);
        wait_ms(50);
    }
    
    Counter = ThermalPrinter_Counter;
    if(Counter>0){
        Counter--;
        if(ThermalPrinter_Buffer[Counter]==XON) {
            Error=1;
        }
        if(ThermalPrinter_Buffer[Counter]==XOFF) {
            Error=0;
            return Error;
        }
    }

    if(ThermalPrinter.writeable()) {
        ThermalPrinter.printf("  ");
        ThermalPrinter.printf("%s",Ticket);
        ThermalPrinter.putc(NEXT_POSITION);
        Tiquete=Tiquete+1;
        wait_ms(150);
    }
    
    Counter = ThermalPrinter_Counter;
    if(Counter>0){
        Counter--;
        if(ThermalPrinter_Buffer[Counter]==XON) {
            Error=1;
        }
        if(ThermalPrinter_Buffer[Counter]==XOFF) {
            Error=0;
            return Error;
        }
    }

    if(ThermalPrinter.writeable()) {
        ThermalPrinter.printf("Espacio:");
        ThermalPrinter.putc(NEXT_POSITION);
        wait_ms(50);
    }
    
    Counter = ThermalPrinter_Counter;
    if(Counter>0){
        Counter--;
        if(ThermalPrinter_Buffer[Counter]==XON) {
            Error=1;
        }
        if(ThermalPrinter_Buffer[Counter]==XOFF) {
            Error=0;
            return Error;
        }
    }

    if(ThermalPrinter.writeable()) {
        ThermalPrinter.printf("  %s",Place);
        ThermalPrinter.putc(NEXT_POSITION);
        wait_ms(150);
    }
    
    Counter = ThermalPrinter_Counter;
    if(Counter>0){
        Counter--;
        if(ThermalPrinter_Buffer[Counter]==XON) {
            Error=1;
        }
        if(ThermalPrinter_Buffer[Counter]==XOFF) {
            Error=0;
            return Error;
        }
    }

    if(ThermalPrinter.writeable()) {
        ThermalPrinter.printf("Importe:");
        ThermalPrinter.putc(NEXT_POSITION);
        ThermalPrinter.printf("  %s",Money);
        ThermalPrinter.printf(" CRC");
        ThermalPrinter.putc(NEXT_POSITION);
        wait_ms(200);
    }
    
    Counter = ThermalPrinter_Counter;
    if(Counter>0){
        Counter--;
        if(ThermalPrinter_Buffer[Counter]==XON) {
            Error=1;
        }
        if(ThermalPrinter_Buffer[Counter]==XOFF) {
            Error=0;
            return Error;
        }
    }

    if(ThermalPrinter.writeable()) {
        ThermalPrinter.printf("Tiempo pagado:");
        ThermalPrinter.putc(NEXT_POSITION);
        ThermalPrinter.printf("  %s",Time);
        ThermalPrinter.putc(NEXT_POSITION);
        wait_ms(200);
    }
    
    Counter = ThermalPrinter_Counter;
    if(Counter>0){
        Counter--;
        if(ThermalPrinter_Buffer[Counter]==XON) {
            Error=1;
        }
        if(ThermalPrinter_Buffer[Counter]==XOFF) {
            Error=0;
            return Error;
        }
    }

    if(ThermalPrinter.writeable()) {
        ThermalPrinter.printf("Hora y fecha de pago:");
        wait_ms(200);
    }
    
    Counter = ThermalPrinter_Counter;
    if(Counter>0){
        Counter--;
        if(ThermalPrinter_Buffer[Counter]==XON) {
            Error=1;
        }
        if(ThermalPrinter_Buffer[Counter]==XOFF) {
            Error=0;
            return Error;
        }
    }

    if(ThermalPrinter.writeable()) {
        ThermalPrinter.putc(NEXT_POSITION);
        ThermalPrinter.printf("  %s",Hour_Start);
        ThermalPrinter.putc(HORIZONTAL_TAB);
        ThermalPrinter.printf("%s",Date);
        ThermalPrinter.putc(NEXT_POSITION);
        wait_ms(200);
    }
    
    Counter = ThermalPrinter_Counter;
    if(Counter>0){
        Counter--;
        if(ThermalPrinter_Buffer[Counter]==XON) {
            Error=1;
        }
        if(ThermalPrinter_Buffer[Counter]==XOFF) {
            Error=0;
            return Error;
        }
    }

    if(ThermalPrinter.writeable()) {
        ThermalPrinter.putc(ESC);
        ThermalPrinter.putc(TAMANO);
        ThermalPrinter.putc(LETRA_12X24_DOBLE);
        ThermalPrinter.printf("- - - - - - - -");
        ThermalPrinter.putc(NEXT_POSITION);
        ThermalPrinter.printf("Pague su parqueo");
        ThermalPrinter.putc(NEXT_POSITION);
        ThermalPrinter.printf("   con el APP");
        ThermalPrinter.putc(NEXT_POSITION);
        wait_ms(250);
    }
    
    Counter = ThermalPrinter_Counter;
    if(Counter>0){
        Counter--;
        if(ThermalPrinter_Buffer[Counter]==XON) {
            Error=1;
        }
        if(ThermalPrinter_Buffer[Counter]==XOFF) {
            Error=0;
            return Error;
        }
    }

    if(ThermalPrinter.writeable()) {
        ThermalPrinter.printf("    epark CR");
        ThermalPrinter.putc(NEXT_POSITION);
        wait_ms(200);
    }
    
    Counter = ThermalPrinter_Counter;
    if(Counter>0){
        Counter--;
        if(ThermalPrinter_Buffer[Counter]==XON) {
            Error=1;
        }
        if(ThermalPrinter_Buffer[Counter]==XOFF) {
            Error=0;
            return Error;
        }
    }
    
    
    return Error;
}

uint8_t PRINTER::Cutter(bool Type)
{
    ThermalPrinter_Counter=0;
        
    if(Type==1) {
        if(ThermalPrinter.writeable()) {
            ThermalPrinter.putc(GS);
            ThermalPrinter.putc(CUTTING);
            ThermalPrinter.putc(FULL);
            wait_ms(2000);
        }
    }
    if(Type==0) {
        if(ThermalPrinter.writeable()) {
            ThermalPrinter.putc(GS);
            ThermalPrinter.putc(CUTTING);
            ThermalPrinter.putc(PARTIAL);
            wait_ms(2000);
        }
    }
    
    int Counter = ThermalPrinter_Counter;
    bool Error=1;
    
    if(Counter>0){
        Counter--;
        if(ThermalPrinter_Buffer[Counter]==XON) {
            Error=1;
        }
        if(ThermalPrinter_Buffer[Counter]==XOFF) {
            Error=0;
        }
    }
    return Error;
};

uint8_t PRINTER::Power(bool Turn)
{ 
    ThermalPrinter_Counter=0;
    if (Turn==1) {
        _POWER=1;
    } else {
        _POWER=0;
    }
    wait_ms(1500);
    
    bool Error=1;
    int Counter = ThermalPrinter_Counter;
    
    while(Counter>0){
        Counter--;
        if(ThermalPrinter_Buffer[Counter]==XON) {
            Error=1;
        }
        if(ThermalPrinter_Buffer[Counter]==XOFF) {
            Error=0;
            break;
        }
    }
    return Error;
}

uint8_t PRINTER::Paper(uint32_t Duration)
{
    ThermalPrinter_Counter=0;
    _PAPER=1;
    wait_ms(Duration);
    _PAPER=0;
    wait_ms(500);
    
    bool Error=1;
    int Counter = ThermalPrinter_Counter;
    
    if(Counter>0){
        Counter--;
        if(ThermalPrinter_Buffer[Counter]==XON) {
            Error=1;
        }
        if(ThermalPrinter_Buffer[Counter]==XOFF) {
            Error=0;
        }
    }
    return Error;
};

uint8_t PRINTER::End()
{
    ThermalPrinter_Counter=0;
    if(ThermalPrinter.writeable()) {
        ThermalPrinter.putc(POWER_DOWN);
    }
    
    wait(1);
    bool Error=0;
    int Counter = ThermalPrinter_Counter;
    
    if(Counter>0){
        Counter--;
        if(ThermalPrinter_Buffer[Counter]==XON) {
            Error=0;
        }
        if(ThermalPrinter_Buffer[Counter]==XOFF) {
            Error=1;
        }
    }
    return Error;
};

uint8_t PRINTER::Ticket(bool Instruction)
{
    if (Instruction==0) {
        Tiquete=0;
        return 0;
    } else {
        return Tiquete;
    }
};

char PRINTER::Entrada()
{    
    if(ThermalPrinter_Counter>0){
        ThermalPrinter_Counter--;
        return ThermalPrinter_Buffer[ThermalPrinter_Counter];    
    } else {
        return 0x00;   
    }
};
