#include "mbed.h"
#include "ThermalPrinter.h"

char FechaRespuesta[11]="2018-10-04";
char HoraRespuesta[6]="16:35";
char NumeroRespuesta[6]="1:45";
char Place[5]="2222";
char Time[6]="01:30";
char Money[]= "360";
char Ticket[]="214561";
DigitalOut   MAX232(PC_8);

DigitalOut   Regulator5V(PA_1);

Serial Computer(USBTX, USBRX);      // tx, rx
DigitalIn mybutton(USER_BUTTON);

PRINTER      Impresora(PC_10,PC_11,PE_0,PB_10,PB_0,PC_2);
// CLASS PRINTER (TX,RX,PAPER,SELECT,RESET,POWER)
// Conector RS232C(ZHR-8)
//   _ _ _ _ _ _ _ _
//  ! ! ! ! ! ! ! ! !             1->RXD    2->TXD    3->DTR    4->GND
//   1 2 3 4 5 6 7 8              5->DST    6->SLC    7->RESET  8->PAPER
//
// Conector Power(PHR-2)
//   _ _ _ _ _ _
//  ! ! ! ! ! ! !             1->VCC Logic Supply    2->GND Logic
//   1 2 3 4 5 6            4,3->GND Head/Motor    5,6->VCC Head/Motor


int main()
{
    Computer.printf("\n--------------------------");
    Computer.printf("\n a--> Power");
    Computer.printf("\n b--> Reset");
    Computer.printf("\n c--> Output");
    Computer.printf("\n d--> End");
    Computer.printf("\n e--> Paper");
    Computer.printf("\n f--> Cut");
    Computer.printf("\n g--> Power off");
    Computer.printf("\n h--> Max232 toogle");
    Computer.printf("\n--------------------------");
    bool Respuesta=1;
    MAX232=1;
    while(1) {
        if (mybutton == 1) { // Button is pressed
            char Comando;
            Impresora.Power(1);
            wait(1);
            Comando=Impresora.Reset();
            Comando=Impresora.Paper(600);
            Comando=Impresora.Cutter(1);
            wait(1);
            Comando=Impresora.Output(FechaRespuesta,HoraRespuesta,NumeroRespuesta,Place,Time,Ticket,Money);
            Comando=Impresora.Paper(600);
            Comando=Impresora.Cutter(1);
            Comando=Impresora.End();
            wait(1);
            Impresora.Power(0);
            
        }
        if (Computer.readable()) {
            char Comando=Computer.getc();
            
            if(Comando=='a') {
                Respuesta=Impresora.Power(1);
                Regulator5V=1;
            }
            if(Comando=='b') {
                Respuesta=Impresora.Reset();
            }
            if(Comando=='c') {
                Respuesta=Impresora.Output(FechaRespuesta,HoraRespuesta,NumeroRespuesta,Place,Time,Ticket,Money);
            }
            if(Comando=='d') {
                Respuesta=Impresora.End();
            }
            if(Comando=='e') {
                Respuesta=Impresora.Paper(600);
            }
            if(Comando=='f') {
                Respuesta=Impresora.Cutter(1);
            }
            if(Comando=='g') {
                Respuesta=Impresora.Power(0);
                Regulator5V=0;
            }
            if(Comando=='h') {
                MAX232=!MAX232;
            }
            char InByte=' ';
            Computer.printf("Respuesta: %i\n",Respuesta);
            while(true){
                InByte=Impresora.Entrada();
                if(InByte==0x00){
                    break;   
                }
                Computer.printf("0x%2X-",InByte);
            }

            Computer.printf("\n--------------------------");
            Computer.printf("\n a--> Power");
            Computer.printf("\n b--> Reset");
            Computer.printf("\n c--> Output");
            Computer.printf("\n d--> end");
            Computer.printf("\n e--> Paper");
            Computer.printf("\n f--> Cut");
            Computer.printf("\n g--> Power off");
            Computer.printf("\n--------------------------");
        }
    }
}
