#include "mbed.h"
#include "Slave.h"

#define     COMMAND_ON          0X70
#define     COMMAND_INIT        0X71
#define     COMMAND_GPRS        0X72
#define     COMMAND_DATA        0X73
#define     COMMAND_POST        0X74
#define     COMMAND_ANSWER      0X75
#define     COMMAND_SIGNAL      0X76
#define     COMMAND_CONNECT     0X77
#define     COMMAND_OFF         0X78
#define     HOSTING_STEP1       0x79
#define     HOSTING_STEP2       0x7A
#define     HOSTING_STEP3       0x7B
#define     HOSTING_STEP4       0x7C
#define     HOSTING_STEP5       0x7D
#define     HOSTING_STEP6       0x7E
#define     HOSTING_STEP7       0x7F
#define     HOSTING_STEP8       0x80
#define     HOSTING_STEP9       0x81
#define     HOSTING_STEP10      0x82
#define     HOSTING_STEP11      0x83
#define     HOSTING_OFF         0x84
#define     NEXT_STEP           0x85
#define     NEXT_SLEEP          0x86
#define     NO_DATA             0x87

DigitalOut myled(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalIn myButton(USER_BUTTON);
SLAVE   Slave(PD_5,PD_6,PD_7);
Serial Computer(SERIAL_TX, SERIAL_RX,9600);
Timer BaseClock;
unsigned long Inicio, Fin, Transcurrido;
char Commando;

// Proceso Usuario, lista de comandos que se deben enviar:
// 1.COMMAND_ON      ---> Encerder el modulo.
// 2.COMMAND_INIT    ---> Cargar configuracion del modulo.
// 3.COMMAND_GPRS    ---> Iniciar conexion GPRS.
// 4.COMMAND_DATA    ---> Enviar datos [Tiempo,Identificador,Espacio] y se espera confirmacion.
// 5.COMMAND_POST    ---> Realizar post HTTP.
// 6.COMMAND_ANSWER  ---> Recibir respuesta del servicio.
// 7.COMMAND_OFF     ---> Apagar el modulo.

int main()
{
    BaseClock.start();
    while(1) {
        if(myButton==1) {
            Computer.printf("Enviar comandos\n");
            Slave.Command(COMMAND_ON);
            Computer.printf("ON\n");
            wait(3);
            Slave.Command(COMMAND_INIT);
            Computer.printf("INIT\n");
            wait(3);
            Slave.Command(COMMAND_GPRS);
            Computer.printf("GPRS\n");
            wait(7);
            Inicio=BaseClock.read_ms();
            while(true) {
                if(Slave.Answer()) {
                    Computer.putc('A');
                    break;
                }
                Fin=BaseClock.read_ms();
                Transcurrido=Fin-Inicio;
                if(Transcurrido>20000) {
                    Computer.putc('E');
                    break;
                }

            }
            Slave.Command(COMMAND_DATA);
            Slave.Send_User("1067","San Jose",120,"4321","5303105315252296=2108");
            Computer.printf("DATA\n");
            wait(3);
            Inicio=BaseClock.read_ms();
            while(true) {
                if(Slave.Answer()) {
                    Computer.putc('A');
                    break;
                }
                Fin=BaseClock.read_ms();
                Transcurrido=Fin-Inicio;
                if(Transcurrido>20000) {
                    Computer.putc('E');
                    break;
                }
            }
            Computer.printf("Post\n");
            Slave.Command(COMMAND_POST);
            wait(3);
            Computer.printf("Respuesta\n");
            Slave.Command(COMMAND_ANSWER);
            wait(3);

            Inicio=BaseClock.read_ms();
            while(true) {
                if(Slave.Available()) {
                    wait_ms(200);
                    break;
                }
                Fin=BaseClock.read_ms();
                Transcurrido=Fin-Inicio;
                if(Transcurrido>20000) {
                    Computer.putc('E');
                    break;
                }
            }

            Inicio=BaseClock.read_ms();
            while(true) {
                Commando=Slave.Recibe();
                if(Commando==NO_DATA) {
                    break;
                } else {
                    Computer.putc(Commando);
                }
                Fin=BaseClock.read_ms();
                Transcurrido=Fin-Inicio;
                if(Transcurrido>20000) {
                    Computer.putc('E');
                    break;
                }
            }
            Computer.printf("\nOFF\n");
            Slave.Command(COMMAND_OFF);
            wait(7);
        }
    }
}