#include "mbed.h"

#define     COMMAND_ON          0X70
#define     COMMAND_INIT        0X71
#define     COMMAND_GPRS        0X72
#define     COMMAND_DATA        0X73
#define     COMMAND_POST        0X74
#define     COMMAND_ANSWER      0X75
#define     COMMAND_SIGNAL      0X76
#define     COMMAND_CONNECT     0X77
#define     COMMAND_OFF         0X78
#define     HOSTING_STEP1       0x79
#define     HOSTING_STEP2       0x7A
#define     HOSTING_STEP3       0x7B
#define     HOSTING_STEP4       0x7C
#define     HOSTING_STEP5       0x7D
#define     HOSTING_STEP6       0x7E
#define     HOSTING_STEP7       0x7F
#define     HOSTING_STEP8       0x80
#define     HOSTING_STEP9       0x81
#define     HOSTING_STEP10      0x82
#define     HOSTING_STEP11      0x83
#define     HOSTING_OFF         0x84
#define     NEXT_STEP           0x85
#define     NEXT_SLEEP          0x86
#define     NO_DATA             0x87

RawSerial Computer(SERIAL_TX, SERIAL_RX,9600);      // tx, rx
RawSerial Master(PC_1, PC_0,9600);
RawSerial myGsm(PA_0,PA_1,19200);
DigitalOut EnableSIM900(PB_0);
DigitalOut ResetSIM900(PA_10);
InterruptIn ButtonPin(USER_BUTTON);
InterruptIn MasterPin(PC_3);
Timer BaseClock;

bool Int_Button=0;
bool Int_Master=0;

char Command;
char Sim900_Buffer[255];
int  Sim900_Counter=0;
char Master_Buffer[255];
int  Master_Counter=0;
int  CommandRead=0;
unsigned long Inicio, Fin, Transcurrido;

char Data[]="{\"municipio\":\"San Jose\",\"id\":1068,\"place\":\"0000\",\"time\":000,\"t2\":\"%5303105315252296=2108?\"}\r\n";
char HostingData[]="{\"municipio\":\"San Jose\",\"id\":1068, \"alerts\":\"AAAAAA\"}\r\n";
char HostingAnswer[]="OK+000+00:00";

void Interrupt_Sim900()
{
    if(myGsm.readable()) {
        Sim900_Buffer[Sim900_Counter]=myGsm.getc();
        Sim900_Counter++;
    }
}

void Interrupt_Master()
{
    if(Master.readable()) {
        Master_Buffer[Master_Counter]=Master.getc();
        Master_Counter++;
    }
}

void PrintSerialData(char Command[],char Answer[],uint32_t Espera,uint32_t Delay)//
{
    if(myGsm.writeable()) {
        myGsm.printf("%s",Command);
    }
    Sim900_Counter=0;
    bool TimeOut=0;
    bool RightAnswer1=0;
    bool RightAnswer2=0;
    Inicio=BaseClock.read_ms();

    while(true) {               // Esta funcion detiene el programa y espera una respuesta
        Fin=BaseClock.read_ms();
        Transcurrido=Fin-Inicio;
        if(Sim900_Counter>0) {
            TimeOut=1;
            break;
        }
        if(Transcurrido>Espera) {
            TimeOut=0;
            break;
        }
    }
    wait_ms(Delay);
    if(TimeOut) {
        for(int i=0; i<Sim900_Counter; i++) {
            Computer.putc(Sim900_Buffer[i]);
            if(Sim900_Buffer[i]==Answer[0]) {
                RightAnswer1=1;
            }
            if(Sim900_Buffer[i]==Answer[1]) {
                RightAnswer2=1;
            }
        }
        if(RightAnswer1 && RightAnswer2) {
            Computer.printf("OK-> Respuesta correcta\n");
        } else {
            Computer.printf("ERROR-> Respuesta incorrecta\n");
            wait_ms(2000);

            myGsm.printf("%s",Command);
            Sim900_Counter=0;
            TimeOut=0;
            RightAnswer1=0;
            RightAnswer2=0;
            Inicio=BaseClock.read_ms();

            while(true) {               // Esta funcion detiene el programa y espera una respuesta
                Fin=BaseClock.read_ms();
                Transcurrido=Fin-Inicio;
                if(Sim900_Counter>0) {
                    TimeOut=1;
                    break;
                }
                if(Transcurrido>Espera) {
                    TimeOut=0;
                    break;
                }
            }
            wait_ms(Delay);
            if(TimeOut) {
                for(int i=0; i<Sim900_Counter; i++) {
                    Computer.putc(Sim900_Buffer[i]);
                    if(Sim900_Buffer[i]==Answer[0]) {
                        RightAnswer1=1;
                    }
                    if(Sim900_Buffer[i]==Answer[1]) {
                        RightAnswer2=1;
                    }
                }
                if(RightAnswer1 && RightAnswer2) {
                    Computer.printf("OK-> Respuesta correcta\n");
                } else {
                    Computer.printf("ERROR-> Respuesta incorrecta\n");
                }
            } else {
                Computer.printf("ERROR-> Sin respuesta\n");
            }
        }
    } else {
        Computer.printf("ERROR-> Sin respuesta\n");
    }
}

void EncenderSIM900()
{
    Sim900_Counter=0;
    if(myGsm.writeable()) {
        myGsm.printf("AT\r\n");
    }
    wait_ms(100);

    if(Sim900_Counter==0) {
        Sim900_Counter=0;
        EnableSIM900 = 1;
        wait_ms(600);
        EnableSIM900 = 0;
        wait_ms(1000);

        bool TimeOut=0;
        bool RightAnswer1=0;
        bool RightAnswer2=0;
        bool WrongAnswer1=0;
        bool WrongAnswer2=0;
        Inicio=BaseClock.read_ms();

        while(true) {               // Esta funcion detiene el programa y espera una respuesta
            Fin=BaseClock.read_ms();
            Transcurrido=Fin-Inicio;
            if(Sim900_Counter>0) {
                TimeOut=1;
                break;
            }
            if(Transcurrido>1000) {
                TimeOut=0;
                break;
            }
        }
        wait_ms(500);
        if(TimeOut) {
            for(int i=0; i<Sim900_Counter; i++) {
                Computer.putc(Sim900_Buffer[i]);
                if(Sim900_Buffer[i]=='F') {
                    RightAnswer1=1;
                }
                if(Sim900_Buffer[i]=='I') {
                    RightAnswer2=1;
                }
                if(Sim900_Buffer[i]=='O') {
                    WrongAnswer1=1;
                }
                if(Sim900_Buffer[i]=='W') {
                    WrongAnswer2=1;
                }
            }
            if(RightAnswer1 && RightAnswer2) {
                Computer.printf("OK-> Encendido correctamente\n");
                wait_ms(3500);
            } else {
                if(WrongAnswer1 && WrongAnswer2) {
                    Computer.printf("OK-> Apagado error\n");
                    wait_ms(4000);
                    Sim900_Counter=0;
                    EnableSIM900 = 1;
                    wait_ms(600);
                    EnableSIM900 = 0;
                    wait_ms(5000);
                }
            }
        }
    } else {
        for(int i=0; i<=Sim900_Counter; i++) {
            Computer.putc(Sim900_Buffer[i]);
        }
    }
    
}

void IniciarSIM900()
{
    //PrintSerialData("AT+CPIN?\r\n","OK",500,75);                                        // Respuesta +CPIN: READY\n\nOK
    //PrintSerialData("AT+CSQ\r\n","OK",500,100);                                         // Respuesta +Señal Disponible   OK
    PrintSerialData("AT+CREG=1\r\n","OK",500,250);                                      // Peticion de conexion GPRS   OK
    //PrintSerialData("AT+CIPSHUT\r\n","OK",500,150);                                     // Respuesta SHUT OK
    //PrintSerialData("AT+CIPSTATUS\r\n","OK",500,100);                                   // Respuesta OK  STATE: IP INITIAL
    //PrintSerialData("AT+CIPMUX=0\r\n","OK",500,100);                                    // Respuesta OK
    //PrintSerialData("AT+CSTT=\"Setex\",\"parquimetro\",\"hola\"\r\n","OK",500,1000);  // AT+CSTT= "Setex", "Parquimetro1", "hola"
    //PrintSerialData("AT+CIICR\r\n","OK",2000,100);                                    // Respuesta OK
    //PrintSerialData("AT+CIFSR\r\n",".1",2000,400);                                    // Respuesta 10.5.240.34
    wait(4);
}

void ConexionGPRS()
{
    PrintSerialData("AT+CGATT=1\r\n","OK",2000,1000);                                    // Peticion de conexion GPRS   OK
    PrintSerialData("AT+SAPBR=3,1,\"CONTYPE\",\"GPRS\"\r\n","OK",500,100);             // AT+SAPBR=3,1,"CONTYPE","GPRS" Respuesta OK
    PrintSerialData("AT+SAPBR=3,1,\"APN\",\"\"\r\n","OK",500,100);                     // Respuesta OK, AT+SAPBR=3,1,"APN",""
    PrintSerialData("AT+SAPBR=1,1\r\n","OK",500,1000);                                  // Respuesta OK
    //PrintSerialData("AT+SAPBR=2,1\r\n","1.",500,1000);                               // Respuesta +SAPBR: 1,1,"10.7.114.2"
}

void ApagarSIM900()
{
    PrintSerialData("AT+CPOWD=1\r\n","WD",500,500);
    wait_ms(1000);
    
    Sim900_Counter=0;
    if(myGsm.writeable()) {
        myGsm.printf("AT\r\n");
    }
    wait_ms(100);
    
    if(Sim900_Counter>0){
        EnableSIM900 = 1;
        wait_ms(600);
        EnableSIM900 = 0;
    }       
}

void PostHTTP()
{
    PrintSerialData("AT+HTTPINIT\r\n","OK",500,50);                                     // Iniciar servicio HTTP, Respuesta OK
    PrintSerialData("AT+HTTPPARA=\"URL\",\"http://34.211.174.1:8080/AIGRest/AIGService/alertPQ\"\r\n","OK",1500,140);   // AT+HTTPPARA="URL","http://34.211.174.1:8080/AIGRest/AIGService/parkPQ"
    PrintSerialData("AT+HTTPPARA=\"CONTENT\",\"application/json\"\r\n","OK",500,75);    // AT+HTTPPARA="CONTENT","application/json"

    char Len[23];
    sprintf(Len,"AT+HTTPDATA=%i,10000\r\n",(strlen(HostingData)));
    if(myGsm.writeable()) {
        myGsm.printf("%s",Len);
    }                                                 // Envio de parametros de la informacion, Respuesta DOWNLOAD OK
    wait_ms(200);
    if(Master.writeable()) {
        myGsm.printf("%s",HostingData);
    }                                             // Envio de informacion al web servicio                                            // Envio de informacion al web servicio
    wait_ms(500);
    for(int i=0; i<=Sim900_Counter; i++) {
        Computer.putc(Sim900_Buffer[i]);
    }
    wait_ms(500);
    PrintSerialData("AT+HTTPACTION=1\r\n","OK",8000,1800);                              // Respuesta OK +HTTPACTION:1,200,7
}


void RespuestaHTTP()
{
    PrintSerialData("AT+HTTPREAD=0,9000\r\n","OK",500,250);
    Sim900_Counter=0;
    Computer.printf("Esperando respuesta\n");
    Inicio=BaseClock.read_ms();
    while(true) {               // Esta funcion detiene el programa y espera una respuesta
        Fin=BaseClock.read_ms();
        Transcurrido=Fin-Inicio;
        if(Sim900_Counter>0) {
            break;
        }
        if(Transcurrido>40000) {
            break;
        }
    }
    wait_ms(250);                                 // +HTTPREAD:7 OKAlpha, OK+310325+10:29+2018-04-10
    bool RightAnswer1=0;
    bool RightAnswer2=0;
    bool RightAnswer3=0;

    PrintSerialData("AT+HTTPREAD=0,9000\r\n","OK",500,250);
    for(int i=0; i<Sim900_Counter; i++) {
        Computer.printf("%c",Sim900_Buffer[i]);
        if(Sim900_Buffer[i]=='O') {
            RightAnswer1=1;
        }
        if(Sim900_Buffer[i]=='K') {
            RightAnswer2=1;
        }
        if(Sim900_Buffer[i]=='-') {
            RightAnswer3=1;
        }
    }
    if(RightAnswer3&&RightAnswer2&&RightAnswer1) {
        Computer.printf("Aceptada\n");
        if(Master.writeable()) {
            for(int i=37; i<=(Sim900_Counter-6); i++) {
                Master.putc(Sim900_Buffer[i]);
            }
            Master.putc('A');
        }
    } else {
        Computer.printf("Rechazada\n");
        if(Master.writeable()) {
            Master.putc('R');
        }
    }
    PrintSerialData("AT+HTTPTERM\r\n","OK",500,50);
}

void Read_Usuario()
{
    wait_ms(100);
    // Espacio
    Data[43]=Master_Buffer[CommandRead+9];
    Data[44]=Master_Buffer[CommandRead+10];
    Data[45]=Master_Buffer[CommandRead+11];
    Data[46]=Master_Buffer[CommandRead+12];
    // Identificador
    Data[29]=Master_Buffer[CommandRead+14];
    Data[30]=Master_Buffer[CommandRead+15];
    Data[31]=Master_Buffer[CommandRead+16];
    Data[32]=Master_Buffer[CommandRead+17];
    // Tiempo
    Data[56]=Master_Buffer[CommandRead+18];
    Data[57]=Master_Buffer[CommandRead+19];
    Data[58]=Master_Buffer[CommandRead+20];
    // Track2
    Data[67]=Master_Buffer[CommandRead+21];
    Data[68]=Master_Buffer[CommandRead+22];
    Data[69]=Master_Buffer[CommandRead+23];
    Data[70]=Master_Buffer[CommandRead+24];
    Data[71]=Master_Buffer[CommandRead+25];
    Data[72]=Master_Buffer[CommandRead+26];
    Data[73]=Master_Buffer[CommandRead+27];
    Data[74]=Master_Buffer[CommandRead+28];
    Data[75]=Master_Buffer[CommandRead+29];
    Data[76]=Master_Buffer[CommandRead+30];
    Data[77]=Master_Buffer[CommandRead+31];
    Data[78]=Master_Buffer[CommandRead+32];
    Data[79]=Master_Buffer[CommandRead+33];
    Data[80]=Master_Buffer[CommandRead+34];
    Data[81]=Master_Buffer[CommandRead+35];
    Data[82]=Master_Buffer[CommandRead+36];
    Data[83]=Master_Buffer[CommandRead+37];
    Data[84]=Master_Buffer[CommandRead+38];
    Data[85]=Master_Buffer[CommandRead+39];
    Data[86]=Master_Buffer[CommandRead+40];
    Data[87]=Master_Buffer[CommandRead+41];
    if(Master.writeable()) {
        Master.putc(NEXT_STEP);
    }
}

void ConexionSIM900()
{
    Sim900_Counter=0;
    EnableSIM900 = 1;
    wait_ms(600);
    EnableSIM900 = 0;
    char ConectionEnable;
    Inicio=BaseClock.read_ms();
    while (true) {
        Fin=BaseClock.read_ms();
        Transcurrido=Fin-Inicio;
        if(Sim900_Counter>0) {
            Computer.printf("Conectado\n");
            ConectionEnable='A';
            break;
        }
        if(Transcurrido>5000) {
            Computer.printf("Desconectado\n");
            ConectionEnable='E';
            break;
        }
    }
    if(Master.writeable()) {
        Master.putc(ConectionEnable);
    }
    wait(5);
    ApagarSIM900();
}

void CoberturaSIM900()
{
    EnableSIM900 = 1;
    wait_ms(600);
    EnableSIM900 = 0;
    wait_ms(6000);
    Sim900_Counter=0;

    if(myGsm.writeable()) {
        myGsm.printf("AT+CSQ\r\n");
    }

    Inicio=BaseClock.read_ms();
    while (true) {
        Fin=BaseClock.read_ms();
        Transcurrido=Fin-Inicio;
        if(Sim900_Counter>0) {
            wait_ms(75);
            break;
        }
        if(Transcurrido>1000) {
            break;
        }
    }
    if(Sim900_Counter>0) {
        for(int i=0; i<Sim900_Counter; i++) {
            if(((uint8_t)Sim900_Buffer[i]>=0x30)&&((uint8_t)Sim900_Buffer[i]<0x3A)) {
                if(Master.writeable()) {
                    Master.putc(Sim900_Buffer[i]);
                }
            }
            Computer.putc(Sim900_Buffer[i]);
        }
        if(Master.writeable()) {
            Master.putc('A');
        }
    } else {
        if(Master.writeable()) {
            Master.putc('E');
        }
    }
    ApagarSIM900();
    wait(3900);
}
void Step1()
{
    EncenderSIM900();
    if(Master.writeable()) {
        Master.putc(NEXT_STEP);
    }
}

void Step2()
{
    PrintSerialData("AT+CREG=1\r\n","OK",500,250);                                      // Respuesta OK
    PrintSerialData("AT+CIPSHUT\r\n","OK",500,150);
    if(Master.writeable()) {
        Master.putc(NEXT_STEP);
    }
}

void Step3()
{
    PrintSerialData("AT+CIPSTATUS\r\n","OK",500,100);                                   // Respuesta OK  STATE: IP INITIAL
    PrintSerialData("AT+CIPMUX=0\r\n","OK",500,100);                                    // Respuesta OK
    if(Master.writeable()) {
        Master.putc(NEXT_STEP);
    }
}

void Step4()
{
    wait(5);
    PrintSerialData("AT+CGATT=1\r\n","OK",2000,2000);
    if(Master.writeable()) {
        Master.putc(NEXT_STEP);
    }
}

void Step5()
{
    PrintSerialData("AT+SAPBR=3,1,\"CONTYPE\",\"GPRS\"\r\n","OK",500,100);              // Respuesta OK
    PrintSerialData("AT+SAPBR=3,1,\"APN\",\"\"\r\n","OK",500,100);                      // Respuesta OK, AT+SAPBR=3,1,"APN",""
    if(Master.writeable()) {
        Master.putc(NEXT_STEP);
    }
}
void Step6()
{
    wait(2);
    PrintSerialData("AT+SAPBR=1,1\r\n","OK",500,1000);                                  // Respuesta OK
    if(Master.writeable()) {
        Master.putc(NEXT_STEP);
    }
}

void Step7()
{
    PrintSerialData("AT+HTTPINIT\r\n","OK",500,50);                                     // Iniciar servicio HTTP, Respuesta OK
    PrintSerialData("AT+HTTPPARA=\"URL\",\"http://34.211.174.1:8080/AIGRest/AIGService/alertPQ\"\r\n","OK",1500,140);   // AT+HTTPPARA="URL","http://34.211.174.1:8080/AIGRest/AIGService/parkPQ"
    if(Master.writeable()) {
        Master.putc(NEXT_STEP);
    }
}

void Step8()
{
    Computer.printf("%s\n",HostingData);
    wait_ms(100);
    // Alarmas
    HostingData[45]=Master_Buffer[CommandRead+9];
    HostingData[46]=Master_Buffer[CommandRead+10];
    HostingData[47]=Master_Buffer[CommandRead+11];
    HostingData[48]=Master_Buffer[CommandRead+12];
    HostingData[49]=Master_Buffer[CommandRead+13];
    HostingData[50]=Master_Buffer[CommandRead+14];
    // Identificador
    HostingData[29]=Master_Buffer[CommandRead+15];
    HostingData[30]=Master_Buffer[CommandRead+16];
    HostingData[31]=Master_Buffer[CommandRead+17];
    HostingData[32]=Master_Buffer[CommandRead+18];
    Computer.printf("%s\n",HostingData);
    PrintSerialData("AT+HTTPPARA=\"CONTENT\",\"application/json\"\r\n","OK",500,75);    // AT+HTTPPARA="CONTENT","application/json"
    if(Master.writeable()) {
        Master.putc(NEXT_STEP);
    }
}

void Step9()
{
    char Len[23];
    sprintf(Len,"AT+HTTPDATA=%i,10000\r\n",(strlen(HostingData)));
    if(myGsm.writeable()) {
        myGsm.printf("%s",Len);
    }                                                 // Envio de parametros de la informacion, Respuesta DOWNLOAD OK
    wait_ms(200);
    if(Master.writeable()) {
        myGsm.printf("%s",HostingData);
    }                                             // Envio de informacion al web servicio
    wait_ms(200);
    for(int i=0; i<=Sim900_Counter; i++) {
        Computer.putc(Sim900_Buffer[i]);
    }
    PrintSerialData("AT+HTTPACTION=1\r\n","OK",8000,1800);
    if(Master.writeable()) {
        Master.putc(NEXT_STEP);
    }
}

void Step10()
{
    PrintSerialData("AT+HTTPREAD=0,9000\r\n","OK",500,50);
    Sim900_Counter=0;
    Computer.printf("Esperando respuesta\n");
    Inicio=BaseClock.read_ms();
    while(true) {               // Esta funcion detiene el programa y espera una respuesta
        Fin=BaseClock.read_ms();
        Transcurrido=Fin-Inicio;
        if(Sim900_Counter>0) {
            break;
        }
        if(Transcurrido>4000) {
            break;
        }
    }
    wait_ms(250);                                 // +HTTPREAD:7 OKAlpha, OK+310325+10:29+2018-04-10
    bool RightAnswer1=0;
    bool RightAnswer2=0;
    bool RightAnswer3=0;
    Sim900_Counter=0;

    PrintSerialData("AT+HTTPREAD=0,9000\r\n","OK",500,50);

    for(int i=0; i<Sim900_Counter; i++) {
        Computer.printf("%c",Sim900_Buffer[i]);
        if(Sim900_Buffer[i]=='O') {
            RightAnswer1=1;
        }
        if(Sim900_Buffer[i]=='K') {
            RightAnswer2=1;
        }
        if(Sim900_Buffer[i]=='+') {
            RightAnswer3=1;
        }
    }
    if(RightAnswer3&&RightAnswer2&&RightAnswer1) {
        HostingAnswer[0]=Sim900_Buffer[36];
        HostingAnswer[1]=Sim900_Buffer[37];
        HostingAnswer[2]=Sim900_Buffer[38];
        HostingAnswer[3]=Sim900_Buffer[39];
        HostingAnswer[4]=Sim900_Buffer[40];
        HostingAnswer[5]=Sim900_Buffer[41];
        
        HostingAnswer[0]=Sim900_Buffer[42];
        HostingAnswer[1]=Sim900_Buffer[43];
        HostingAnswer[2]=Sim900_Buffer[44];
        HostingAnswer[3]=Sim900_Buffer[45];
        HostingAnswer[4]=Sim900_Buffer[46];
        HostingAnswer[5]=Sim900_Buffer[47];
        Computer.printf("Aceptada\n");
        Computer.printf("-%s-\n",HostingAnswer);
    } else {
        Computer.printf("Rechazada\n");
    }
    if(Master.writeable()) {
        Master.putc(NEXT_STEP);
    }
}

void Step11()
{
    if(Master.writeable()) {
        Master.printf("%s",HostingAnswer);
    }
    PrintSerialData("AT+HTTPTERM\r\n","OK",500,50);
    ApagarSIM900();
    if(Master.writeable()) {
        Master.putc(NEXT_STEP);
    }
    HostingAnswer[0]='0';
    HostingAnswer[1]='0';
    HostingAnswer[2]='0';
    HostingAnswer[3]='0';
    HostingAnswer[4]='0';
    HostingAnswer[5]='0';
    wait_ms(3900);
}


void FinalizarComunicacion()
{
    PrintSerialData("AT+SAPBR=0,1\r\n","OK",500,50);
}

void Button_Interruption(){
    Int_Button=1;
}

void Master_Interruption(){
    Int_Master=1;
}

int main()
{
    ButtonPin.rise(&Button_Interruption);
    MasterPin.rise(&Master_Interruption);
    myGsm.attach(&Interrupt_Sim900);
    //Master.attach(&Interrupt_Master);
    BaseClock.start();
    Computer.printf("Sim900 comandos\n");
    ResetSIM900=0;
    //ApagarSIM900();
    //BaseClock.stop();
    
    while(1) {
        BaseClock.stop();
        Computer.printf("Sleep\n");
        ResetSIM900=0;
        sleep();
        Computer.printf("Awake\n");
        BaseClock.start();
        BaseClock.reset();
        EncenderSIM900();
        wait(3);
        IniciarSIM900();
        ConexionGPRS();
        PostHTTP();
        RespuestaHTTP();
        FinalizarComunicacion();
        wait(1);
    }
}
// Proceso Usuario, lista de comandos que se deben enviar:
// 1.COMMAND_ON      ---> Encerder el modulo.
// 2.COMMAND_INIT    ---> Cargar configuracion del modulo.
// 3.COMMAND_GPRS    ---> Iniciar conexion GPRS.
// 4.COMMAND_DATA    ---> Enviar datos [Tiempo,Identificador,Espacio] y se espera confirmacion.
// 5.COMMAND_POST    ---> Realizar post HTTP.
// 6.COMMAND_ANSWER  ---> Recibir respuesta del servicio.
// 7.COMMAND_OFF     ---> Apagar el modulo.

// Proceso Hosting, lista de comando que se deben enviar:
// 1.HOSTING_STEP1   ---> Encerder el modulo.
// 2.HOSTING_STEP2   ---> Comandos CREG Y CIPSHUT.
// 3.HOSTING_STEP3   ---> Comandos CIPSTATUS Y CIPMUX.
// 4.HOSTING_STEP4   ---> Comando CGATT.
// 5.HOSTING_STEP5   ---> Comandos SAPBR GPRS y APN.
// 6.HOSTING_STEP6   ---> Comando SAPBR 1,1.
// 7.HOSTING_STEP7   ---> Comandos HTTPINIT y HTTPPARA.
// 8.HOSTING_STEP8   ---> Se envian los datos [Indentificador, Alarmas] y HTTPPARA JSON.
// 9.HOSTING_STEP9   ---> Comandos HTTPDATA y HTTPACTION.
// 10.HOSTING_STEP10 ---> Comando HTTPREAD y se espera respuesta.
// 11.HOSTING_STEP11 ---> Comandos HTTPTERM y se enviar respuesta, y se apaga modulo.
// 12.HOSTING_OFF    ---> Comando HTTPTERM en caso de choque con usuario.
