#include "Slave.h"
#include "mbed.h"
#include "stdio.h"

#define     NEXT_STEP           0x85
#define     NEXT_SLEEP          0x86
#define     NO_DATA             0x87


char Slave_Buffer[255];
int  Slave_Counter=0;

SLAVE::SLAVE(PinName TX, PinName RX,PinName AWAKE):Uart(TX,RX),_AWAKE(AWAKE)
{
    _AWAKE=0;
    Uart.attach(this,&SLAVE::UartInterruption);
}

bool SLAVE::Available()
{
    if(Slave_Counter>0) {
        return 1;
    } else {
        return 0;
    }
}


void SLAVE::Command(uint8_t _Command)
{
    if(Uart.writeable()) {
        Uart.putc(_Command);
    } else {
        wait_ms(500);
        if(Uart.writeable()) {
            Uart.putc(_Command);
        }
    }
}

void SLAVE::Send_Hosting(char Parquimetro[],char Municipio[],char Estado[])
{
    if(Uart.writeable()) {
        Uart.printf("%s",Municipio);
        Uart.printf("%s",Estado);
        Uart.printf("%s",Parquimetro);
    } else {
        wait_ms(500);
        if(Uart.writeable()) {
            Uart.printf("%s",Municipio);
            Uart.printf("%s",Estado);
            Uart.printf("%s",Parquimetro);
        }
    }
}

void SLAVE::Send_User(char Parquimetro[],char Municipio[],int Tiempo,char Espacio[],char Track2[])
{
    if(Uart.writeable()) {
        Uart.printf("%s",Municipio);
        Uart.printf("%s",Espacio);
        Uart.printf("%s",Parquimetro);
        if(Tiempo<100) {
            Uart.putc('0');
            Uart.printf("%i",Tiempo);
        } else {
            Uart.printf("%i",Tiempo);
        }
        Uart.printf("%s",Track2);
    } else {
        wait_ms(500);
        if(Uart.writeable()) {
            Uart.printf("%s",Municipio);
            Uart.printf("%s",Espacio);
            Uart.printf("%s",Parquimetro);
            if(Tiempo<100) {
                Uart.putc('0');
                Uart.printf("%i",Tiempo);
            } else {
                Uart.printf("%i",Tiempo);
            }
            Uart.printf("%s",Track2);
        }
    }
}

char SLAVE::Recibe()
{
    if(Slave_Counter>0) {
        Slave_Counter--;
        return Slave_Buffer[Slave_Counter];
    } else {
        return NO_DATA;
    }
}

bool SLAVE::Answer()
{
    if(Slave_Counter>0) {
        Slave_Counter--;
        if(Slave_Buffer[Slave_Counter]==NEXT_STEP) {
            return 1;
        } else {
            return 0;
        }
    }
    return 0;
}

void SLAVE::Awake()
{
    _AWAKE=1;
    wait_us(50);
    _AWAKE=0;
}

void SLAVE::Sleep()
{
    if(Uart.writeable()) {
        Uart.putc(NEXT_SLEEP);
    } else {
        wait_ms(500);
        if(Uart.writeable()) {
            Uart.putc(NEXT_SLEEP);
        }
    }

}

void SLAVE::UartInterruption()
{
    if(Uart.readable()) {
        Slave_Buffer[Slave_Counter]=Uart.getc();
        Slave_Counter++;
    }
}
