#include    "Slave.h"
#include    "mbed.h"
#include    "stdio.h"
#include    <string>

#include    "mbedtls/rsa.h"
#include    "mbedtls/pk.h"
#include    "mbedtls/base64.h"
#include    "mbedtls/ctr_drbg.h"
#include    "mbedtls/error.h"
#include    "mbedtls/ctr_drbg.h"
#include    "mbedtls/platform.h"
#include    "mbedtls/entropy.h"

#define     NEXT_STEP           0x85
#define     NEXT_SLEEP          0x86
#define     NO_DATA             0x87

static const uint8_t PublicKeyTXT[] = 
"-----BEGIN PUBLIC KEY-----\n"
"MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCtlciI/Mk4fkxeOwiB0iwiBmoS\n"
"yhqQNKBg+KmzpZDcLkl8ShDY/BjZjW9UXYX8ptCHwV9WU4ltdA4fBTm51m52fOGv\n"
"ZPODurIbNEnaFMRn9hsDJRA6adz32XRQVsjQYLMnQnlaMYGKvuatHPPK/ZCuJRmd\n"
"ttiijs3t/bmCU/Vi8wIDAQAB\n"
"-----END PUBLIC KEY-----\n";

char Slave_Buffer[255];
int  Slave_Counter=0;

uint8_t MessageDecrypt[] ="{\"municipio\":\"San Jose\",\"id\":\"1067\",\"place\":\"AAAA\",\"time\":\"000\",\"t2\":\"%5303105315252296=21080000000000000000?\"}";
uint8_t Encryption[200];
uint8_t Encryption1[200];
size_t *Olen2;

SLAVE::SLAVE(PinName TX, PinName RX,PinName AWAKE):Uart(TX,RX),_AWAKE(AWAKE)
{
    _AWAKE=0;
    Uart.attach(this,&SLAVE::UartInterruption);
}

bool SLAVE::Available()
{
    if(Slave_Counter>0) {
        return 1;
    } else {
        return 0;
    }
}

bool SLAVE::Message()
{
    if(Slave_Counter>4) {
        return 1;
    } else {
        return 0;
    }
}

void SLAVE::Command(uint8_t _Command)
{
    if(Uart.writeable()) {
        Uart.putc(_Command);
    } else {
        wait_ms(500);
        if(Uart.writeable()) {
            Uart.putc(_Command);
        }
    }
}

void SLAVE::Send_Hosting(char Parquimetro[],char Municipio[],char Estado[])
{
    if(Uart.writeable()) {
        Uart.printf("%s",Municipio);
        Uart.printf("%s",Estado);
        Uart.printf("%s",Parquimetro);
    } else {
        wait_ms(500);
        if(Uart.writeable()) {
            Uart.printf("%s",Municipio);
            Uart.printf("%s",Estado);
            Uart.printf("%s",Parquimetro);
        }
    }
}

void SLAVE::Encryption_Send()
{   
    if(Uart.writeable()) {
        for(int i=0;i<172;i++){        
            Uart.putc(Encryption1[i]);
            
        }
    } else {
        wait_ms(500);
        if(Uart.writeable()) {
            for(int i=0;i<172;i++){
               Uart.putc(Encryption1[i]);
            }
        }
    }
}

void SLAVE::Encryption_Print()
{   
    for(int i=0;i<172;i++){        
        printf("%c",Encryption1[i]);    
    }
    printf("\n"); 
}

void  SLAVE::Set_Time(int Time){
    char TimeString[4];
    if(Time<100) {
        sprintf(TimeString,"0%i",Time);
    } else {
        sprintf(TimeString,"%i",Time);
    }
    MessageDecrypt[59]=TimeString[0];
    MessageDecrypt[60]=TimeString[1];
    MessageDecrypt[61]=TimeString[2];   
}

void  SLAVE::Set_Place(char Place[]){
    MessageDecrypt[45]=Place[0];
    MessageDecrypt[46]=Place[1];
    MessageDecrypt[47]=Place[2];
    MessageDecrypt[48]=Place[3];    
}

void  SLAVE::Set_Track(char Track2[]){
    for(int i=0; i<37; i++) {
        MessageDecrypt[71+i]=Track2[i];
    } 
} 
    
void SLAVE::Encryption_Data(char Parquimetro[],char Municipio[],int Tiempo,char Espacio[],char Track2[]){
    // Municipio
    MessageDecrypt[14]=Municipio[0];
    MessageDecrypt[15]=Municipio[1];
    MessageDecrypt[16]=Municipio[2];
    MessageDecrypt[17]=Municipio[3];
    MessageDecrypt[18]=Municipio[4];
    MessageDecrypt[19]=Municipio[5];
    MessageDecrypt[20]=Municipio[6];
    MessageDecrypt[21]=Municipio[7];
    // Identificador
    MessageDecrypt[30]=Parquimetro[0];
    MessageDecrypt[31]=Parquimetro[1];
    MessageDecrypt[32]=Parquimetro[2];
    MessageDecrypt[33]=Parquimetro[3];
    // Espacio
    MessageDecrypt[45]=Espacio[0];
    MessageDecrypt[46]=Espacio[1];
    MessageDecrypt[47]=Espacio[2];
    MessageDecrypt[48]=Espacio[3];
    // Tiempo   
    char TiempoString[4];
    if(Tiempo<100) {
        sprintf(TiempoString,"0%i",Tiempo);
    } else {
        sprintf(TiempoString,"%i",Tiempo);
    }
    MessageDecrypt[59]=TiempoString[0];
    MessageDecrypt[60]=TiempoString[1];
    MessageDecrypt[61]=TiempoString[2];
    // Track2
    for(int i=0; i<37; i++) {
        MessageDecrypt[71+i]=Track2[i];
    }    
}

void SLAVE::Encryption_Execute(){
    
    mbedtls_entropy_context entropy;
    mbedtls_entropy_init( &entropy );
    
    mbedtls_ctr_drbg_context ctr_drbg;
    mbedtls_ctr_drbg_init(&ctr_drbg);
    
    mbedtls_pk_context PublicKey;           // Crea la llave
    mbedtls_pk_init(&PublicKey);            // Inicializa la llave
    
    int     ret;
    size_t  olen = 0;
    uint8_t error[100];
    size_t  errorlen=100; 
    const char *pers = "mbedtls_pk_encrypt";
    
    // Se inicia el generador de entropia del MCU para obtner numeros aleatorios
    
    if( ( ret = mbedtls_ctr_drbg_seed(&ctr_drbg, mbedtls_entropy_func, &entropy, (const unsigned char*)pers, strlen(pers))) != 0)
    {
        mbedtls_strerror(ret,(char*)error,errorlen);
    } else {
        printf( "Entropy generator ok\n");
    }
    
    // Iniciar la llave almacenada en al variable PublucKey para la encriptacion
    
    if ((ret=mbedtls_pk_parse_public_key(&PublicKey, PublicKeyTXT, sizeof(PublicKeyTXT))) != 0)
    {
        printf( "Public key fail\n");
        printf(" Ret: 0x%04x\n",ret);
        mbedtls_strerror(ret,(char*)error,errorlen);
        printf( "Error: %s\n",error);   
    } else {
        //printf( "Public key ok ");
        //SizeOutputKey=mbedtls_pk_get_len(&PublicKey);
        //printf("--> %i\n\n",SizeOutputKey);
    }
    
    // Proceso de encriptacion donde se utilizan tanto el generador random como la key inicializadas
    
    if ((ret=mbedtls_pk_encrypt(&PublicKey, MessageDecrypt, sizeof(MessageDecrypt)-1,Encryption, &olen, 200 ,mbedtls_ctr_drbg_random, &ctr_drbg)) != 0)
    {
        printf("Encrypt failed\n");
        printf("Ret: 0x%04x, Olen: %i,\n",ret,olen);
        mbedtls_strerror(ret,(char*)error,errorlen);
        printf( "Error: %s\n",error);    
    }
    else
    {   
        //printf(" Encrypt ok\n");
        //printf(" Ret: 0x%04x, Olen: %i,\n\n",ret,olen);       
    }
    
    // Se convierte el resultado de la encriptacion a base 64 para eliminar caracteres invalidos
     
    mbedtls_base64_encode(Encryption1,200,Olen2,Encryption,128);
    //printf( "Mensaje encriptado: %s\n",Encryption1);
    //printf( "Longitud encriptado: %i\n",Olen2);
    printf( "Mensaje Original: %s\n", MessageDecrypt);
    
    mbedtls_pk_free(&PublicKey);            // Libera las variables usadas en el proceso        
    mbedtls_ctr_drbg_free(&ctr_drbg );
    mbedtls_entropy_free(&entropy ); 
    
}

void SLAVE::Send_User(char Parquimetro[],char Municipio[],int Tiempo,char Espacio[],char Track2[])
{
    if(Uart.writeable()) {
        Uart.printf("%s",Municipio);
        Uart.printf("%s",Espacio);
        Uart.printf("%s",Parquimetro);
        if(Tiempo<100) {
            Uart.putc('0');
            Uart.printf("%i",Tiempo);
        } else {
            Uart.printf("%i",Tiempo);
        }
        Uart.printf("%s",Track2);
    } else {
        wait_ms(500);
        if(Uart.writeable()) {
            Uart.printf("%s",Municipio);
            Uart.printf("%s",Espacio);
            Uart.printf("%s",Parquimetro);
            if(Tiempo<100) {
                Uart.putc('0');
                Uart.printf("%i",Tiempo);
            } else {
                Uart.printf("%i",Tiempo);
            }
            Uart.printf("%s",Track2);
        }
    }
}

char SLAVE::Recibe()
{
    if(Slave_Counter>0) {
        Slave_Counter--;
        return Slave_Buffer[Slave_Counter];
    } else {
        return NO_DATA;
    }
}

bool SLAVE::Answer()
{
    if(Slave_Counter>0) {
        Slave_Counter--;
        if(Slave_Buffer[Slave_Counter]==NEXT_STEP) {
            return 1;
        } else {
            return 0;
        }
    }
    return 0;
}

void SLAVE::Awake()
{
    _AWAKE=1;                      //despierta al esclavo con un flanco positivo
    wait_us(50);
    _AWAKE=0;                      //se vuelve a poner en cero para que el proximo AWAKE=1 sea un flanco positivo
}

void SLAVE::Sleep()
{
    if(Uart.writeable()) {
        Uart.putc(NEXT_SLEEP);
    } else {
        wait_ms(500);
        if(Uart.writeable()) {
            Uart.putc(NEXT_SLEEP);
        }
    }

}

void SLAVE::UartInterruption()
{
    if(Uart.readable()) {
        Slave_Buffer[Slave_Counter]=Uart.getc();
        Slave_Counter++;
    }
}
