#include "mbed.h"
#include "GraphicLCD.h"

Serial Computer(USBTX, USBRX);


//-------------Conexiones GLCD T6963C--------------------
//  1  2       Vss Vss          Ti  Ti(NO Conectada)
//  3  4       Vcc Cte          Vc  Po
//  5  6       WR  RD           D14 D15
//  7  8       CE  CD           F12 F13
//  9  10      -V  RST          Po  E9
//  11 12      D0  D1           E11 F14
//  13 14      D2  D3           E13 F15
//  15 16      D4  D5           D8  D9
//  17 18      D6  D7           E8  E7
//  19 20      NC  NC
//-------------------------------------------------------
// https://os.mbed.com/users/tonydbeck/code/gLCD/file/66b988c1b143/gLCD.cpp/
// https://github.com/olikraus/u8glib/blob/master/tools/font/bdf/helvR14.bdf


GLCD         Screen(PD_8,PE_10,PD_9,PE_12,PE_8,PE_14,PE_7,PE_15,PE_9,PE_11,PF_15,PE_13,PF_13,PB_1);
// CLASS     GLCD(D1,D2,D3,D4,D5,D6,D7,D8,CD,RESET,CE,WR,RD)
//           Screen(PD_8,PE_10,PD_9,PE_12,PE_8,PE_14,PE_7,PE_15,PE_9,PE_11,PF_15,PE_13,PF_13
DigitalOut Li(PF_14);

void PantallaInicio()
{
    Computer.printf("Pantala de Inicio");
    Li=1;
    Screen.Limits();
    Screen.PutString(45,19,"Prueba E-Park");
    Screen.Show();
    wait_ms(3000);

    Screen.Limits();
    Screen.PutString(58,12,"Grupo Setex");
    Screen.PutString(65,34,"Costa Rica");
    Screen.Show();
    wait_ms(3000);
    Li=0;
}


int main()
{
    while(1) {
        
        Screen.On();
        wait(1);
        Screen.Init();
        Screen.Clean();
        PantallaInicio();
        Screen.Off();
        wait(10);
    }
}