#include "LimitSwitches.h"
#include "mbed.h"
#include "stdio.h"

SWITCHES::SWITCHES(PinName S1, PinName S2) : Switch1(S1),Switch2(S2) {
    Switch1.rise(this,&SWITCHES::InterruptDisable);
    Switch2.rise(this,&SWITCHES::InterruptDisable);
}
 
int SWITCHES::Read()
{
    if(Switch1.read()) {
        return 1;
    }
    if(Switch2.read()) {
        return 2;
    }
    return 0;
}

void SWITCHES::InterruptDisable()
{
    Switch1.disable_irq();
    Switch2.disable_irq();
}
void SWITCHES::InterruptEnable()
{
    Switch1.enable_irq();
    Switch2.enable_irq();
}
