#include "KeyPad.h"
#include "mbed.h"
#include "stdio.h"

#define     NO_KEY  0x00

KEYPAD::KEYPAD(PinName F1, PinName F2,PinName F3, PinName F4,PinName C1, PinName C2,PinName C3, PinName C4) : Keypad_F1(F1),Keypad_F2(F2),Keypad_F3(F3),Keypad_F4(F4),Keypad_C1(C1),Keypad_C2(C2),Keypad_C3(C3),Keypad_C4(C4) {
    Keypad_F1 = 0;
    Keypad_F2 = 0;
    Keypad_F3 = 0;
    Keypad_F4 = 0;
    Keypad_C1.rise(this,&KEYPAD::InterruptDisable);
    Keypad_C2.rise(this,&KEYPAD::InterruptDisable);
    Keypad_C3.rise(this,&KEYPAD::InterruptDisable);
    Keypad_C4.rise(this,&KEYPAD::InterruptDisable);
}
 
char KEYPAD::Read(void)
{
    Keypad_F1=1;
    Keypad_F2=0;
    Keypad_F3=0;
    Keypad_F4=0;
    wait_us(10);
    if(Keypad_C1.read()) {
        return '1';
    }
    if(Keypad_C2.read()) {
        return '2';
    }
    if(Keypad_C3.read()) {
        return '3';
    }
    if(Keypad_C4.read()) {
        return 'A';
    }

    Keypad_F1=0;
    Keypad_F2=1;
    Keypad_F3=0;
    Keypad_F4=0;
    wait_us(10);
    if(Keypad_C1.read()) {
        return '4';
    }
    if(Keypad_C2.read()) {
        return '5';
    }
    if(Keypad_C3.read()) {
        return '6';
    }
    if(Keypad_C4.read()) {
        return 'B';
    }

    Keypad_F1=0;
    Keypad_F2=0;
    Keypad_F3=1;
    Keypad_F4=0;
    wait_us(10);
    if(Keypad_C1.read()) {
        return '7';
    }
    if(Keypad_C2.read()) {
        return '8';
    }
    if(Keypad_C3.read()) {
        return '9';
    }
    if(Keypad_C4.read()) {
        return 'C';
    }

    Keypad_F1=0;
    Keypad_F2=0;
    Keypad_F3=0;
    Keypad_F4=1;
    wait_us(10);
    if(Keypad_C1.read()) {
        return 'F';
    }
    if(Keypad_C2.read()) {
        return '0';
    }
    if(Keypad_C3.read()) {
        return 'E';
    }
    if(Keypad_C4.read()) {
        return 'D';
    }

    return NO_KEY;
}

void KEYPAD::InterruptDisable()
{
    Keypad_C1.disable_irq();
    Keypad_C2.disable_irq();
    Keypad_C3.disable_irq();
    Keypad_C4.disable_irq();
}

void KEYPAD::InterruptEnable()
{
    Keypad_C1.enable_irq();
    Keypad_C2.enable_irq();
    Keypad_C3.enable_irq();
    Keypad_C4.enable_irq();
    Keypad_F1=1;
    Keypad_F2=1;
    Keypad_F3=1;
    Keypad_F4=1;
}
