#ifndef MBED_GLCD_H
#define MBED_GLCD_H
 
#include "mbed.h"
 
class GLCD {
public:
    GLCD(PinName D1,PinName D2,PinName D3,PinName D4,PinName D5,PinName D6,PinName D7,PinName D8,PinName CD,PinName RESET,PinName CE,PinName WR,PinName RD,PinName Power);

    void WriteData(uint8_t Data);
    void WriteCommand(uint8_t Command);
    void Limits();
    void Fill();
    void Clean();
    void Horizontal();
    void Cross();
    void Vertical();
    void Show();
    void Characters();
    void Init();
    void On();
    void Off();
    void Pixel(int x, int y);
    void Rectangle(int X0, int Y0, int X1, int Y1);
    int  PutChar(int X,int Y,int Letter);
    void PutString(int X, int Y, char String[]);
  
private:  
    DigitalOut  _D1;
    DigitalOut  _D2;
    DigitalOut  _D3;
    DigitalOut  _D4;
    DigitalOut  _D5;
    DigitalOut  _D6;
    DigitalOut  _D7;
    DigitalOut  _D8;
    DigitalOut  _CD;
    DigitalOut  _RESET;
    DigitalOut  _CE;
    DigitalOut  _WR;
    DigitalOut  _RD;
    DigitalOut  _Power;
};
 
#endif
 
 