#include "mbed.h"
#include <stdio.h>
#include <stdlib.h>

#include "mbedtls/rsa.h"
#include "mbedtls/pk.h"
#include "mbedtls/base64.h"
#include "mbedtls/ctr_drbg.h"
#include "mbedtls/error.h"
#include "mbedtls/ctr_drbg.h"
#include "mbedtls/platform.h"
#include "mbedtls/entropy.h"

// ------------------Examples keys from http://travistidwell.com/jsencrypt/demo/

static const uint8_t PrivateKeyTXT[] = 
"-----BEGIN RSA PRIVATE KEY-----\n"
"MIICXQIBAAKBgQCtlciI/Mk4fkxeOwiB0iwiBmoSyhqQNKBg+KmzpZDcLkl8ShDY\n"
"/BjZjW9UXYX8ptCHwV9WU4ltdA4fBTm51m52fOGvZPODurIbNEnaFMRn9hsDJRA6\n"
"adz32XRQVsjQYLMnQnlaMYGKvuatHPPK/ZCuJRmdttiijs3t/bmCU/Vi8wIDAQAB\n"
"AoGBAJ9alhJMHl3idDE9eH3Vd/Z0dQRyzRf9eA4NuZzWLbo0M/oJ9JV+OUHe+Yk1\n"
"oj9i1KUL/H2/irYUiLIplejo1dYkpdD8gEBpNK5HLh9rd2IPxyyS8PkkeKwWnj35\n"
"4N4CEf8d8+JF/VA2KvPVyqUC8m8JAFwQkNioyZmGnFhJ/m5hAkEA4irJ4emRtr5T\n"
"U2ic4Vbvb7k8rnh/xBpPRtJbx219VQItxFECdm6bIExZevVNGZx2YKZIsklVUIbu\n"
"wFjBzXY/JQJBAMR7Z3fEKK2NqX+BgbecdPimYce0QSbMpZ1Co9U6tts3yT2sKaqQ\n"
"8Zz0l8/0eNQlBe9PUBywwhRhkplqOE2e6jcCQCcez5zMEfBSK4eZ6MjxiKkCmYR0\n"
"Q2VgR6YwbL+qKKuznMcAXDSwHRURH8ks9REhBzjgimKMXL15GYMb1yn68iECQC/A\n"
"rkz1Z82GeIN8vkIZzHQCPBGFRbBgXH/0Ck1wj7CHxmkuxpGl2JME/0CTcipdNSwM\n"
"YrQWYZUCgda3cierT9ECQQDZUgRkBsVsL60neHskYq2xCJO7RGxwrqekBvtXjo4i\n"
"6IHgjeagH9Mf1hLVZQ7aPU3EFwk4jcb6FOhTqSqrZWKH\n"
"-----END RSA PRIVATE KEY-----\n";

static const uint8_t PublicKeyTXT[] = 
"-----BEGIN PUBLIC KEY-----\n"
"MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCtlciI/Mk4fkxeOwiB0iwiBmoS\n"
"yhqQNKBg+KmzpZDcLkl8ShDY/BjZjW9UXYX8ptCHwV9WU4ltdA4fBTm51m52fOGv\n"
"ZPODurIbNEnaFMRn9hsDJRA6adz32XRQVsjQYLMnQnlaMYGKvuatHPPK/ZCuJRmd\n"
"ttiijs3t/bmCU/Vi8wIDAQAB\n"
"-----END PUBLIC KEY-----\n";

// Privada ---> Encriptacion
// Publica ---> Desencripta

uint8_t Message[] ="{\"municipio\":\"Santa Ana\",\"id\":1067,\"place\":\"2222\",\"time\":120,\"t2\":\"%5303105315252296=2108?\"}1111111199999991111111111";
uint8_t Encryption1[200];
uint8_t Encryption[200];
uint8_t Encryption_HEX[]= "\x43\x60\x5f\x65\xbc\x78\x89\x57\x5c\x6d\xc6\x47\x53\x57\x10\xd3\x45\x0e\x77\xe0\x85\x5f\xf8\x3d\x32\x6e\xcf\x94\x4c\x1f\xa8\x11\xe6\x6b\x93\x5e\xc7\x37\xe2\xee\x63\x99\x6e\x80\x70\x6e\xe2\x38\xcc\x0b\x9d\x82\x83\x47\x38\xed\xe4\x21\x4d\x13\x3c\x94\x01\xfc\x00";
uint8_t Decryption[200];

int main()
{
    mbedtls_entropy_context entropy;
    mbedtls_entropy_init( &entropy );
    
    mbedtls_ctr_drbg_context ctr_drbg;
    mbedtls_ctr_drbg_init(&ctr_drbg);
     
    mbedtls_pk_context PrivateKey;        // Crea la llave
    mbedtls_pk_init(&PrivateKey);         // Inicializa la llave
    
    mbedtls_pk_context PublicKey;           // Crea la llave
    mbedtls_pk_init(&PublicKey);            // Inicializa la llave
    
    int     ret;
    size_t  olen = 0;
    uint8_t error[100];
    size_t  errorlen=100; 
    int     SizeOutputKey;
    const char *pers = "mbedtls_pk_encrypt";
    
    // ------------------------Random number generator---------------------------
    if( ( ret = mbedtls_ctr_drbg_seed(&ctr_drbg, mbedtls_entropy_func, &entropy, (const unsigned char*)pers, strlen(pers))) != 0)
    {
        printf( "Entropy generator fail\n");
        printf(" Ret: 0x%04x\n",ret);
        mbedtls_strerror(ret,(char*)error,errorlen);
        printf( "Error: %s\n",error);  
    } else {
        printf( "Entropy generator ok\n");
    }
       
    // ------------------------Create the public keys---------------------------
    if ((ret=mbedtls_pk_parse_public_key(&PublicKey, PublicKeyTXT, sizeof(PublicKeyTXT))) != 0)
    {
        printf( "Public key fail\n");
        printf(" Ret: 0x%04x\n",ret);
        mbedtls_strerror(ret,(char*)error,errorlen);
        printf( "Error: %s\n",error);   
    } else {
        printf( "Public key ok ");
        SizeOutputKey=mbedtls_pk_get_len(&PublicKey);
        printf("--> %i\n",SizeOutputKey);
    }
    printf( "Llave publica: \n%s\n\n",PublicKeyTXT);
    
    // -----------------------Create the private keys---------------------------
    if ((ret=mbedtls_pk_parse_key(&PrivateKey, PrivateKeyTXT, sizeof(PrivateKeyTXT), NULL, 0)) != 0)
    {
        printf( "Private key fail\n");
        printf(" Ret: 0x%04x\n",ret);
        mbedtls_strerror(ret,(char*)error,errorlen);
        printf( "Error: %s\n",error);
    } else {
        printf( "Private key ok ");
        SizeOutputKey=mbedtls_pk_get_len(&PrivateKey);
        printf("--> %i\n",SizeOutputKey);       
    }
    printf( "Llave privada: \n%s\n\n",PrivateKeyTXT);
    
    // ------------------------Check the pair of keys before--------------------    
    if ((ret=mbedtls_pk_check_pair(&PublicKey,&PrivateKey))!= 0)
    {
        printf( "\n\nKeys check fail\n");
        mbedtls_strerror(ret,(char*)error,errorlen);
        printf( "Error: %s\n",error);
    } else {
        printf( "Keys check ok\n\n");
    }
    //--------------------------------Encryption--------------------------------
    if ((ret=mbedtls_pk_encrypt(&PublicKey, Message, sizeof(Message)-1,Encryption, &olen, 200 ,mbedtls_ctr_drbg_random, &ctr_drbg)) != 0)
    {
        printf("Encrypt failed\n");
        printf("Ret: 0x%04x, Olen: %i,\n",ret,olen);
        mbedtls_strerror(ret,(char*)error,errorlen);
        printf( "Error: %s\n",error);    
    }
    else
    {   printf(" Encrypt ok\n");
        printf(" Ret: 0x%04x, Olen: %i,\n",ret,olen);
        printf(" Encryt message: %s\n",Encryption); // should be "0xFF...."
        printf(" \n");       
    }

    //--------------------------------Decryption--------------------------------
    if((ret=mbedtls_pk_decrypt(&PrivateKey, Encryption, 128, Decryption, &olen, 1024,mbedtls_ctr_drbg_random, &ctr_drbg ) ) != 0 )
    {
        printf( "Decrypt failed\n");
        printf(" Ret: 0x%04x, Olen: %i,\n",ret,olen);
        mbedtls_strerror(ret,(char*)error,errorlen);
        printf( "Error: %s\n",error);
    } 
    else 
    {   
        printf(" Decryption Ok\n");
        printf(" Decryption message: %s\n",Decryption); // should be "Hola mundo"
    }
       
    
    printf( "\nMensaje original: %s\n\n",Message);
    printf( "Mensaje encriptado: %s\n\n",Encryption);
    printf( "Mensaje encriptado HEX: ");
    for(int i=0; i<=130; i++){      
            printf(" %02x",Encryption[i]);                  
    }
    printf(" \n\n");
    printf( "Mensaje desencriptado: %s\n\n",Decryption);
    
    size_t *Olen2;
    mbedtls_base64_encode(Encryption1,200,Olen2,Encryption,128);
    printf( "Mensaje encriptado: %s\n\n",Encryption1);
    printf( "Mensaje encriptado: %i\n\n",Olen2);
    
    mbedtls_pk_free(&PrivateKey);           // Inicializa la llave
    mbedtls_pk_free(&PublicKey);            // Inicializa la llave
    mbedtls_ctr_drbg_free( &ctr_drbg );
    mbedtls_entropy_free( &entropy );

    while(1) {
        
    }
}





