#include "mbed.h"

#define     COMMAND_ON          0X70
#define     COMMAND_INIT        0X71
#define     COMMAND_GPRS        0X72
#define     COMMAND_DATA        0X73
#define     COMMAND_POST        0X74
#define     COMMAND_ANSWER      0X75
#define     COMMAND_SIGNAL      0X76
#define     COMMAND_CONNECT     0X77
#define     COMMAND_OFF         0X78
#define     HOSTING_STEP1       0x79
#define     HOSTING_STEP2       0x7A
#define     HOSTING_STEP3       0x7B
#define     HOSTING_STEP4       0x7C
#define     HOSTING_STEP5       0x7D
#define     HOSTING_STEP6       0x7E
#define     HOSTING_STEP7       0x7F
#define     HOSTING_STEP8       0x80
#define     HOSTING_STEP9       0x81
#define     HOSTING_STEP10      0x82
#define     HOSTING_STEP11      0x83
#define     HOSTING_OFF         0x84
#define     NEXT_STEP           0x85
#define     NEXT_SLEEP          0x86
#define     COMMAND_END         0X88

#define     USER_INIT           0xA0
#define     USER_PLACE          0xA1
#define     USER_CARD           0xA2
#define     USER_TIME           0xA3
#define     USER_DATA           0xA4
#define     USER_PRINT          0xA5
#define     USER_TICKET         0xA6
#define     USER_FINISH         0xA7
#define     USER_POST           0xA8
#define     USER_ANSWER         0xA9
#define     USER_INIT2          0xAA
#define     USER_INIT3          0xB0
#define     USER_INIT4          0xB1
#define     USER_CARD2          0xB2
#define     USER_INIT5          0xB3
#define     USER_CARD3          0xB4
// Conector ZHR-6 de JST http://www.jst.com/
//   _ _ _ _ _ _
//  ! ! ! ! ! ! !             1->CTS    2->TXD    3->DTR
//   6 5 4 3 2 1              4->RXD    5->GND    6->PWR

Serial Computer(USBTX, USBRX);      // tx, rx
Serial CardReader(PC_12,PD_2,9600);

const char SOH=1;
const char EOT=4;
const char ESP=33;
const char ADDR=0;
const char LEN=0;
const char CARD_POSITION='8';
const char CARD_LOCK='{';
const char CARD_UNLOCK='}';
const char DEV_STATUS='$';
const char DEV_RESET=127;
const char ARM_MODE='P';
const char ARM_DEBUG='p';
const char ARM_ABORT=27;
const char SIG_START='?';
const char FCT_READ='R';
const char MAG_CUSTOM_T1='U';
const char MAG_CUSTOM_T2='V';
const char MAG_CUSTOM_T3='W';
const char MAG_ISO_T1='Q';
const char MAG_ISO_T2='R';
const char MAG_ISO_T3='S';
const char MAG_CUSTOM_F='4';
const char BBCA='=';
const char BBCB='~';
const char BBCC='x';
const char BBCD='!';
const char BBCE='U';
const char BBCF='u';
const char BBCG=30;
const char BBCH='d';
const char BBCI='z';
const char BBCJ='T';
const char BBCK='W';
const char BBCL='V';
const char BBCM=10;
const char R_ACTION='^';
const char R_ERROR='*';
const char R_INVALID='!';
const char R_NO_DATA='+';
const char R_COMAND_ERROR='?';
const char R_START=':';
const char R_POSITION1='q';
const char R_POSITION2='s';
const char R_NO_MAG_CARD='>';
const char R_MAG_DETECT_ON='(';
const char R_MAG_DETECT_OFF=')';
char Track2[38]="0000000000000000000000000000000000000";

DigitalOut   CardReaderPower(PF_3);//
DigitalOut   Max232(PC_8);


char StateReader[7]= {'0','0','0','0','0','0','0'};
char CardReader_Buffer[255];
int CardReader_Counter=0;
char Comando=' ';
unsigned long Inicio, Fin, Transcurrido;
Timer BaseClock;



void Interrupt_CardReader()
{
    CardReader_Buffer[CardReader_Counter]=CardReader.getc();
    CardReader_Counter++;
}



int ResetCard()
{
    CardReader_Counter=0;
    StateReader[0]='S';
    Computer.printf("\n Reset card reader");
    if(CardReader.writeable()) {
        CardReader.putc(SOH);           // 00000001
        CardReader.putc(ADDR);          // 00000000
        CardReader.putc(LEN);           // 00000000
        CardReader.putc(LEN);           // 00000000
        CardReader.putc(DEV_RESET);     // 01111111
        CardReader.putc(EOT);           // 00000100
        CardReader.putc(BBCI);          // 01111010
    }
    wait_ms(2000);
    for(int i=0; i<=CardReader_Counter; i++) {
        if(CardReader_Buffer[i]==R_START) {
            Computer.printf("\n Start\n");            // Encendido
            StateReader[0]='A';
            
            return 1;
        }
        if(CardReader_Buffer[i]==R_INVALID) {
            Computer.printf("\n Invalid ");         // Comando Invalido
            StateReader[0]='N';
            
            return 0;
        }
        if(CardReader_Buffer[i]==R_ERROR) {
            Computer.printf("\n Error ");           // Error
            StateReader[0]='E';
            
            return 0;
        }
        if(CardReader_Buffer[i]==R_COMAND_ERROR) {
            Computer.printf("\n Comando error ");    // Error en comando
            StateReader[0]='C';
            
            return 0;
        }
    }
    
    return 2;
}

void DetectionCard(uint32_t TimeOut)
{
    CardReader_Counter=0;
    StateReader[1]='S';
    StateReader[2]='S';
    StateReader[3]='S';
    if(StateReader[0]=='A') {               // Se envia el comando Arm Debug
        Computer.printf("\n Introducir tarjeta");
        if(CardReader.writeable()) {
            CardReader.putc(SOH);
            CardReader.putc(ADDR);
            CardReader.putc(LEN);
            CardReader.putc(LEN);
            CardReader.putc(ARM_DEBUG);
            CardReader.putc(EOT);
            CardReader.putc(BBCF);
        }
        wait_ms(500);
        for(int i=0; i<=CardReader_Counter; i++) {
            if(CardReader_Buffer[i]==R_ACTION) {
                Computer.printf("\n ACTION ");      // Accion ejecutada
                StateReader[1]='A';
               
            }
            if(CardReader_Buffer[i]==R_INVALID) {
                Computer.printf("\n Invalido ");     // Comando Invalido
                StateReader[1]='N';
                
            }
            if(CardReader_Buffer[i]==R_ERROR) {
                Computer.printf("\n Error ");       // Error
                StateReader[1]='E';
                
            }
            if(CardReader_Buffer[i]==R_COMAND_ERROR) {
                Computer.printf("\n Comando error ");// Error en comando
                StateReader[1]='C';
                
            }
        }
        CardReader_Counter=0;

        Inicio=BaseClock.read_ms();
        while(CardReader_Counter==0) {       // Esperando introduccion de tarjeta
            Fin=BaseClock.read_ms();
            Transcurrido=Fin-Inicio;
            if(StateReader[1]=='C'||StateReader[1]=='E'||StateReader[1]=='N') {
                Computer.printf("\n Error en comando");
                break;
            }
            if(StateReader[1]=='S') {
                Computer.printf("\n Sin respuesta");
                break;
            }
            if(Transcurrido>TimeOut) {
                Computer.printf("\n Tiempo de respuesta");
                if(CardReader.writeable()) {
                    CardReader.putc(SOH);
                    CardReader.putc(ADDR);
                    CardReader.putc(LEN);
                    CardReader.putc(LEN);
                    CardReader.putc(ARM_ABORT);
                    CardReader.putc(EOT);
                    CardReader.putc(BBCG);
                }
                break;
            }
        }
        wait_ms(1000);
        for(int i=0; i<=CardReader_Counter; i++) {
            Computer.printf("%c",CardReader_Buffer[i]);
            if(CardReader_Buffer[i]==R_NO_MAG_CARD) {
                Computer.printf("\n Deteccion nula ");      // No se detecta banda magnetica
                StateReader[2]='N';
                StateReader[3]='N';
            }
            if(CardReader_Buffer[i]==R_MAG_DETECT_ON) {
                Computer.printf("\n Deteccion on ");        // Se inicia verificacion de banda
                StateReader[2]='A';
            }
            if(CardReader_Buffer[i]==R_MAG_DETECT_OFF) {
                Computer.printf("\n Deteccion off ");       // Se termina verificacion de banda
                StateReader[3]='A';
            }
            if(CardReader_Buffer[i]==R_ACTION) {
                Computer.printf("\n Action arm abort ");    // Accion ejecutada
                StateReader[1]='T';
            }
        }
    }
}

int PositionCard()
{
    CardReader_Counter=0;
    StateReader[4]='S';
    Computer.printf("\n Detectando tarjeta");
    if(CardReader.writeable()) {
        CardReader.putc(SOH);
        CardReader.putc(ADDR);
        CardReader.putc(LEN);
        CardReader.putc(LEN);
        CardReader.putc(CARD_POSITION);
        CardReader.putc(EOT);
        CardReader.putc(BBCA);
    }
    wait_ms(250);
    for(int i=0; i<=CardReader_Counter; i++) {
        Computer.printf("%c",CardReader_Buffer[i]);
        if(CardReader_Buffer[i]==R_POSITION1) {
            Computer.printf("\n Tarjeta en posicion incorrecta ");   // Mal colocada la tarjeta
            StateReader[4]='N';
            
            return 0;
        }
        if(CardReader_Buffer[i]==R_POSITION2) {
            Computer.printf("\n Tarjeta en posicion correcta ");     // Bien colocada la tarjeta
            StateReader[4]='A';
            
            return 1;
        }
        if(CardReader_Buffer[i]==R_INVALID) {
            Computer.printf("\n Invalido ");     // Comando Invalido
            StateReader[4]='N';
            return 0;
        }
        if(CardReader_Buffer[i]==R_ERROR) {
            Computer.printf("\n Error ");       // Error
            StateReader[4]='E';
            return 0;
        }
        if(CardReader_Buffer[i]==R_COMAND_ERROR) {
            Computer.printf("\n Comando error ");// Error en comando
            StateReader[4]='C';
            return 0;
        }
    }
    return 2;
}

int ReadCard(uint32_t TimeOut)
{
    CardReader_Counter=0;
    StateReader[5]='S';
    StateReader[6]='S';
    if(StateReader[4]=='A') {
        Computer.printf("\n Retirar Tarjeta en un solo movimiento");
        if(CardReader.writeable()) {
            CardReader.putc(SOH);
            CardReader.putc(ADDR);
            CardReader.putc(LEN);
            CardReader.putc(LEN);
            CardReader.putc(ARM_MODE);
            CardReader.putc(EOT);
            CardReader.putc(BBCE);
        }
        wait_ms(300);
        for(int i=0; i<=CardReader_Counter; i++) {
            Computer.printf("%c",CardReader_Buffer[i]);
            if(CardReader_Buffer[i]==R_ACTION) {
                Computer.printf("\n Accion");      // Accion ejecutada
                StateReader[5]='A';
            }
            if(CardReader_Buffer[i]==R_INVALID) {
                Computer.printf("\n Invalido ");     // Comando Invalido
                StateReader[5]='N';
            }
            if(CardReader_Buffer[i]==R_ERROR) {
                Computer.printf("\n Error ");       // Error
                StateReader[5]='E';
            }
            if(CardReader_Buffer[i]==R_COMAND_ERROR) {
                Computer.printf("\n Comando error ");// Error en comando
                StateReader[5]='C';
            }
        }
        CardReader_Counter=0;
        Inicio=BaseClock.read_ms();
        while(CardReader_Counter==0) {       // Esperando introduccion de tarjeta
            Fin=BaseClock.read_ms();
            Transcurrido=Fin-Inicio;
            if(StateReader[5]=='C'||StateReader[5]=='E'||StateReader[5]=='N') {
                Computer.printf("\n Error en comando");
                break;
            }
            if(StateReader[5]=='S') {
                Computer.printf("\n Sin Respuesta");
                break;
            }
            if(Transcurrido>TimeOut) {
                Computer.printf("\n Tiempo de respuesta superado");
                if(CardReader.writeable()) {
                    CardReader.putc(SOH);
                    CardReader.putc(ADDR);
                    CardReader.putc(LEN);
                    CardReader.putc(LEN);
                    CardReader.putc(ARM_ABORT);
                    CardReader.putc(EOT);
                    CardReader.putc(BBCG);
                }
                StateReader[5]='T';
                break;
            }
        }
        wait_ms(200);
        for(int i=0; i<=CardReader_Counter; i++) {
            Computer.printf("%c",CardReader_Buffer[i]);
            Computer.printf("-%2X-",CardReader_Buffer[i]);
            if(CardReader_Buffer[i]==R_NO_MAG_CARD) {
                Computer.printf("\n Deteccion nula ");      // No se detecta banda magnetica
                StateReader[6]='N';
                return 0;
            }
            if(CardReader_Buffer[i]==R_ACTION) {
                Computer.printf("\n Tarjeta leida ");       // Tarjeta leida
                StateReader[6]='A';
                return 1;
            }
            if(CardReader_Buffer[i]==R_INVALID) {
                Computer.printf("\n Invalido ");             // Comando Invalido
                StateReader[6]='N';
                return 0;
            }
            if(CardReader_Buffer[i]==R_ERROR) {
                Computer.printf("\n Error ");               // Error
                StateReader[6]='E';
                return 0;
            }
            if(CardReader_Buffer[i]==R_COMAND_ERROR) {
                Computer.printf("\n Error comando ");        // Error en comando
                StateReader[6]='C';
                return 0;
            }
        }
    }
    return 0;
}

int RecibeDataCard()
{
    if (StateReader[6]=='A') {
        CardReader_Counter=0;
        if(CardReader.writeable()) {
            CardReader.putc(SOH);               // 00000001
            CardReader.putc(ADDR);              // 00000000
            CardReader.putc(LEN);               // 00000000
            CardReader.putc(LEN);               // 00000000
            CardReader.putc(MAG_ISO_T2);        // 01010101
            CardReader.putc(EOT);               // 00000100
            CardReader.putc(BBCK);
        }
        wait_ms(200);
        for(int i=0; i<=CardReader_Counter; i++) {
            if(CardReader_Buffer[i]==R_NO_DATA) {
                Computer.printf("Sin lectura\n");
                return 0;
            }
            Computer.putc(CardReader_Buffer[i]);
            if(CardReader_Buffer[i]=='=') {
                Computer.printf("Datos leidos ");
                for(int i=0; i<37; i++) {
                    Track2[i]=CardReader_Buffer[i+4];
                }
                Computer.printf("<%s>\n",Track2);
                return 1;
            }
        }
    }
    return 2;
}

int RetiroTarjeta(uint32_t TiempoFuera)
{
    Computer.printf("Retiro tarjeta\n");
    Inicio=BaseClock.read_ms();
    while(true) {
        if(PositionCard()==0) {
            return 1;
        } else {

            Computer.printf("Retire tarjeta");

        }
        Fin=BaseClock.read_ms();
        Transcurrido=Fin-Inicio;
        if(Transcurrido>TiempoFuera) {
            StateReader[1]='T';
            return 0;
        }
    }
}

uint8_t IngresoTarjeta(uint32_t TimeOut)
{
    Computer.printf("Funcion ingreso de tarjeta\n");

    Inicio=BaseClock.read_ms();
    while(true) {
        if(PositionCard()==1) {
            Computer.printf("Tarjeta ingresada\n");
            StateReader[1]='A';
            StateReader[2]='A';
            StateReader[3]='A';
            return 1;
        }
        Fin=BaseClock.read_ms();
        Transcurrido=Fin-Inicio;
        if(Transcurrido>TimeOut) {
            Computer.printf("Tiempo limite\n");
            StateReader[1]='T';
            StateReader[2]='N';
            StateReader[3]='N';
            return 0;
        }
    }
}

uint8_t GetCard(char Salida,uint32_t TimeOutEntrada,uint32_t TimeOutSalida)
{
    //CardReaderStatus=[Reset,ArmDebug,DetectionOn,DetectionOff,Position,Arm,Read]
    // C-> Command error
    // A-> Accepted
    // N-> Invalid
    // E-> Error
    // N-> No detection
    // S-> Without answer
    // T-> Time out
    // Se pide al usuario por pantalla la intrduccion de la tarjeta
                    
    Computer.printf("Introduzca tarjeta");
    Computer.printf("debito o credito");
    sprintf(Track2,"0000000000000000000000000000000000000");

    if(ResetCard()==1) {
        while(true) {
            uint8_t RespuestaIngresoTarjeta = IngresoTarjeta(TimeOutEntrada);
            if(RespuestaIngresoTarjeta==1) {

                Computer.printf("Retire tarjeta");

            }
            if(RespuestaIngresoTarjeta==0) {
                wait(3);
                return USER_FINISH;
            }
            if(RespuestaIngresoTarjeta==2) {
                return USER_FINISH;
            }

            uint8_t RespuestaReadCard=ReadCard(TimeOutSalida); // Se le la tarjeta al retirarse
            if(RespuestaReadCard==2) {
                return USER_FINISH;
            }
            
            uint8_t DataResult=RecibeDataCard();                    // Se corrobora que la informacion de la tajeta es la corre
            if(DataResult==0) {
                Computer.printf("Banda magnetica");
                Computer.printf("ilegible");
                wait(2);
                if(RetiroTarjeta(7000)) {
                    Computer.printf("Introduzca tarjeta");
                    Computer.printf("debito o credito");
                } else {
                    return USER_FINISH;
                }
            }
            if(DataResult==1) {
                return Salida;
            }
            if(DataResult==2) {
                Computer.printf("Banda magnetica");
                Computer.printf("ilegible");
                wait(2);
                if(RetiroTarjeta(7000)) {
                    Computer.printf("Introduzca tarjeta");
                    Computer.printf("debito o credito");

                } else {
                    return USER_FINISH;
                }
            }
        }
    } else {
        Computer.printf("Error");
        return USER_FINISH;
    }
}

int main()
{
    BaseClock.start();
    CardReader.format(8, Serial::None, 1);
    CardReader.baud(9600);
    Computer.format(8, Serial::None, 1);
    Computer.baud(9600);
    CardReader.attach(&Interrupt_CardReader);
    while(1) {
        CardReaderPower=1;
        Max232=1;
        Computer.printf("iniciando proceso\n");
        wait(2);
        GetCard(USER_TIME,20000,5000);
        CardReaderPower=0;
        Max232=0;
        wait(2);
    }
}