#include "mbed.h"

// Conector ZHR-6 de JST http://www.jst.com/
//   _ _ _ _ _ _
//  ! ! ! ! ! ! !             1->CTS    2->TXD    3->DTR
//   6 5 4 3 2 1              4->RXD    5->GND    6->PWR


RawSerial  Computer(USBTX, USBRX);      // tx, rx
RawSerial  CardReader(PC_12,PD_2,9600);

const char SOH=1;
const char EOT=4;
const char ESP=33;
const char ADDR=0;
const char LEN=0;
const char CARD_POSITION='8';
const char CARD_LOCK='{';
const char CARD_UNLOCK='}';
const char DEV_STATUS='$';
const char DEV_RESET=127;
const char ARM_MODE='P';
const char ARM_DEBUG='p';
const char ARM_ABORT=27;
const char SIG_START='?';
const char FCT_READ='R';
const char MAG_CUSTOM_T1='U';
const char MAG_CUSTOM_T2='V';
const char MAG_CUSTOM_T3='W';
const char MAG_ISO_T1='Q';
const char MAG_ISO_T2='R';
const char MAG_ISO_T3='S';
const char MAG_CUSTOM_F='4';
const char BBCA='=';
const char BBCB='~';
const char BBCC='x';
const char BBCD='!';
const char BBCE='U';
const char BBCF='u';
const char BBCG=30;
const char BBCH='d';
const char BBCI='z';
const char BBCJ='T';
const char BBCK='W';
const char BBCL='V';
const char BBCM=10;
const char R_ACTION='^';
const char R_ERROR='*';
const char R_INVALID='!';
const char R_NO_DATA='+';
const char R_COMAND_ERROR='?';
const char R_START=':';
const char R_POSITION1='q';
const char R_POSITION2='s';
const char R_NO_MAG_CARD='>';
const char R_MAG_DETECT_ON='(';
const char R_MAG_DETECT_OFF=')';
char inByte;
char Comando=' ';
char command[9];

uint8_t rx_buffer[255];

int Contador=0;

PwmOut led(LED1);
DigitalOut   CardReaderPower(PF_3);
DigitalOut   Max232(PC_8);


void Interrupt_CardReader()
{
    rx_buffer[Contador]=CardReader.getc();
    Contador++;
}

int main()
{
    CardReader.attach(&Interrupt_CardReader);

    Computer.printf("\n--------------------------");
    Computer.printf("\n a--> On");
    Computer.printf("\n A--> Card Position");
    Computer.printf("\n B--> Card Lock");
    Computer.printf("\n C--> Card Unlock");
    Computer.printf("\n D--> Device Status");
    Computer.printf("\n E--> Arm Mode");
    Computer.printf("\n F--> Arm Debug");
    Computer.printf("\n G--> Arm Abort");
    Computer.printf("\n H--> Get Custom");
    Computer.printf("\n I--> Reset");
    Computer.printf("\n J--> Get Iso T1");
    Computer.printf("\n K--> Get Iso T2");
    Computer.printf("\n L--> Get Iso T3");
    Computer.printf("\n--------------------------");
    CardReaderPower=0;
    Max232=0;

    while(1) {
        if (Computer.readable()) {
            Comando=Computer.getc();
            Contador=0;
            if(Comando=='a') {
                Computer.printf("\n a--> On");
                CardReaderPower=1;
                Max232=1;              // 00111101 --> XOR bytes anteriores
            }
            if(Comando=='b') {
                Computer.printf("\n a--> off max");
                Max232=0;              // 00111101 --> XOR bytes anteriores
            }
            if(Comando=='c') {
                Computer.printf("\n a--> off card");
                CardReaderPower=0;              // 00111101 --> XOR bytes anteriores
            }
            if(Comando=='A') {
                Computer.printf("\n A--> Card Position");// ENVIO      S2 S1      S1
                CardReader.putc(SOH);               // 00000001   00000001   00000001
                CardReader.putc(ADDR);              // 00000000   00000000   00000000
                CardReader.putc(LEN);               // 00000000   00000000   00000000
                CardReader.putc(LEN);               // 00000000   00000001   00000001
                CardReader.putc(CARD_POSITION);     // 00111000   01110011   01110001
                CardReader.putc(EOT);               // 00000100       s          q
                CardReader.putc(BBCA);              // 00111101   01110011   01110001
            }
            if(Comando=='B') {
                Computer.printf("\n B--> Card Lock");    // ENVIO      EXITO      FALLO
                CardReader.putc(SOH);               // 00000001   00000001   00000001
                CardReader.putc(ADDR);              // 00000000   00000000   00000000
                CardReader.putc(LEN);               // 00000000   00000000   00000000
                CardReader.putc(LEN);               // 00000000   00000001   00000001
                CardReader.putc(CARD_LOCK);         // 01111011   01011110
                CardReader.putc(EOT);               // 00000100       ^
                CardReader.putc(BBCB);              // 01111110   01011110
            }
            if(Comando=='C') {
                Computer.printf("\n C--> Card Unlock");  // ENVIO      EXITO     FALLO
                CardReader.putc(SOH);               // 00000001   00000001  00000001
                CardReader.putc(ADDR);              // 00000000   00000000  00000000
                CardReader.putc(LEN);               // 00000000   00000000  00000000
                CardReader.putc(LEN);               // 00000000   00000001  00000001
                CardReader.putc(CARD_UNLOCK);       // 01111101   01011110
                CardReader.putc(EOT);               // 00000100       ^
                CardReader.putc(BBCC);              // 01111000   01011110
            }
            if(Comando=='D') {
                Computer.printf("\n D--> Device Status");// ENVIO
                CardReader.putc(SOH);               // 00000001
                CardReader.putc(ADDR);              // 00000000
                CardReader.putc(LEN);               // 00000000
                CardReader.putc(LEN);               // 00000000
                CardReader.putc(DEV_STATUS);        // 00100100
                CardReader.putc(EOT);               // 00000100
                CardReader.putc(BBCD);              // 00100001
            }
            if(Comando=='E') {
                Computer.printf("\n E--> Arm Mode");     // ENVIO      ACTIVADO   ERROR
                CardReader.putc(SOH);               // 00000001   00000001   00000001
                CardReader.putc(ADDR);              // 00000000   00000000   00000000
                CardReader.putc(LEN);               // 00000000   00000000   00000000
                CardReader.putc(LEN);               // 00000000   00000001   00000001
                CardReader.putc(ARM_MODE);          // 01010000   01011110   00100001
                CardReader.putc(EOT);               // 00000100
                CardReader.putc(BBCE);              // 01010101   01011110   00100001
            }
            if(Comando=='F') {
                Computer.printf("\n F--> Arm Debug");    // ENVIO      EXITO      NO_MAG_C   DET_ON     DET_OFF
                CardReader.putc(SOH);               // 00000001   00000001   00000001   00000001   00000001
                CardReader.putc(ADDR);              // 00000000   00000000   00000000   00000000   00000000
                CardReader.putc(LEN);               // 00000000   00000000   00000000   00000000   00000000
                CardReader.putc(LEN);               // 00000000   00000001   00000001   00000001   00000001
                CardReader.putc(ARM_DEBUG);         // 01110000   01011110   00111110   00101000   00101001
                CardReader.putc(EOT);               // 00000100       ^          >          (          )
                CardReader.putc(BBCF);              // 01110101   01011110   00111110   00101000   00101001
            }
            if(Comando=='G') {
                Computer.printf("\n G--> Arm Abort");    // ENVIO      EXITO      ERROR
                CardReader.putc(SOH);               // 00000001   00000001   00000001
                CardReader.putc(ADDR);              // 00000000   00000000   00000000
                CardReader.putc(LEN);               // 00000000   00000000   00000000
                CardReader.putc(LEN);               // 00000000   00000001   00000001
                CardReader.putc(ARM_ABORT);         // 00011010   01011110   01011110
                CardReader.putc(EOT);               // 00000100       ^          *
                CardReader.putc(BBCG);              // 00011111   01011110   00101010
            }
            if(Comando=='H') {
                Computer.printf("\n H--> Get Custom");
                CardReader.putc(SOH);               // 00000001
                CardReader.putc(ADDR);              // 00000000
                CardReader.putc(LEN);               // 00000000
                CardReader.putc(LEN);               // 00000000
                CardReader.putc(MAG_CUSTOM_T1);     // 01010101
                CardReader.putc(MAG_CUSTOM_F);      // 00110100
                CardReader.putc(EOT);               // 00000100
                CardReader.putc(BBCH);              // 01100100 --> XOR bytes anteriores
            }
            if(Comando=='I') {
                Computer.printf("\n I--> Reset");
                CardReader.putc(SOH);               // 00000001
                CardReader.putc(ADDR);              // 00000000
                CardReader.putc(LEN);               // 00000000
                CardReader.putc(LEN);               // 00000000
                CardReader.putc(DEV_RESET);         // 01111111
                CardReader.putc(EOT);               // 00000100
                CardReader.putc(BBCI);              // 01111010 --> XOR bytes anteriores
            }
            if(Comando=='J') {
                Computer.printf("\n J--> Get Iso T1");
                CardReader.putc(SOH);               // 00000001
                CardReader.putc(ADDR);              // 00000000
                CardReader.putc(LEN);               // 00000000
                CardReader.putc(LEN);               // 00000000
                CardReader.putc(MAG_ISO_T1);        // 01010001
                CardReader.putc(EOT);               // 00000100
                CardReader.putc(BBCJ);              // 01010100 --> XOR bytes anteriores
            }
            if(Comando=='K') {
                Computer.printf("\n K--> Get Iso T2");
                CardReader.putc(SOH);               // 00000001
                CardReader.putc(ADDR);              // 00000000
                CardReader.putc(LEN);               // 00000000
                CardReader.putc(LEN);               // 00000000
                CardReader.putc(MAG_ISO_T2);        // 01010010
                CardReader.putc(EOT);               // 00000100
                CardReader.putc(BBCK);              // 01010111 --> XOR bytes anteriores
            }
            if(Comando=='L') {
                Computer.printf("\n L--> Get Iso T3");
                CardReader.putc(SOH);               // 00000001
                CardReader.putc(ADDR);              // 00000000
                CardReader.putc(LEN);               // 00000000
                CardReader.putc(LEN);               // 00000000
                CardReader.putc(MAG_ISO_T3);        // 01010011
                CardReader.putc(EOT);               // 00000100
                CardReader.putc(BBCL);              // 01010110 --> XOR bytes anteriores
            }

            Computer.printf("\n--------------------------");
            Computer.printf("\n a--> On");
            Computer.printf("\n A--> Card Position");
            Computer.printf("\n B--> Card Lock");
            Computer.printf("\n C--> Card Unlock");
            Computer.printf("\n D--> Device Status");
            Computer.printf("\n E--> Arm Mode");
            Computer.printf("\n F--> Arm Debug");
            Computer.printf("\n G--> Arm Abort");
            Computer.printf("\n H--> Get Custom");
            Computer.printf("\n I--> Reset");
            Computer.printf("\n J--> Get Iso T1");
            Computer.printf("\n K--> Get Iso T2");
            Computer.printf("\n L--> Get Iso T3");
            Computer.printf("\n--------------------------");
            wait(5);
        }
        
        if(Contador!=0) {
            for(int i=0; i<=Contador; i++) {
                Computer.printf("-%#X-",rx_buffer[i]);
            }
            Computer.printf("--C--%i \n",Contador);
            for(int i=0; i<=Contador; i++) {
                Computer.printf("-%c-",rx_buffer[i]);
            }
            Computer.printf("--C--%i",Contador);
            Contador=0;
        }
    }
}

