#include "BatteryPanel.h"
#include "mbed.h"

float ValorLectura;
float ValorCalculado;

BATTERY_PANEL::BATTERY_PANEL(PinName AnalogBattery, PinName AnalogPanel, PinName Control) : _AnalogBattery(AnalogBattery), _AnalogPanel(AnalogPanel), _Control(Control)
{
    _Control = 0;
}

float BATTERY_PANEL::BatteryRead()
{
    ValorLectura = _AnalogBattery.read(); // Read the analog input value (value from 0.0 to 1.0 = full ADC conversion range)
    ValorCalculado = ValorLectura*21.8;    // Converts value in the 0V-3.3V range       
    return ValorCalculado;
}

float BATTERY_PANEL::PanelRead()
{
    ValorLectura = _AnalogPanel.read();   // Read the analog input value (value from 0.0 to 1.0 = full ADC conversion range)
    ValorCalculado = ValorLectura*21.7;    // Converts value in the 0V-3.3V range
    return ValorCalculado;
}

float BATTERY_PANEL::BatteryAnalog()
{
    ValorLectura = _AnalogBattery.read(); // Read the analog input value (value from 0.0 to 1.0 = full ADC conversion range)
    ValorCalculado = ValorLectura*3.3;    // Converts value in the 0V-3.3V range       
    return ValorCalculado;
}

float BATTERY_PANEL::PanelAnalog()
{
    ValorLectura = _AnalogPanel.read();   // Read the analog input value (value from 0.0 to 1.0 = full ADC conversion range)
    ValorCalculado = ValorLectura*3.3;    // Converts value in the 0V-3.3V range
    return ValorCalculado;
}

int BATTERY_PANEL::Control()
{
    ValorLectura = _AnalogBattery.read(); // Read the analog input value (value from 0.0 to 1.0 = full ADC conversion range)
    ValorCalculado = ValorLectura*21.8;

    if(ValorCalculado>15){
        _Control=0;
        return 2;
    } else {
        _Control=1;
    }
    if(ValorCalculado<12){
        return 0;
    } 
    //_Control=!_Control;
    return 1;
}

void BATTERY_PANEL::ControlOff(){
    _Control=0;
}

void BATTERY_PANEL::ControlOn(){
    _Control=1;
}


