#include "mbed.h"
#include "rtos.h"
#include "TextLCD.h"
#include <time.h>

TextLCD lcd(p15,p16,p17,p18,p19,p20,TextLCD::LCD16x2);
Serial pc(USBTX, USBRX); //set up serial
DigitalOut natAPace(LED1); //leds for pacing
DigitalOut natVPace(LED2);
DigitalOut aPace(LED3);
DigitalOut vPace(LED4);
DigitalOut alarm(p5); //pin for alarm

InterruptIn a_Pace(p8);
InterruptIn v_Pace(p9);

DigitalOut a_signal(p6); //connected to pm
DigitalOut v_signal(p7); //connected to pm

unsigned volatile int a_time = 0;
unsigned volatile int v_time = 0;

int mode = 0; //0 = random, 1 = manual, 2 = test
int changeModes = 0;

//constants

const int minwait_A = 10; //all in msec
const int minwait_V = 20;
const int LRI = 1000;
const int VRP = 400;
const int PVARP = 500;
const int URI = 1000;
const int AVI = 100;



void send_aSignal() {
    a_signal = 1;
    natAPace = 1;
    wait(1);
    a_signal = 0;
    natAPace = 0;
}

void send_vSignal() {
    v_signal = 1;
    natVPace = 1;
    wait(1);
    v_signal = 0;   
    natVPace = 0;
}

void test_mode() {
    
}

void random_mode() {
    pc.printf("in Random Mode");
    while(mode == 0) { //only running while in random mode
       
        int aWait = rand()%2000 + minwait_A;
        pc.printf("a wait: %d\n", aWait);
        int vWait = rand()%2000 + minwait_V;
        pc.printf("v wait: %d\n", vWait);
        
        //wait for time to go
        pc.printf("going into a while loop");
        a_time = 0;
        while(a_time < aWait);
        pc.printf("left a while loop");
        send_aSignal();
        vWait += v_time; //get current timeV
        //wait for v_time
        pc.printf("going into v while loop");
        v_time = 0;
        while(v_time < vWait) {continue;}
        pc.printf("left v while loop");
        send_vSignal();
        v_time = 0;
    }
}

void switch_modes() {
    while(true) {
        if(changeModes) {
            pc.printf("passed if statement");
            switch(mode) {
                case 0: //becomes random
                    pc.printf("in random");
                    changeModes = 0;
                    random_mode();
                    break;
                case 1: //becomes manual
                    pc.printf("in manual");
                    changeModes = 0;
                    //don't need to do anything
                    break;
                case 2: //becomes test
                    pc.printf("in test");
                    changeModes = 0;
                    test_mode();
                    break;
                
            }
            //thread switch modes delay
            Thread::wait(1000);
        }
    }    

}


void received_apace() {
    //TODO: DO 
    aPace = 1;
}

void received_vpace() {
    //TODO: DO
    vPace = 1;
}

void heart_keyboard() {
    while(true) { //thread is continuously running
            if(pc.readable()) {
                char c = pc.getc();
                switch(c) {
                    case 'r': //set to random mode
                        pc.printf("setting random mode");
                        mode = 0;
                        changeModes = 1;
                        break;
                    case 'm': //set to manual mode
                        pc.printf("setting manual mode");
                        mode = 1;
                        changeModes = 1;
                        break;
                    case 't': //set to test mode
                        pc.printf("setting test mode");
                        mode = 2;
                        changeModes = 1;
                        break;
                    case 'a': //asignal
                        if(mode) { //only if in manual (heart_mode == 1)
                            pc.printf("pacing a manual");
                            send_aSignal();
                        }
                        break;
                    case 'v': //vsignal
                        if(mode) { //only if in manual (heart_mode == 1)
                            pc.printf("pacing v manual");
                            send_vSignal();
                        }
                        break; 
                    default: //erroneous key get rid of it
                        break;
                }
            }
    }
}

void tick() {
    while(true) {
        a_time++;  
        v_time++;
        Thread::wait(1);
    } 
}


int main() {
    //TODO: Set up threads
    srand(time(NULL));
    pc.printf("setting up serial");
    a_Pace.rise(&received_apace);
    v_Pace.rise(&received_vpace);
    
    Thread* keyboard = new Thread(heart_keyboard);
    Thread* ticker = new Thread(tick, osPriorityHigh);
    Thread* mode = new Thread(switch_modes);
    
}
