#include "objectQueue.h"

StrQueue::StrQueue() {
    chars = (char*)malloc(sizeof(char[1]));
    lock = new Mutex();
    size = 1;
    front = 0;
    back = 0;
    empty = true;
    full = false;
}

StrQueue::StrQueue(int size) {
    chars = (char*)malloc(sizeof(char[size]));
    size = size;
    front = 0;
    back = 0;
    empty = true;
    full = false;
}

StrQueue::~StrQueue(void) {
    free(chars);
}

int StrQueue::put(const char* message, int length) {
    lock->lock();
    int i;
    if (length == 0) {
        for (i = 0; empty||(front != (back+i)%size); i++) {
            if ((chars[back + i] = message[i]) == '\0') {
                back = (back + i + 1)%size;
                empty = false;
                if (front == back) {
                    full = true;   
                }
                lock->unlock();
                return(i);
            }
        }
        if (front == back) {
            full = true;   
        }
        lock->unlock();
        return(0);
    }
    else {
        if ((back - front)%size <= length) {
            lock->unlock();
            return(0);
        }
        for (i = 0; empty||(i <= length); i++) {
            chars[back + i] = message[i];
        }  
        back = (back + i + 1)%size;
        empty = false;
        if (front == back) {
            full = true;   
        }
        lock->unlock();
        return(i);
    }
}

int StrQueue::get(char* out, int length) {
    lock->lock();
    int i = 0;
    if (empty) {
        lock->unlock();
        return(0);   
    }
    for (i = 0;; i++) {
        if (i > length) {
            strncpy(out, "", length);
            return(0);
        }
        if ((out[i] = chars[(front + i)%size]) == '\0') {
            front = (front + i + 1)%size;
            break;  
        }
    }
    if (front == back) {
        empty = true;
    }
    lock->unlock();
    
    return(i);
}
 
int StrQueue::getChars(char* buffer, int size) {
    int ret = 0, total = 0;
    lock->lock();
    if (empty) {return(0);}
    while ((ret = get(buffer + ret, size - total)) > 0) {
        buffer += ret;
        total++;
        ret = 0;
    }
    lock->unlock();
    return(total);
}

bool StrQueue::isfull() {
    return(full);
}

bool StrQueue::isEmpty() {
    return(empty);    
} 