#ifndef __WIFI_INCLUDED__
#define __WIFI_INCLUDED__

#define DEBUG
#define DELAY 15
#define BUFFERSIZE 256
#define QUEUESIZE 1024
#define CONNECTDELAY 3000
#define SOCKETTIMEOUT 5000

#include "mbed.h"
#include "TCPSocket.h"
#include "ESP8266Interface.h"
#include "objectQueue.h"
#include "commands.h"
#include <string>
#include <sstream>

class Wifi : public ESP8266Interface{
private:
    Thread wifi_thread;
    TCPSocket *sender, *receiver;
    int port;
    char host[15]; 
    
    DigitalOut ch_pd, rst;
    
    StrQueue sendQueue;
    StrQueue recvQueue;
    
    char rbuffer[BUFFERSIZE];
    char ssbuffer[BUFFERSIZE];
    char srbuffer[BUFFERSIZE];

    bool sendConnected, recvConnected;
    int sendState, recvState;
    bool sendReady, recvReady;
    
    void run();
    int connectWifi();
    int connectSockets();

public:
    Wifi(osPriority, int);
    void start();
    int send(string message);
    int send(char* message);
    int send(int message);
    
    Message recv();
};

#endif