#include "wifi.h"

Wifi::Wifi(osPriority priority, int memory) : ESP8266Interface(D8, D2, false), ch_pd(D3, 1), rst(D4, 1)
{
    set_credentials("denver", "11111111", NSAPI_SECURITY_WPA_WPA2);
    
    sender = new TCPSocket::TCPSocket();
    receiver = new TCPSocket::TCPSocket();
    
    sender->open(this);
    receiver->open(this);

    wifi_thread = new Thread(priority, memory);

    sendQueue = StrQueue(QUEUESIZE);
    recvQueue = StrQueue(QUEUESIZE);

    sendConnected = false;
    recvConnected = false;
    sendReady = false, recvReady = false;
    sendState = 0, recvState = 0;
}

void Wifi::start()
{
#ifdef DEBUG
    Thread::wait(10);
    Serial::Serial(USBTX, USBRX).printf("Wifi starting\n");
#endif
    wifi_thread.start(callback(this, &Wifi::run));
}

void Wifi::run()
{
    int ret = -1, recvLength;
    sender->set_blocking(false);

    Timer sendConnectTimer, sendSocketTimer, recvConnectTimer, recvSocketTimer;

    connectWifi();

    connectSockets();

    while(true) {
        //Serial::Serial(USBTX, USBRX).printf("RSSI: %i\n", getRSSI("denver"));

        Thread::wait(DELAY);

        if (!sendConnected) {
            if (sendConnectTimer.read_ms() > CONNECTDELAY) {
                sendConnectTimer.stop();
                sendConnectTimer.reset();
                connectSockets();
                if (!sendConnected) {
                    sendConnectTimer.start();
                }
            } else {
                sendConnectTimer.start();
            }
        } else {
            switch (sendState) {
                case 0:
                    if (sendQueue.getChars(ssbuffer, BUFFERSIZE) > 0) {
                        sendState = 1;
                    } else {
                        break;
                    }

                case 1:
                    Thread::wait(DELAY);
                    ret = sender->send(ssbuffer, BUFFERSIZE);
#ifdef DEBUG
                    Thread::wait(DELAY);
                    Serial::Serial(USBTX, USBRX).printf("Sender send return code: [%d]\n", ret);
#endif
                    if(ret > 0) {
                        sendState = 2;
                    } else if(ret == -3012) {
                        sendState = 0;
                        sendConnected = false;
                        break;
                    } else if(ret == -3001) {
                        if(sendSocketTimer.read_ms() > SOCKETTIMEOUT) {
                            sendSocketTimer.reset();
                            sendSocketTimer.stop();
                            sendConnected = false;
                        } else {
                            sendSocketTimer.start();
                        }
                        break;
                    } else {
                        break;
                    }

                case 2:
                    strcpy(srbuffer, "");
                    Thread::wait(DELAY);
                    ret = sender->recv(srbuffer, BUFFERSIZE);
#ifdef DEBUG
                    Thread::wait(DELAY);
                    Serial::Serial(USBTX, USBRX).printf("Sender recv return code: [%d]\n", ret);
#endif
                    if(ret > 0) {
                        sendSocketTimer.reset();
                        sendSocketTimer.stop();
                        if (strcmp(srbuffer, ssbuffer)==0) {
                            sendState = 0;
                        } else {
                            sendState = 1;
                        }
                    } else if(ret == -3012) {
                        sendSocketTimer.reset();
                        sendSocketTimer.stop();
                        sendConnected = false;
                        sendState = 0;
                        break;
                    } else if(ret == -3001) {
                        if(sendSocketTimer.read_ms() > SOCKETTIMEOUT) {
                            sendSocketTimer.reset();
                            sendSocketTimer.stop();
                            sendConnected = false;
                        } else {
                            sendSocketTimer.start();
                        }
                        break;
                    }
                    break;
            }
        }

        if (!recvConnected) {
            if (recvConnectTimer.read_ms() > CONNECTDELAY) {
                recvConnectTimer.stop();
                recvConnectTimer.reset();
                connectSockets();
                if (!recvConnected) {
                    recvConnectTimer.start();
                }
            } else {
                recvConnectTimer.start();
            }
        } else {
            switch (recvState) {
                case 0:
                    strcpy(rbuffer, "");
                    Thread::wait(DELAY);
                    recvLength = receiver->recv(rbuffer, BUFFERSIZE);
                    //receiver->recv(srbuffer, BUFFERSIZE);
                    //Thread::wait(DELAY*10);
                    //if(strcmp(rbuffer, "10")==0) {
                    //printf("Receiver: [%s]\n", rbuffer);
                    //}
#ifdef DEBUG
                    Thread::wait(DELAY);
                    Serial::Serial(USBTX, USBRX).printf("Receiver recv return code: [%d]\n", recvLength);
#endif

                    if(recvLength > 0) {
                        recvSocketTimer.reset();
                        recvSocketTimer.stop();
                        recvState = 1;
                    } else if(recvLength == -3012) {
                        recvSocketTimer.reset();
                        recvSocketTimer.stop();
                        recvConnected = false;
                        recvState = 0;
                        break;
                    } else if(recvLength == -3001) {
                        if(recvSocketTimer.read_ms() > SOCKETTIMEOUT) {
                            recvSocketTimer.reset();
                            recvSocketTimer.stop();
                            recvConnected = false;
                            recvState = 0;
                        } else {
                            recvSocketTimer.start();
                        }
                        break;
                    } else {
                        break;
                    }


                case 1:
                    Thread::wait(DELAY);
                    ret = receiver->send(rbuffer, recvLength);
#ifdef DEBUG
                    Thread::wait(DELAY);
                    Serial::Serial(USBTX, USBRX).printf("Receiver send return code: [%d]\n", ret);
#endif
                    if(ret > 0) {
                        recvState = 2;
                    } else if(ret == -3012) {
                        recvState = 0;
                        recvConnected = false;
                        break;
                    } else if(ret == -3001) {
                        if(recvSocketTimer.read_ms() > SOCKETTIMEOUT) {
                            recvSocketTimer.reset();
                            recvSocketTimer.stop();
                            recvConnected = false;
                        } else {
                            recvSocketTimer.start();
                        }
                        break;
                    } else {
                        break;
                    }

                case 2:
                    if (recvQueue.put(rbuffer, recvLength) > 0) {
                        recvState = 0;
                        break;
                    } else {
                        break;
                    }
            }
        }
    }
}

int Wifi::connectWifi()
{
    int ret;
    while(true) {
        Thread::wait(DELAY);
#ifdef DEBUG
        Thread::wait(5);
        Serial::Serial(USBTX, USBRX).printf("Wifi connecting\n");
#endif
        ret = connect();
        Thread::wait(DELAY);
        Serial::Serial(USBTX, USBRX).printf("Wifi connect ret code: [%d]\n", ret);

        if (ret == 0) {
            Thread::wait(DELAY);
#ifdef DEBUG
            Thread::wait(DELAY);
            Serial::Serial(USBTX, USBRX).printf("Wifi connected\n");
#endif
            break;
        } else {
            Thread::wait(DELAY);
#ifdef DEBUG
            Thread::wait(DELAY);
            Serial::Serial(USBTX, USBRX).printf("Wifi connect ret code: [%d]\n", ret);
#endif
        }
    }
    Thread::wait(5);
    return(1);
}

int Wifi::connectSockets()
{
    int ret;
#ifdef DEBUG
    Thread::wait(DELAY);
    Serial::Serial(USBTX, USBRX).printf("Sockets connecting\n");
#endif
    if(!sendConnected) {
        Thread::wait(5);
        ret = sender->connect("192.168.173.1", 5001);
        Thread::wait(5);
#ifdef DEBUG
        Thread::wait(DELAY);
        Serial::Serial(USBTX, USBRX).printf("Send connect Ret: [%i]\n", ret);
#endif
        if (ret == 0) {
            sendConnected = true;
            sender->set_blocking(false);
        }
        //else if (ret == -3012) {connectWifi();}
    }

    if(!recvConnected) {
        Thread::wait(5);
        ret = receiver->connect("192.168.173.1", 5000);
        Thread::wait(5);
#ifdef DEBUG
        Thread::wait(DELAY);
        Serial::Serial(USBTX, USBRX).printf("Receiver connect Ret: [%i]\n", ret);
#endif
        if (ret == 0) {
            recvConnected = true;
            receiver->set_blocking(false);
        }
    }//else if (ret == -3012) {connectWifi();}
    return(0);
}

int Wifi::send(string message)
{
    return(sendQueue.put(message.c_str(), message.length()));
}

int Wifi::send(char* message)
{
    return(sendQueue.put(message, strlen(message)));
}

union i_to_c {
    int i;
    char c[4];
};

int Wifi::send(int message)
{
    i_to_c m;
    m.i = message;
    return(sendQueue.put(m.c, strlen(m.c)));
}

Message Wifi::recv()
{
    Message out;
    char str[44];
    int ret = recvQueue.get(str, 44);
    if(ret > 0) {
        out.parse(str);
    }
    return(out);
}