#include "mbed.h"
#include "wifi.h"
#include "lift.h"
#include "drive.h"
#include "pathfinding.h"
#include "positioning.h"

Serial pc(SERIAL_TX, SERIAL_RX);
DigitalOut led2(LED2);

Wifi wifi;
Lift lift;
Drive drive;
Pathfinding pathfinding;
Positioning positioning;

int main() {
    /* Starts other threads*/
    wifi.start(osPriorityHigh, 8000);
    lift.start(osPriorityLow, 8000);
    drive.start(osPriorityHigh, 1000);
    pathfinding.start(osPriorityLow, 8000);
    positioning.start(osPriorityLow, 1000);
    
    while(true) {
        Thread::wait(100);
    }
}