#ifndef __DRIVE_INCLUDED__
#define __DRIVE_INCLUDED__

#include "mbed.h"
#include "pid_controller.h"

#define PWMPERIOD 4096 //PWM period in us

#define KP 3
#define KI 0.1
#define KD 0.1
#define PIDSAMPLERATE 0.1

class Driver {
private:
    PIDControl pidR;
    PIDControl pidL;

    InterruptIn l_encoder1; //Left motor encoder signal 1
    InterruptIn l_encoder2;   //Left motor encoder signal 2
    InterruptIn r_encoder1; //Right motor encoder signal 3
    InterruptIn r_encoder2;   //Right motor encoder signal 4
    
    PwmOut left_motor; // Forward Motor direction
    PwmOut left_motor_rev; // Reverse Motor direction
    PwmOut right_motor; // Forward Motor direction
    PwmOut right_motor_rev; // Reverse Motor direction

    long lSpeedGoal;//Goal motor speed
    long rSpeedGoal;
    
    long l_RPM;//Measured current speed
    long r_RPM;
    
    Mutex lock;
    
    Thread driver_thread;
    
    unsigned int LoutA; //Holds left output A of encoder signal
    unsigned int LoutB; //Holds left output B of encoder signal
    unsigned int RoutA; //Holds Right output A of encoder signal
    unsigned int RoutB; //Holds Right output B of encoder signal
    
    unsigned char l_enc_val; //Sequence that holds current and previous encoder combination values
    unsigned char r_enc_val;
    char l_enc_direction;
    char r_enc_direction;
    volatile long l_enc_count; //Holds current direction of left motor
    volatile long r_enc_count; //Holds current direction of right motor
    
    //Ticker timer;
    volatile long l_old_enc_count; //Hold old encounter value for computation
    volatile long r_old_enc_count;

    void l_encode_trig();//function for handling encoder trigger
    void r_encode_trig();
    
    void run();//function to run in thread (contains infinite loop)
    
    
    DigitalOut my_led;
    
public:
    Driver(osPriority, int);
    void start(); //starts thread "pid" running run()
    //void setVelocity(int speed, char* directoin);//called to set desired speed
    void setVelocity(int lSpeed, int rSpeed);
};

#endif