#ifndef __COMMANDS__
#define __COMMANDS__

#include "mbed.h"

enum argumentType {
    BLANK = -1,
    DECIMAL,
    INTEGER,
    CHARACTERS
};


/*
DRIVE: INTEGER lSpeed, INTEGER rSPeed
LED: INTEGER on
*/
enum command {
    VOID = -1,
    DRIVE = 0,
    LED,
    TOTAL_COMMANDS
};

struct argument {
    union {
        float decimal;
        int integer;
        char characters[8];
    };
    argumentType type;
};

const char commandStrings[2][8] = {"DRIVE", "LED"};

const argumentType commandArgTypes[2][4] = {
    {INTEGER, INTEGER, BLANK, BLANK},
    {INTEGER, BLANK, BLANK, BLANK}
};

class Message {
private:
    command cmd;
    argument arguments[4];
public:
    Message();
    Message(char[44]);
    bool parse(const char[44]);
    command getCommand();
    argument getArg(int ind, argumentType expectedType);
};

#endif