#include "commands.h"

Message::Message(){
    cmd = VOID;
    for (int i = 0; i < 4; i++) {
        strcpy(arguments[i].characters, "");
        arguments[i].type = BLANK;
    }
}

Message::Message(char str[44]){
    cmd = VOID;
    for (int i = 0; i < 4; i++) {
        strcpy(arguments[i].characters, "");
        arguments[i].type = BLANK;
    }
    parse(str);
}

bool Message::parse(const char str[44]){
    char args[5][8] = {};
    int argIndex = 0, ind = 0;
    for (int i = 0; i < 44; i++) {  
        if (str[i] == '$') {
            args[argIndex][ind] = '\0';
            argIndex++;
            ind = 0;
        }
        else if (str[i] == '\0') {
            args[argIndex][ind] = '\0';
            break;   
        }
        else {
            if (ind > 7) {
                return(false);   
            }
            else {
                args[argIndex][ind] = str[i];
                ind++;
            }
        }
    }
    cmd = VOID;
    for (int i = 0; i < TOTAL_COMMANDS; i++) {
        if (strcmp(args[0], commandStrings[i]) == 0) {
            cmd = (command)i;
        }
    }
    
    for (int i = 0; i < 4; i++) {
        switch(arguments[i].type = commandArgTypes[cmd][i]) {
            case DECIMAL:
                arguments[i].decimal = atof(args[i+1]);
                break;
            case INTEGER:
                arguments[i].integer = atoi(args[i+1]);
                break;
            case CHARACTERS:
                strcpy(arguments[i].characters, args[i+1]);
                break;
        } 
    }
    return(true);
}

command Message::getCommand(){
    return(cmd);
}

argument Message::getArg(int ind, argumentType expectedType){
    if (expectedType == arguments[ind].type) {
        return(arguments[ind]);
    }
    else {
        argument blankArg;
        blankArg.type = BLANK;
        strcpy(blankArg.characters, "");
        return(blankArg);
    }
}