//
//OutrageousPWM
//
// Control characters are used so there is no restriction on text characters that can be used for serial messages.
// Test for the control characters to reset the mBuino and for setting the PWM values

//Use USB Library Device stack

#include "mbed.h"
#include "USBSerial.h"
#include <string>


DigitalOut LED[] = {(LED1), (LED2), (LED3), (LED4), (LED5), (LED6), (LED7)};// declare 7 LEDs


 //Virtual serial port over USB
 USBSerial serial;

/*
 Serial pc(USBTX, USBRX);
 DigitalOut led1(LED1);
 DigitalOut led2(LED2);
 DigitalOut led3(LED3);
 DigitalOut led4(LED4);
 DigitalOut led5(LED5);
 DigitalOut led6(LED6);
 DigitalOut led7(LED7);
 pwmEdge.rise(&showEdgeHigh);
 pwmEdge.fall(&showEdgeLow);
*/


 //Create interrupt input
 InterruptIn pwmEdge(P0_21);

 //create PWM outputs
 PwmOut PWM1(P0_18);
 PwmOut PWM2(P0_19);
 PwmOut PWM3(P1_15);
 
 //create output pin to display interrupt state event
 DigitalOut led7(LED7);
 
 float Period1;
 float DutyCycle1;
 float Period2;
 float DutyCycle2;
 float Period3;
 float DutyCycle3;

//Event
void onEdgeHigh() {
    led7 = 1;
}
//

//Event
void onEdgeLow() {
    led7 = 0;
}
//

int main() {
    
    reset: //Here on Reset request..
    
    for(int i = 0; i < 7; i++) // turn all led's off
    {
        LED[i].write(0);
    }
    //
    
    //Display we have started...
    for(int i = 0;i < 7;i++) {
        LED[i].write(1);
        wait(0.2);
        LED[i].write(0);
    }
    
    for(int i = 6;i >= 0;i--) {
        LED[i].write(1);
        wait(0.2);
        LED[i].write(0);
    }
    
    
    //Test 1kHz 70% (0.999 kHz)
    Period1 = 0.01;
    DutyCycle1 = 0.3;
    
    //Test 1kHz 50% (0.999 kHz)
    Period2 = 0.001;
    DutyCycle2 = 0.5;
    
    //Test 979.4 kHz
    Period3 = 0.000001;
    DutyCycle3 = 0.5; //51%
    
    //Set some defaults
    PWM1.period(Period1);
    PWM1=DutyCycle1;
    
    PWM2.period(Period2);
    PWM2=DutyCycle2;
    
    PWM3.period(Period3);
    PWM3=DutyCycle3;
    
    while(1)
    {       
        if(serial.readable()) {
                
            //Control Characters are received as Decimal ASCII
            
            char str[60];
            serial.gets(str, 60);
            serial.puts(str);
            //Indicate we have received/returned data
            LED[3].write(1);
            wait(0.2);
            LED[3].write(0);
        
            //Get PWM (or other) to use and the value from string
            //The first three characters tell us what PwmOut to use
            //The remaining characters are the value to use
            
            int len = strlen(str);
            string s2 = string(str).substr(3, len - 3);
            //serial.printf("s:  %s   Len: %d \r\n", str, len);
            
            //Warning: Non-POD class type passed through ellipsis in "main.cpp"
            //serial.printf("part:  %s \r\n", s2); //<< My original code causing error
            //serial.printf("part:  %s \r\n", s2.c_str());  //<< taylorza provided this and saved my day
            
            
            //Control Character 10 = DLE (P0_21)
            //Interrupt input pin
            if(str[0] == '1' && str[1] == '0') {
                if(str[2] == '1') {
                    pwmEdge.rise(&onEdgeHigh); //Event
                }
                else if(str[2] == '0') {
                    pwmEdge.fall(&onEdgeLow); //Event
                }
                //Disable events
                else if(str[2] == '2') {
                    pwmEdge.rise(NULL);
                    pwmEdge.fall(NULL);
                }
                //
            }
            //
                
            //Control Character 18 = DC2 (PwmOut PWM1(P0_18))
            else if(str[0] == '1' && str[1] == '8') {
                if(str[2] == 'd') {
                    DutyCycle1 = atof(s2.c_str());
                    PWM1=DutyCycle1;
                }
                else if(str[2] == 'p') {
                    Period1 = atof(s2.c_str());
                    PWM1.period(Period1);
                }
                //
            }
            //
            
            //Control Character 19 = DC3 (PwmOut PWM2(P0_19))
            else if(str[0] == '1' && str[1] == '9') {
                if(str[2] == 'd') {
                    DutyCycle2 = atof(s2.c_str());
                    PWM2=DutyCycle2;
                }
                else if(str[2] == 'p') {
                    Period2 = atof(s2.c_str());
                    PWM2.period(Period2);
                }
                //
            }
            //
            
            //Control Character 20 = DC4 (PwmOut PWM3(P1_15))
            else if(str[0] == '2' && str[1] == '0') {
                if(str[2] == 'd') {
                    DutyCycle3 = atof(s2.c_str());
                    PWM3=DutyCycle3;
                }
                else if(str[2] == 'p') {
                    Period3 = atof(s2.c_str());
                    PWM3.period(Period3);
                }
                //
            }
            //
            
            //Control Character 17 = DC1
            //Reset the mBuino - (Assuming serial can read)
            else if(str[0] == '1' && str[1] == '7') {
                goto reset;
            } //if
            
        } //if serial.readable()      
    } //while
} //main
//
