#include "mbed.h"
#include "MODSERIAL.h"

PwmOut pwm_M1(D6);
DigitalOut dir_M1(D7);
DigitalOut ledr(LED_RED);
DigitalOut ledg(LED_GREEN);
DigitalOut ledb(LED_BLUE);
Serial pc(USBTX, USBRX);
InterruptIn knop(SW2);
Ticker combiner;
Ticker updater;

int cw = 0;
int ccw = 1;

// PARAMETERS
int cal_time = 5;   // Duur van kalibratie
int n_cal = 10;     // Aantal metingen tijdens kalibratie
float threshold = 0.2;
float Fs = 300;     // Sample-frequentie [Hz]: aantal updates per seconde

volatile float EMG_biceps = 0;
volatile float EMG_triceps = 0;
volatile float EMG_biceps_norm;
volatile float EMG_triceps_norm;
volatile float EMG_biceps_max;
volatile float EMG_triceps_max;
volatile float EMG_combined_signal;

void input_b()
{
    EMG_biceps = EMG_biceps + 1;
    pc.printf("EMG_biceps = %f \tEMG_triceps = %f", EMG_biceps, EMG_triceps);
}

void input_n()
{
    EMG_biceps = EMG_biceps - 1;
    pc.printf("EMG_biceps = %f \tEMG_triceps = %f", EMG_biceps, EMG_triceps);
}

void input_t()
{
    EMG_triceps = EMG_triceps + 1;
    pc.printf("EMG_biceps = %f \tEMG_triceps = %f", EMG_biceps, EMG_triceps);
}

void input_y()
{
    EMG_triceps = EMG_triceps - 1;
    pc.printf("EMG_biceps = %f \tEMG_triceps = %f", EMG_biceps, EMG_triceps);
}

void combine_EMG()
{
//    EMG_biceps = EMG_biceps_raw.read();
    if(EMG_biceps > EMG_biceps_max)
    {
        EMG_biceps_norm = 1;
    }
    else
    {
        EMG_biceps_norm = EMG_biceps/EMG_biceps_max;        // scaled 0-1
    }
//    EMG_triceps = EMG_triceps_raw.read();
    if(EMG_triceps > EMG_triceps_max)
    {
        EMG_triceps_norm = 1;
    }
    else
    {
        EMG_triceps_norm = EMG_triceps/EMG_triceps_max;     // scaled 0-1
    }
    EMG_combined_signal = EMG_biceps_norm - EMG_triceps_norm;
}

void update_M1()
{
    if(EMG_combined_signal < (-1*threshold))
    {
        dir_M1 = ccw;
        pwm_M1 = (-1/(1-threshold) * EMG_combined_signal + threshold/(threshold-1));
    }
    else if(EMG_combined_signal > threshold)
    {
        dir_M1 = cw;
        pwm_M1 = (1/(1-threshold) * EMG_combined_signal + threshold/(threshold-1));
    }
    else
    {
        pwm_M1 = 0;
    }
}

void calibrate()
{
    combiner.detach();
    updater.detach();
    pwm_M1 = 0;
    pc.printf("Hold biceps at maximum contraction for %i seconds, starting in 3...", cal_time);
    wait(1);
    pc.printf(" 2...");
    wait(1);
    pc.printf(" 1...");
    wait(1);
    pc.printf("\r\nCalibrating...");
    
//    for(int meting = 1;meting >= n_cal;meting++);
//    {
//        read
//        total = total+read;
//        wait(cal_time/n_cal);
//    }
//    
//    EMG_max = total/n_cal;
    EMG_biceps_max = 10;
    EMG_triceps_max = 10;
    
    combiner.attach(&combine_EMG, (1/Fs));
    wait(1/(2*Fs));
    updater.attach(&update_M1, (1/Fs));
}

char c;
int main()
{
    pwm_M1 = 0;
    dir_M1 = cw;
    ledr = 1;
    ledg = 1;
    ledb = 1;
    pc.baud(115200);
    calibrate();
    knop.fall(calibrate);
    for(;;);
    {
        c = pc.getc();
        wait(0.01);
        switch(c)
        {
            case 'b':
            input_b();
            break;
            case 'n':
            input_n();
            break;
            case 't':
            input_t();
            break;
            case 'y':
            input_y();
            break;
            default:
            pc.printf("\nUnknown command\n\r");
        }
    }
}