#include "stdio.h"
#include "math.h"
#include "mbed.h"
#include "QEI.h"
#include "MODSERIAL.h"
#include "BiQuad.h"

MODSERIAL pc(USBTX, USBRX);
QEI wheel_M1 (D13, D12, NC, 32);
QEI wheel_M2 (D10, D11, NC, 32);
PwmOut pwm_M1 (D6);
PwmOut pwm_M2 (D5);
DigitalOut dir_M1 (D7);
DigitalOut dir_M2 (D4);

DigitalOut ledg (LED_GREEN);
DigitalOut ledr (LED_RED);
DigitalOut ledb (LED_BLUE);
InterruptIn knop_biceps(SW2);
InterruptIn knop_triceps(SW3);
InterruptIn knop_switch(D9);

volatile float q1 = 0;
volatile float q2 = 0;
volatile float q1_begin;
volatile float q2_begin;
const float pi = 3.14159265359;
const float l1 = 0.3626;
const float l2 = (0.420-0.065);     // middelpunt swiffer
volatile float q1_v;
volatile float q2_v;
volatile float q1_ref = 0;
volatile float q2_ref = 0;
volatile float q1_ref_prev = 0;
volatile float q2_ref_prev = 0;
volatile float q1_error = 0;
volatile float q2_error = 0;
volatile float q1_error_prev = 0;
volatile float q2_error_prev = 0;
volatile float q1DerivativeError = 0;
volatile float q2DerivativeError = 0;
volatile float q1IntError = 0;
volatile float q2IntError = 0;
volatile float q1_total_error= 0;
volatile float q2_total_error= 0;
float motorValue1Out = 0.0;
float motorValue2Out = 0.0;
volatile float ctrlOutput_M1 = 0;
volatile float ctrlOutput_M2 = 0;
volatile float vx;
volatile float vy;
volatile bool translatie_richting = true;  //true is verticaal, false is horizontaal

const float TS = 0.02;
const float MotorGain_M1 = 4.3;         // bij pwm = 1 draait (losse) motor met 4.3 rad/s -> gemeten
const float MotorGain_M2 = 4.7;         // gemeten

Ticker update_encoder_ticker;
volatile bool go_flag_update_encoder = false;
void flag_update_encoder()
{
    go_flag_update_encoder = true;
}

void update_encoder()
{
    //q1 = wheel_M1.getPulses()/(1334.355/2);
    //q2 = wheel_M2.getPulses()/(1334.355/2);
    //pc.printf("q1 = %f \tq1_ref = %f \tq2 = %f \tq2_ref = %f \ttotalerr1 = %f \ttotalerr2 = %f\n\r",q1, q1_ref,q2,q2_ref,q1_total_error,q2_total_error);
    //pc.printf("vx = %f \tvy = %f \tq1_v = %f \tq2_v = %f \tq1 = %f \tq2 = %f \tPID_M1 = %f \tPID_M2 = %f\n\r",vx,vy,q1_v,q2_v,q1,q2,ctrlOutput_M1,ctrlOutput_M2);
    //pc.printf("q1_err = %0.9f \tq2_err = %0.9f \tq1IntErr = %0.9f \tq2IntErr = %0.9f \tTotErr1 = %0.9f \tTotErr2 = %0.9f\n\r",q1_error,q2_error,q1IntError,q2IntError,q1_total_error,q2_total_error);
}

Ticker PIDcontrol;
volatile bool go_flag_controller = false;

void flag_controller()
{
    go_flag_controller = true;
}

volatile bool active_PID_ticker = false;

void begin_hoeken()
{
    wait(1.5);
    q1_ref = wheel_M1.getPulses()/(1334.355/2);
    q2_ref = wheel_M2.getPulses()/(1334.355/2);
    active_PID_ticker = true;
}

void initialize()
{
    dir_M1 = 0; //ccw
    dir_M2 = 1; //cw
    while ( (q1 < 20*2*pi/360) || (q2 > -45*2*pi/360) ) {
        q1 = wheel_M1.getPulses()/(1334.355/2);
        q2 = wheel_M2.getPulses()/(1334.355/2);
        if (q1 < 20*2*pi/360) {
            pwm_M1 = 0.05;
        } else {
            pwm_M1 = 0;
        }
        if (q2 > -45*2*pi/360) {
            pwm_M2 = 0.06;
        } else {
            pwm_M2 = 0;
        }
        wait(0.005f);
    }
    pwm_M1 = 0;
    pwm_M2 = 0;
    begin_hoeken();
}

void biceps()
{
    q1_ref_prev = 0;
    q2_ref_prev = 0;
    q1IntError = 0;
    q2IntError = 0;
    q1_error_prev = 0;
    q2_error_prev = 0;
    if (translatie_richting == true) {      // verticaal / up / blauw
        vx = 0;
        vy = 0.1;
    } else {                        // horizontaal / right / rood
        vx = 0.1;
        vy = 0;
    }
}

void triceps()
{
    q1_ref_prev = 0;
    q2_ref_prev = 0;
    q1IntError = 0;
    q2IntError = 0;
    q1_error_prev = 0;
    q2_error_prev = 0;
    if (translatie_richting == true) {      // verticaal / down / blauw
        vx = 0;
        vy = -0.1;
    } else {                        // horizontaal / left / rood
        vx = -0.1;
        vy = 0;
    }

}

void switcher()
{
    if ( (vx == 0) && (vy == 0) && (translatie_richting == true) ) {
        translatie_richting = false;
    } else if ( (vx == 0) && (vy == 0) && (translatie_richting == false) ) {
        translatie_richting = true;
    } else {
        vx = 0;
        vy = 0;
        q1_ref = q1;
        q2_ref = q2;
        q1_error = 0;
        q2_error = 0;
        q1IntError = 0;
        q2IntError = 0;
        q1_error_prev = 0;
        q2_error_prev = 0;
        q1_total_error = 0;
        q2_total_error = 0;
        pc.printf("\n\rSWITCH!!! \n\n\r");
    }

    if (translatie_richting == 1) {
        ledr = 1;                   // blauw - verticaal
        ledg = 1;
        ledb = 0;
    } else {
        ledr = 0;                   // rood - horizontaal
        ledg = 1;
        ledb = 1;
    }
}

Ticker update_ref_ticker;
volatile float J_1;
volatile float J_2;
volatile float J_3;
volatile float J_4;
volatile bool go_flag_update_ref = false;
void flag_update_ref()
{
    go_flag_update_ref = true;
}

void update_ref()
{
    q1 = wheel_M1.getPulses() / (1334.355/2);     // rad
    q2 = wheel_M2.getPulses() / (1334.355/2);

    J_1 = -(l2*sin(q1 + q2))/(l2*sin(q1 + q2)*(l2*cos(q1 + q2) + l1*cos(q1)) - l2*cos(q1 + q2)*(l2*sin(q1 + q2) + l1*sin(q1)));
    J_2 = (l2*cos(q1 + q2))/(l2*sin(q1 + q2)*(l2*cos(q1 + q2) + l1*cos(q1)) - l2*cos(q1 + q2)*(l2*sin(q1 + q2) + l1*sin(q1)));
    J_3 = (l2*sin(q1 + q2) + l1*sin(q1))/(l2*sin(q1 + q2)*(l2*cos(q1 + q2) + l1*cos(q1)) - l2*cos(q1 + q2)*(l2*sin(q1 + q2) + l1*sin(q1)));
    J_4 = -(l2*cos(q1 + q2) + l1*cos(q1))/(l2*sin(q1 + q2)*(l2*cos(q1 + q2) + l1*cos(q1)) - l2*cos(q1 + q2)*(l2*sin(q1 + q2) + l1*sin(q1)));

    q1_v = J_1 * vx + J_2 * vy;
    q2_v = J_3 * vx + J_4 * vy;

    //pc.printf("q1 = %f \tq2 = %f \tq1_v = %f \tq2_v = %f\n\r", q1,q2,q1_v,q2_v);

    if ( (q1 > (135*2*pi/360)) && (q1_v > 0 ) ) {                // WAARDES VINDEN 0.8726 (50 graden)
        q1_v = 0;
        q2_v = 0;
        q1_ref = q1;
        q2_ref = q2;
        q1IntError = 0;
        q2IntError = 0;
        q1_error_prev = 0;
        q2_error_prev = 0;
    } else if ( (q1 < -(135*2*pi/360)) && (q1_v < 0) ) {
        q1_v = 0;
        q2_v = 0;
        q1_ref = q1;
        q2_ref = q2;
        q1IntError = 0;
        q2IntError = 0;
        q1_error_prev = 0;
        q2_error_prev = 0;
    } else if ( (q2 < (-2.6)) && (q2_v < 0) ) {        // WAARDES VINDEN -2.4434 (-140 graden) --> werkelijke max -2.672452
        q1_v = 0;
        q2_v = 0;
        q1_ref = q1;
        q2_ref = q2;
        q1IntError = 0;
        q2IntError = 0;
        q1_error_prev = 0;
        q2_error_prev = 0;
    } else if ( (q2 >= 0) && (q2_v > 0) ) {
        q1_v = 0;
        q2_v = 0;
        q1_ref = q1;
        q2_ref = q2;
        q1IntError = 0;
        q2IntError = 0;
        q1_error_prev = 0;
        q2_error_prev = 0;
    }
    
    q1_ref_prev = q1_ref;
    q2_ref_prev = q2_ref;
    
    q1_ref = q1_ref_prev + q1_v*TS;
    q2_ref = q2_ref_prev + q2_v*TS;
}

void PID(float q1,float q1_ref,float q2,float q2_ref,float TS,float &motorValue1Out, float &motorValue2Out)
{
    // linear feedback control
    q1_error = q1_ref - q1; //referencePosition1 - Position1;             // proportional angular error in radians
    q2_error = q2_ref - q2; //referencePosition1 - Position1;             // proportional angular error in radians
    float Kp = 10;

    q1IntError = q1IntError + q1_error*TS;             // integrated error in radians
    q2IntError = q2IntError + q2_error*TS;             // integrated error in radians
    float Ki = 1;

    q1DerivativeError = (q1_error - q1_error_prev)/TS;  // derivative of error in radians
    q2DerivativeError = (q2_error - q2_error_prev)/TS;  // derivative of error in radians
    float Kd = 0;

    q1_total_error = (q1_error * Kp) + (q1IntError * Ki) + (q1DerivativeError * Kd);         //total controller output = motor input
    q2_total_error = (q2_error * Kp) + (q2IntError * Ki) + (q2DerivativeError * Kd);         //total controller output = motor input

    motorValue1Out = q1_total_error/MotorGain_M1;
    motorValue2Out = q2_total_error/MotorGain_M2;
    
    q1_error_prev = q1_error;
    q2_error_prev = q2_error;
}

void Controller()
{
    PID(q1,q1_ref,q2,q2_ref,TS,motorValue1Out,motorValue2Out);
    ctrlOutput_M1 = motorValue1Out;
    ctrlOutput_M2 = motorValue2Out;

    pc.printf("q1_err = %0.9f \tq2_err = %0.9f \tq1IntErr = %0.9f \tq2IntErr = %0.9f  \tq1_ref = %0.9f \tq2_ref = %0.9f \tq1 = %f \tq2 = %f\n\r",q1_error,q2_error,q1IntError,q2IntError,q1_ref,q2_ref,q1,q2);

    if (ctrlOutput_M1 < 0) {
        dir_M1 = 1;
    } else {
        dir_M1 = 0;
    }
    pwm_M1 = abs(ctrlOutput_M1);
    if (pwm_M1 <= 0) {
        pwm_M1 = 0;
    } else {
        pwm_M1 = pwm_M1 + 0.05;
    }

    if (ctrlOutput_M2 < 0) {
        dir_M2 = 1;
    } else {
        dir_M2 = 0;
    }
    pwm_M2 = abs(ctrlOutput_M2);
    if (pwm_M2 <= 0) {
        pwm_M2 = 0;
    } else {
        pwm_M2 = pwm_M2 + 0.05;
    }
}

int main()
{
    ledr = 1;
    ledg = 1;
    ledb = 0;
    pc.baud(115200);
    wheel_M1.reset();
    wheel_M2.reset();
    knop_biceps.rise(&biceps);
    knop_triceps.rise(&triceps);
    knop_switch.rise(&switcher);
    
    // initialize -> beginposities
    initialize();
    
    // flag functions/tickers
    update_encoder_ticker.attach(&flag_update_encoder, TS);
    update_ref_ticker.attach(&flag_update_ref, TS);

    if (active_PID_ticker == true) {
        PIDcontrol.attach(&flag_controller, TS);
    }

    while(1) {

        // update encoder
        if (go_flag_update_encoder == true) {
            go_flag_update_encoder = false;
            update_encoder();
        }
        // update joint positions/velocities
        if (go_flag_update_ref == true) {
            go_flag_update_ref = false;
            update_ref();
        }
        // controller M1+M2
        if (go_flag_controller == true) {
            go_flag_controller = false;
            Controller();
        }
    }
}