#include "mbed.h"
#include "MODSERIAL.h"

PwmOut pwm_M1(D6);
DigitalOut dir_M1(D7);
PwmOut pwm_M2(D5);
DigitalOut dir_M2(D4);
MODSERIAL pc(USBTX, USBRX);
int cw = 0;
int ccw = 1;
char input;
volatile float float_pwm1;
volatile bool bool_dir1 = false;
volatile float float_pwm2;
volatile bool bool_dir2 = false;

void input_u()
{
    if(pwm_M1 <= 0.95)
    {
        pwm_M1 = pwm_M1 + 0.05;
        float_pwm1 = float_pwm1+0.05;
        pc.printf("Speed M1 is set to: %f\n\r", float_pwm1);
    }
    else
    {
        pwm_M1 = (1);
        float_pwm1 = 1;
        pc.printf("\nSpeed M1 is maximum\r\n");
    }
}

void input_i()
{
    if(pwm_M2 <= 0.95)
    {
        pwm_M2 = pwm_M2 + 0.05;
        float_pwm2 = float_pwm2+0.05;
        pc.printf("Speed M2 is set to: %f\n\r", float_pwm2);
    }
    else
    {
        pwm_M2 = (1);
        float_pwm2 = 1;
        pc.printf("\nSpeed M2 is maximum\r\n");
    }
}

void input_d()
{
    if(pwm_M1 >= 0.05)
    {
        pwm_M1 = (pwm_M1 - 0.05);
        float_pwm1 = float_pwm1-0.05;
        pc.printf("Speed M1 is set to: %f\n\r", float_pwm1);
    }
    else
    {
        pwm_M1 = (0);
        float_pwm1 = 0;
        pc.printf("\nSpeed M1 is minimum\r\n");
    }
}

void input_f()
{
    if(pwm_M2 >= 0.05)
    {
        pwm_M2 = (pwm_M2 - 0.05);
        float_pwm2 = float_pwm2-0.05;
        pc.printf("Speed M2 is set to: %f\n\r", float_pwm2);
    }
    else
    {
        pwm_M2 = (0);
        float_pwm2 = 0;
        pc.printf("\nSpeed M2 is minimum\r\n");
    }
}

void input_c()
{
    float pwm_original1 = pwm_M1;
    while(pwm_M1>0)
    {
        pwm_M1 = pwm_M1 - 0.1;
        wait(0.1);
    }
    dir_M1 = !dir_M1;
    while(pwm_M1 < pwm_original1)
    {
        pwm_M1 = pwm_M1 + 0.1;
        wait(0.1);
    }
    bool_dir1 = !bool_dir1;
    if(dir_M1 == cw)
    {
        pc.printf("\nDirection M1 is set to: clockwise\r\n");
        
        pc.printf("Direction M1: %B\r\n", bool_dir1);
    }
    else
    {
        pc.printf("\nDirection M1 is set to: counter-clockwise\r\n");
        
        pc.printf("Direction M1: %B\r\n", bool_dir1);
    }
}

void input_v()
{
    float pwm_original2 = pwm_M2;
    while(pwm_M2>0)
    {
        pwm_M2 = pwm_M2 - 0.1;
        wait(0.1);
    }
    dir_M2 = !dir_M2;
    while(pwm_M2 < pwm_original2)
    {
        pwm_M2 = pwm_M2 + 0.1;
        wait(0.1);
    }
    bool_dir2 = !bool_dir2;
    if(dir_M2 == cw)
    {
        pc.printf("\nDirection M2 is set to: clockwise\r\n");
        
        pc.printf("Direction M2: %B\r\n", bool_dir2);
    }
    else
    {
        pc.printf("\nDirection M2 is set to: counter-clockwise\r\n");
        
        pc.printf("Direction M2: %B\r\n", bool_dir2);
    }
}

int main()
{
    pc.baud(115200);
    pwm_M1 = 0.5;
    pwm_M2 = 0.5;
    float_pwm1 = 0.5;
    float_pwm2 = 0.5;
    dir_M1 = cw;
    dir_M2 = cw;
    for(;;){
    input = pc.getc();
    wait(0.01);
    switch(input)
    {
        case 'u':
        input_u();
        break;
        case 'd':
        input_d();
        break;
        case 'c':
        input_c();
        break;
        case 'i':
        input_i();
        break;
        case 'f':
        input_f();
        break;
        case 'v':
        input_v();
        break;
        default:
        pc.printf("\nUnknown command\n\r");
    }
    }
}