#ifndef ANGLE_ENCODER_H
#define ANGLE_ENCODER_H
 
#include "mbed.h"
 
#define SPI_DELAY 4 // must be 4 or greater, otherwise the angle encoder can't keep up with the communication
 
class AngleEncoder {
public:
    AngleEncoder(PinName mosi, PinName miso, PinName sclk, PinName cs, int bits, int mode, int hz);
    int nop();
    int absolute_angle();
    bool set_zero();
    bool set_zero(int*);
    
private:  
    SPI _spi;
    DigitalOut _cs;
};
 
#endif