#ifndef MOTOR_CONTROL_H
#define MOTOR_CONTROL_H
 
#include "mbed.h"

#define CHECK_TIME 50 // Check every 50us to make sure both sides of the h bridge aren't ON at the same time
 
class MotorControl {
public:
    MotorControl(PinName forward, PinName backward, int period, int safetyPeriod);
    void forward(float, uint32_t);
    void backward(float, uint32_t);
    void forward(int);
    void backward(int);
    
private:  
    bool _invert; // used to change the polarity of the motors (i.e. what is considered forward/backward)
    DigitalOut _forward;
    DigitalOut _backward;
    int _period;
    int _safetyPeriod;
};
 
#endif