#include "PID.h"

double PID( double err, const double Kp, const double Ki, const double Kd, const double Ts, const double N, double &v1, double &v2 ) {
// These variables are only calculated once!
const double a1 = -4/(N*Ts+2), 
a2 = -(N*Ts-2)/(N*Ts+2), 
b0 = (4*Kp + 4*Kd*N + 2*Ki*Ts + 2*Kp*N*Ts + Ki*N*pow(Ts,2))/(2*N*Ts + 4), 
b1 = (Ki*N*pow(Ts,2) - 4*Kp - 4*Kd*N)/(N*Ts + 2),
b2 = (4*Kp + 4*Kd*N - 2*Ki*Ts - 2*Kp*N*Ts + Ki*N*pow(Ts,2))/(2*N*Ts + 4);

double v = err - a1*v1 - a2*v2;
double u = b0*v + b1*v1 + b2*v2;
v2 = v1; v1 = v;
return u;
}