#include "FilterDesign2.h"
#include "Filter2.h"
    
    // Notch 50 Hz 
    double w1_50 = 0, w2_50 = 0;
    const double a1_50 = -1.53713228931, a2_50 = 0.90250000000;
    const double b0_50 = 1.00000000000, b1_50 = -1.61803398875, b2_50 = 1.00000000000;
    const double gain_50 = 0.95500000000;
    
    // Notch 25 Hz 
    double w1_25 = 0, w2_25 = 0;
    const double a1_25 = -1.52753439307, a2_25 = 0.60559524000;
    const double b0_25 = 1.00000000000, b1_25 = -1.90211303259, b2_25 = 1.00000000000;
    const double gain_25 = 0.80000000000;
    
    // Notch 100 Hz
    double w1_100 = 0, w2_100 = 0;
    const double a1_100 = -0.58713228931, a2_100 = 0.90250000000;
    const double b0_100 = 1.00000000000, b1_100 = -0.61803398875, b2_100 = 1.00000000000;
    const double gain_100 = 0.95200000000;
    
    // Notch 200 Hz
    double w1_200 = 0, w2_200 = 0;
    const double a1_200 = 1.53713228931, a2_200 = 0.90250000000;
    const double b0_200 = 1.00000000000, b1_200 = 1.61803398875, b2_200 = 1.00000000000;
    const double gain_200 = 0.95500000000;
    
    // High pass 10 Hz (oud)
    double w1_HP = 0, w2_HP = 0;
    const double a1_HP = -1.91258127190, a2_HP = 0.91680625000;
    const double b0_HP = 1.00000000000, b1_HP = -2.00000000000, b2_HP = 1.00000000000;
    const double gain_HP = 0.95500000000;
    /*
    // High pass 40 Hz
    double w1_HP = 0, w2_HP = 0;
    const double a1_HP = -1.51877533120, a2_HP = 0.60062500000;
    const double b0_HP = 1.00000000000, b1_HP = -2.00000000000, b2_HP = 1.00000000000;
    const double gain_HP = 0.78000000000;
    */
    /*
    // High pass 50 Hz 
    double w1_HP = 0, w2_HP = 0;
    const double a1_HP = -1.47413760026, a2_HP = 0.60062500000;
    const double b0_HP = 1.00000000000, b1_HP = -2.00000000000, b2_HP = 1.00000000000;
    const double gain_HP = 0.77000000000;
    */
    /*
    // Low pass 11 Hz (oud)
    double w1_LP = 0, w2_LP = 0;
    const double a1_LP =  -1.67736610515, a2_LP = 0.72250000000;
    const double b0_LP = 1.00000000000, b1_LP = 2.00000000000, b2_LP = 1.00000000000;
    const double gain_LP = 0.0120000000000;
    
    // Low pass 0.7 Hz
    double w1_LP = 0, w2_LP = 0;
    const double a1_LP =  -1.80000000000, a2_LP = 0.81000000000;
    const double b0_LP = 1.00000000000, b1_LP = 2.00000000000, b2_LP = 1.00000000000;
    const double gain_LP = 0.0025100000000;
    */
    /*
    // Low pass 3 Hz
    double w1_LP = 0, w2_LP = 0;
    const double a1_LP =  -1.70000000000, a2_LP = 0.72250000000;
    const double b0_LP = 1.00000000000, b1_LP = 2.00000000000, b2_LP = 1.00000000000;
    const double gain_LP = 0.0060000000000;
    */
    // Low pass 2 Hz
    double w1_LP = 0, w2_LP = 0;
    const double a1_LP =  -1.99277224437, a2_LP = 0.99281296000;
    const double b0_LP = 1.00000000000, b1_LP = 2.00000000000, b2_LP = 1.00000000000;
    const double gain_LP = 0.0001000000000;

    
double FilterDesign2(double u_E)
{
    double y_25 = Filter2(u_E,w1_25,w2_25,a1_25,a2_25,b0_25,b1_25,b2_25,gain_25);
    double y_50 = Filter2(y_25,w1_50,w2_50,a1_50,a2_50,b0_50,b1_50,b2_50,gain_50);
    // double y_100 = Filter2(u,w1_100,w2_100,a1_100,a2_100,b0_100,b1_100,b2_100,gain_100);
    // double y_200 = Filter2(y_100,w1_200,w2_200,a1_200,a2_200,b0_200,b1_200,b2_200,gain_200);
    double y_HP = Filter2(y_50,w1_HP,w2_HP,a1_HP,a2_HP,b0_HP,b1_HP,b2_HP,gain_HP);
    double y_abs = fabs(y_HP);
    double y_LP = Filter2(y_abs,w1_LP,w2_LP,a1_LP,a2_LP,b0_LP,b1_LP,b2_LP,gain_LP);
    
    double y_E = y_LP;
    
    return y_E; 
    
}